var nfRecurlyController = Marionette.Object.extend({
    modal: false,
    formModel: false,
    initialize: function() {

        if( 'undefined' == typeof recurly ) return;
        if( 'undefined' == typeof nfRecurly ) return;

        /*
         * After we click the submit button, show a modal.
         */
        this.listenTo( nfRadio.channel( 'form' ), 'render:view', this.registerSubmitListener );
        var that = this;

        this.listenTo( nfRadio.channel( 'forms' ), 'submit:response', this.submitResponse );

        /*
         * When we click on the recurly submit button, try to create a recurly token.
         */
        var recurly_form = jQuery( '#nf-recurly-credit-card' ).find( 'form' );
        jQuery( recurly_form ).on( 'submit', function ( e ) {
            e.preventDefault();
            var form = this;
            jQuery( '#nf-recurly-credit-card' ).find( '.nf-recurly-loader' ).show();
            jQuery( form ).hide();
            /*
             * Remove all errors.
             */
            jQuery( form ).find( '.nf-recurly-error' ).html('');
            var fields = [
              'last_name',
              'first_name',
              'number',
              'year',
              'month',
              'cvv',
              'postal_code',
            ];
            for (var i = fields.length - 1; i >= 0; i--) {
              var recurlyField = jQuery( form ).find( "[data-recurly='" + fields[ i ] + "']" );
              recurlyField.removeClass( 'recurly-error' )
            }

            recurly.token( form, function ( err, token ) {
              if ( err ) {
                /*
                 * Hide our loading indicator.
                 */
                jQuery( '#nf-recurly-credit-card' ).find( '.nf-recurly-loader' ).hide();

                /*
                 * Show our form again.
                 */
                jQuery( '#nf-recurly-credit-card' ).find( 'form' ).show();

                // handle error using err.code and err.fields
                for (var i = err.fields.length - 1; i >= 0; i--) {
                  jQuery( form ).find( "[data-recurly='" + err.fields[ i ] + "']" ).addClass( 'recurly-error' );
                }
                var recurly_form = jQuery( '#nf-recurly-credit-card' );
                var recurly_form_error = recurly_form.find( '.nf-recurly-error' );
                recurly_form_error.html( 'Please correct errors before continuing' );
                recurly_form.find( '.nf-recurly-submit' ).val( 'Subscribe' ).blur();
                nfRadio.channel( 'form-' + that.formModel.get( 'id' ) ).request( 'remove:extra', 'recurly_token' );
              } else {
                // recurly.js has filled in the 'token' field, so now we can submit the
                // form to your server; alternatively, you can access token.id and do
                // any processing you wish
                // Set Recurly Extra Data
                nfRadio.channel( 'form-' + that.formModel.get( 'id' ) ).request( 'add:extra', 'recurly_token', token.id );
                // Restart Submission
                nfRadio.channel( 'form-' + that.formModel.get( 'id' ) ).request( 'submit', that.formModel );

              }
            } );
        } );

        var that = this;
        jQuery( recurly_form ).find( '.nf-recurly-cancel' ).click( function() {
            that.modal.close();
        } );
    },

    registerSubmitListener: function( layoutView ) {
      var formData = _.findWhere( nfRecurly.forms, { id: layoutView.model.get( 'id' ) } );
      if ( 'undefined' == typeof formData ) return true;

      var that = this;
      this.formModel = layoutView.model;

      var $recurlyContainer = jQuery( '#nf-recurly-credit-card' );

      this.modal = new jBox( 'Modal', {
        content: $recurlyContainer,

        onClose: function() {
          nfRadio.channel( 'forms' ).trigger( 'submit:failed', that.formModel );
          nfRadio.channel( 'form-' + that.formModel.get( 'id' ) ).trigger( 'submit:failed', that.formModel );
        },

        onCreated: function() {
          // Init Recurly
          recurly.configure( {
              publicKey: nfRecurly.publicKey,
              style: {
                all: {
                  fontFamily: 'Open Sans',
                  fontSize: '1rem',
                  fontWeight: 'bold',
                  fontColor: '#2c0730'
                },
                number: {
                  placeholder: '•••• •••• •••• ••••'
                },
                month: {
                  placeholder: 'mm'
                },
                year: {
                  placeholder: 'yy'
                },
                cvv: {
                  placeholder: '•••'
                }
              }
          } );

          recurly.on('change', function( e ) {
              var brand = e.fields.number.brand;
              switch( brand ) {
                  case 'american_express':
                      brand = 'american-express';
                      break;
                  case 'master':
                      brand = 'mastercard';
                      break;
                  case 'diners_club':
                      brand = 'diners';
                  case 'unknown':
                      brand = 'credit-card';
                  default:
                      break;
              }

              jQuery( '.nf-recurly-card-icon' ).html( '<i class="pf pf-' + brand + '"></i>' );
          } );

          /* Dynamically Add Billing Fields. */
          var fields = [
            'last_name',
            'first_name',
            'address1',
            'address2',
            'city',
            'state',
            'zip',
            'country',
          ];
          for (var i = fields.length - 1; i >= 0; i--) {
            var formID = layoutView.model.get( 'id' );
            var formModel = layoutView.model;
            var setting = 'recurly_' + fields[i];
            var settingValue = nfRecurlyForm[ formID ][ setting ]

            /* Check for the address setting in the action. */
            if( settingValue ){

              /* Get value from merge tags. */
              var fieldMergeTags = settingValue.match( new RegExp( /{field:(.*?)}/g ) );
              if( fieldMergeTags ){
                _.each( fieldMergeTags, function( mergeTag ) {
                    var fieldKey = mergeTag.replace( '{field:', '' ).replace( '}', '' );
                    var fieldModel = formModel.get( 'fields' ).findWhere({ key: fieldKey });
                    if( 'undefined' == typeof fieldModel ) return;
                    settingValue = settingValue.replace( mergeTag, fieldModel.get( 'value' ) );
                }, this );
              }

              if( -1 !== jQuery.inArray( fields[i], [ 'zip', 'first_name', 'last_name' ]) ){
                var lookup = fields[i];
                if( 'zip' == fields[i] ) lookup = 'postal_code';
                /* Pre-populate the postal_code field. */
                $recurlyContainer.find( "[data-recurly='" + lookup + "']" ).val( settingValue );
              } else {

                /* Create the input dynamically. */
                var input = document.createElement( 'input' );
                input.type = 'hidden';
                input.setAttribute( 'data-recurly', fields[i] );
                input.value = settingValue;

                /* Add new field to the form. */
                $recurlyContainer.find('form').append(input);
              }
            }
          }
        }
      } );


      var formID = layoutView.model.get( 'id' );

      /*
       * This is a recurly form, register a checkout modal before we submit.
       */
      Backbone.Radio.channel( 'form-' + formID ).reply( 'maybe:submit', this.beforeSubmit, this, formID );


      this.listenTo( nfRadio.channel( 'forms' ), 'submit:response', this.maybeClearTokens );
    },

    beforeSubmit: function( formID ) {
      var formModel = Backbone.Radio.channel( 'app' ).request( 'get:form', formID );

      if( 0 !== formModel.get( 'errors' ).length ) return true;

      var recurlyData = _.findWhere( nfRecurly.forms, { id: formModel.get( 'id' ) } );

      /*
       * Loop through our recurly actions and make sure that they aren't all deactivated.
       */
      var active = false;

      _.each( recurlyData.actions, function( actionID ) {
        if ( ! active ) {
          var request = Backbone.Radio.channel( 'actions' ).request( 'get:status', actionID );
          active = ( 'undefined' != typeof request ) ? request : true;
        }
      } );

      /*
       * If we have no active recurly actions, continue with submission.
       */
      if ( ! active ) return true;

      /*
       * If a Recurly Token already exists, continue with submission.
       */
      if( formModel.getExtra( 'recurly_token' ) ) return true;

      this.modal.open();
      return false;
    },

    submitResponse: function( response, textStatus, jqXHR, formID ) {
      var formData = _.findWhere( nfRecurly.forms, { id: formID } );
      if ( 'undefined' == typeof formData ) return true;

      var that = this;

      var recurly_form = jQuery( '#nf-recurly-credit-card' );
      var recurly_form_error = recurly_form.find( '.nf-recurly-error' );
      recurly_form.find( '.nf-recurly-submit' ).val( 'Subscribe' ).blur();

      /*
       * If we have errors but they aren't recurly, remove our token and close the modal.
       */
      if ( 0 < Object.keys(response.errors).length && 'undefined' == typeof response.errors.recurly ) {
        nfRadio.channel( 'form-' + formID ).request( 'remove:extra', 'recurly_token' );
        /*
         * Hide our loading indicator.
         */
        jQuery( '#nf-recurly-credit-card' ).find( '.nf-recurly-loader' ).hide();

        /*
         * Show our form again.
         */
        jQuery( '#nf-recurly-credit-card' ).find( 'form' ).show();
        that.modal.close();
      } else if ( 0 < Object.keys(response.errors).length && 'undefined' !== typeof response.errors.recurly ) { // We have recurly errors

        /*
         * Hide our loading indicator.
         */
        jQuery( '#nf-recurly-credit-card' ).find( '.nf-recurly-loader' ).hide();

        /*
         * Show our form again.
         */
        jQuery( '#nf-recurly-credit-card' ).find( 'form' ).show();

        recurly_form_error.html( response.errors.recurly.msg );
        /*
         * Add error classes to the relevant field
         */
        switch( response.errors.recurly.code ) {
          case 'fraud_security_code':
            recurly_form.find( '[data-recurly="cvv"]' ).addClass( 'recurly-error' );
            break;
          case 'fraud_address':
            recurly_form.find( '[data-recurly="postal_code"]' ).addClass( 'recurly-error' );
            break;
          case 'invalid_card_number':
            recurly_form.find( '[data-recurly="number"]' ).addClass( 'recurly-error' );
            break;
          case 'declined_expiration_date':
            recurly_form.find( '[data-recurly="month"]' ).addClass( 'recurly-error' );
            recurly_form.find( '[data-recurly="year"]' ).addClass( 'recurly-error' );
            break;
        }

        nfRadio.channel( 'form-' + formID ).request( 'remove:extra', 'recurly_token' );
      } else { // No errors, load on.

        jQuery( '.circle-loader' ).toggleClass( 'load-complete' );
        jQuery( '.checkmark' ).toggle( function() {
          setTimeout(  function( that ) {
            that.modal.close();
          }, 900, that );
        } );
      }
    }
});

jQuery( document ).ready( function( $ ) {
    new nfRecurlyController();
});
