var myListController = Marionette.Object.extend({

    initialize: function() {
        // Listen to the click:extra on our recurly plan setting
        this.listenTo( Backbone.Radio.channel( 'setting-type-recurly_plan' ), 'click:extra', this.fetchPlans );
    },

    fetchPlans: function( e, settingModel, dataModel, settingView ) {
        var data = {
            action: 'nf_recurly_fetch_plans',
            security: nfAdmin.ajaxNonce
        };

        var that = this;
        jQuery( e.srcElement ).addClass( 'spin' );
        
        jQuery.post( ajaxurl, data, function( response ){
            var response = JSON.parse( response );
            settingModel.set( 'options', response );
            settingView.render();
        }).always( function() {
            jQuery( e.srcElement ).removeClass( 'spin' );
        });
    }

});

jQuery( document ).ready( function() {
    new myListController();
} );