<?php if ( ! defined( 'ABSPATH' ) ) exit;

class NF_EmailOctopus_Response
{
    private $status;
    private $details;

    public function __construct( $status, $details = array() )
    {
        $this->status  = $status;
        $this->details = $details;
    }

    public function __get( $property )
    {
        if( ! isset( $this->$property ) ) return null;
        return $this->$property;
    }

    public static function createFromResponse( $response )
    {
        $status = wp_remote_retrieve_response_code( $response );

        if( is_wp_error( $response ) ){
            // Return a "null" object without data.
            return new self( $status );
        }

        $body = json_decode( wp_remote_retrieve_body( $response ) );

        if( isset( $body->data ) ){
            // Paged data is stored nested.
            return new self( $status, $body->data );
        }

        return new self( $status, $body );
    }
}
