<?php if ( ! defined( 'ABSPATH' ) ) exit;

class NF_EmailOctopus_Plugin
{
    private $version;
    private $url;
    private $dir;

    public function __construct( $version, $file )
    {
        $this->version = $version;
        $this->url = plugin_dir_url( $file );
        $this->dir = plugin_dir_path( $file );
    }

    public function init()
    {
        add_action( 'admin_init',     array( $this, 'setup_license'   ) );
        add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );

        add_action( 'ninja_forms_loaded', array( $this, 'setup_submission_metabox' ) );

        add_filter( 'ninja_forms_register_actions', array( $this, 'register_actions' ) );

        add_filter( 'ninja_forms_plugin_settings',        array( $this, 'plugin_settings'        ), 10, 1 );
        add_filter( 'ninja_forms_plugin_settings_groups', array( $this, 'plugin_settings_groups' ), 10, 1 );
    }

    /*
    |--------------------------------------------------------------------------
    | Hooks and Filters
    |--------------------------------------------------------------------------
    */

    public function setup_license()
    {
        if ( ! class_exists( 'NF_Extension_Updater' ) ) return;
        new NF_Extension_Updater( 'EmailOctopus', $this->version(), 'The WP Ninjas', $this->dir(), 'emailoctopus' );
    }

    public function load_textdomain()
    {
        load_plugin_textdomain( 'ninja-forms-email0octopus', false, basename( dirname( __FILE__ ) ) . '/lang' );
    }

    public function setup_submission_metabox()
    {
        if( ! is_admin() ) return;
        require_once $this->dir( 'includes/metabox.php' );
        new NF_EmailOctopus_Metabox();
    }

    public function register_actions( $actions )
    {
        require_once $this->dir( 'includes/action.php' );
        $actions[ 'emailoctopus' ] = new NF_EmailOctopus_Action();
        return $actions;
    }

    public function plugin_settings( $settings )
    {
        $settings[ 'emailoctopus' ] = array(
            'emailoctopus_api_key' => array(
                'id'    => 'emailoctopus_api_key',
                'type'  => 'textbox',
                'label' => __( 'API Key', 'ninja-forms-emailoctopus' ),
                'desc'  => sprintf(
                    __( 'Grab your %sAPI Key%s from your EmailOctopus account.', 'ninja-forms-mail-chimp' ),
                    '<a href="https://ninjaforms.com/docs/emailoctopus" target="_blank">', '</a>'
                ),
            ),
        );
        return $settings;
    }
    public function plugin_settings_groups( $groups )
    {
        $groups = array_merge( $groups, array(
            'emailoctopus' => array(
                'id' => 'emailoctopus',
                'label' => __( 'EmailOctopus', 'ninja-forms' ),
            ),
        ) );
        return $groups;
    }

    /*
    |--------------------------------------------------------------------------
    | Internal API
    |--------------------------------------------------------------------------
    */

    public function api( $api_key, $version = '1.2' )
    {
        return new NF_EmailOctopus_API( $api_key, $version );
    }

    /*
    |--------------------------------------------------------------------------
    | Plugin Methods
    |--------------------------------------------------------------------------
    */

    public function version()
    {
        return $this->version;
    }

    public function url( $url = '' )
    {
        return trailingslashit( $this->url ) . $url;
    }

    public function dir( $path = '' )
    {
        return trailingslashit( $this->dir ) . $path;
    }

    public function template( $file, $args = array() )
    {
        $path = $this->dir( 'templates/' . $file );
        if( ! file_exists(  $path ) ) return '';
        extract( $args );

        ob_start();
        include $path;
        return ob_get_clean();
    }

}
