<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class NF_EmailOctopus_Metabox extends NF_Abstracts_SubmissionMetabox
{
    public function __construct()
    {
        parent::__construct();

        $this->_title = __( 'EmailOctopus Subscription', 'ninja-forms' );

        if( $this->sub && ! $this->sub->get_extra_value( 'emailoctopus' ) ){
            remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        }
    }

    public function render_metabox( $post, $metabox )
    {
        $details = $this->sub->get_extra_value( 'emailoctopus' );

        $data = array();

        if( isset( $details[ 'id' ] ) ){
            $label = __( 'Confirmation', 'ninja-forms-emailoctopus' );
            $data[ $label ] = $details[ 'id' ];
        }

        if( isset( $details[ 'first_name' ] ) ){
            $label = __( 'First Name', 'ninja-forms-emailoctopus' );
            $data[ $label ] = $details[ 'first_name' ];
        }

        if( isset( $details[ 'last_name' ] ) ){
            $label = __( 'Last Name', 'ninja-forms-emailoctopus' );
            $data[ $label ] = $details[ 'last_name' ];
        }

        if( isset( $details[ 'error' ] ) ){
            $label = __( 'Error', 'ninja-forms-emailoctopus' );
            $data[ $label ] = $details[ 'error' ]->message;
        }

        ?>
        <ul>
            <?php foreach( $data as $label => $value ):?>
                <li>
                    <strong><?php echo $label; ?></strong>
                    <br /><?php echo $value; ?>
                </li>
            <?php endforeach; ?>
        </ul>
        <?php
    }
}
