<?php if ( ! defined( 'ABSPATH' ) ) exit;

class NF_EmailOctopus_API
{
    const URL = 'https://emailoctopus.com/api/';
    private $api_key;
    private $version;

    public function __construct( $api_key = '', $version = '1.2' )
    {
        $this->api_key = $api_key;
        $this->version = $version;
    }

    public function request( $method, $endpoint, $data = array(), $args = array() )
    {
        $args[ 'method' ] = strtoupper( $method );

        if( 'GET' == $args[ 'method' ] ){
            $url = $this->url( $endpoint, $data );
        } else {
            $url = $this->url( $endpoint );
            $args[ 'body' ] = array_merge( $data, array( 'api_key' => $this->api_key ) );
        }

        $response = wp_remote_request( $url, $args );
        return NF_EmailOctopus_Response::createFromResponse( $response );
    }

    private function url( $endpoint = '', $args = array() )
    {
        $url = trailingslashit( self::URL );
        $url = trailingslashit( $url . $this->version );
        $url = add_query_arg( 'api_key', $this->api_key, $url . $endpoint );

        if( $args ){
            $url = add_query_arg( $args, $url );
        }

        return $url;
    }
}
