<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_Action' )) exit;

class NF_EmailOctopus_Action extends NF_Abstracts_Action
{
    protected $_name  = 'emailoctopus';
    protected $_tags = array();
    protected $_timing = 'late';
    protected $_priority = '9';
    protected $_image = 'data:image/png;base64,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';

    protected $api;

    public function __construct()
    {
        parent::__construct();
        $this->_nicename = __( 'EmailOctopus', 'ninja-forms' );

        $api_key = Ninja_Forms()->get_setting( 'emailoctopus_api_key', false );
        if( ! $api_key ) return;

        $this->api = NF_EmailOctopus()->api( $api_key );

        if( isset( $_GET[ 'page' ] ) && 'ninja-forms' == $_GET[ 'page' ] ) {
            $this->setup_settings();
        }
    }

    /*
    * PUBLIC METHODS
    */

    public function save( $action_settings )
    {
        // This section intentionally left blank.
    }

    public function process( $action_settings, $form_id, $data )
    {
        if( ! $action_settings[ 'list' ] ) {
            $data[ 'debug' ][ 'emailoctopus' ] = __( 'No list specified', 'ninja-forms-emailoctopus' );
            return $data;
        }

        if( ! $action_settings[ 'email_address' ] ) {
            $data[ 'debug' ][ 'emailoctopus' ] = __( 'No email address specified', 'ninja-forms-emailoctopus' );
            return $data;
        }

        $vars = array(
            'email_address' => trim( $action_settings[ 'email_address' ] )
        );

        if( $action_settings[ 'first_name' ] ) {
            $vars[ 'first_name' ] = trim( $action_settings[ 'first_name' ] );
        }

        if( $action_settings[ 'last_name' ] ) {
            $vars[ 'last_name' ] = trim( $action_settings[ 'last_name' ] );
        }

        $response = $this->api->request( 'POST', "lists/{$action_settings[ 'list' ]}/contacts", $vars );

        if( $response->details ){
            if( isset( $data[ 'actions' ][ 'save' ][ 'sub_id' ] ) ){
                $sub = Ninja_Forms()->form()->sub( $data[ 'actions' ][ 'save' ][ 'sub_id' ] )->get();
                $sub->update_extra_value( 'emailoctopus', get_object_vars( $response->details ) );
                $sub->save();
            }
        } else {
            /* DEBUG */ echo "<pre>"; var_dump( $response ); echo "</pre>";
            die();
        }

        return $data;
    }

    private function setup_settings()
    {
        $this->_settings[ 'list' ] = array(
            'name' => 'list',
            'type' => 'select',
            'label' => __( 'List', 'ninja-forms-emailoctopus' ),
            'group' => 'primary',
            'width' => 'full',
            'options' => $this->get_lists(),
            'value' => ''
        );

        $this->_settings[ 'email_address' ] = array(
            'name' => 'email_address',
            'type' => 'textbox',
            'label' => __( 'Email Address', 'ninja-forms-emailoctopus' ),
            'group' => 'primary',
            'width' => 'full',
            'use_merge_tags' => true
        );

        $this->_settings[ 'first_name' ] = array(
            'name' => 'first_name',
            'type' => 'textbox',
            'label' => __( 'First Name', 'ninja-forms-emailoctopus' ),
            'group' => 'primary',
            'width' => 'full',
            'use_merge_tags' => true
        );

        $this->_settings[ 'last_name' ] = array(
            'name' => 'last_name',
            'type' => 'textbox',
            'label' => __( 'Last Name', 'ninja-forms-emailoctopus' ),
            'group' => 'primary',
            'width' => 'full',
            'use_merge_tags' => true
        );
    }

    private function get_lists()
    {
        if( ! isset( $this->api ) ) return array();
        $response = $this->api->request('GET', 'lists');
        $lists = array_map( array( $this, 'format_list_options' ), $response->details );
        array_unshift( $lists, array( 'value' => '', 'label' => '-' ) );
        return $lists;
    }

    private function format_list_options( $list )
    {
        return array(
            'value' => $list->id,
            'label' => $list->name
        );
    }
}
