<?php

if ( !defined( 'ABSPATH' ) )
    exit;

/**
 * Class NF_ZohoCRM_Admin_Settings
 */
final class NF_ZohoCRM_Admin_Settings {

    /**
     *
     * @var array Communication data for display on settings page
     */
    protected $comm_data;

    /**
     *
     * @var array Readable versions, typically with html markup, for display on the settings page
     */
    protected $readable_comm_data;

    public function __construct() {

        $this->comm_data = NF_ZohoCRM()->get_nfzohocrm_comm_data();

        $this->mark_up_request_array();

        $this->mark_up_response();
        
        $this->mark_up_errors();

        $this->mark_up_field_map_array();
        
        add_filter( 'ninja_forms_plugin_settings', array( $this, 'plugin_settings' ), 10, 1 );
        add_filter( 'ninja_forms_plugin_settings_groups', array( $this, 'plugin_settings_groups' ), 10, 1 );
    }

    public function plugin_settings( $settings ) {

        $settings_array = NF_ZohoCRM()->config( 'PluginSettings' );

        if(isset($this->comm_data[ 'zoho_comm_status' ])){
            $settings_array[ 'zoho_comm_status' ][ 'html' ] = $this->comm_data[ 'zoho_comm_status' ];
        }else{
        $settings_array[ 'zoho_comm_status' ][ 'html' ] = __('No Comm Status currently available', 'ninja-forms-zoho-crm');
        }


        $settings_array[ 'nfzohocrm_authtoken_connection_test_link' ][ 'html' ] = $this->authtoken_test_link();
        
        $settings_array[ 'errors' ][ 'html' ] =  $this->readable_comm_data[ 'errors' ] ;

        $settings_array[ 'request_array' ][ 'html' ] = $this->readable_comm_data[ 'request_array' ];

        $settings_array[ 'response' ][ 'html' ] = $this->readable_comm_data[ 'response' ];
        
        $settings_array[ 'field_map_array' ][ 'html' ] = $this->readable_comm_data[ 'field_map_array' ];

        $display_support = apply_filters('nfzohocrm_display_support', FALSE);

        if (FALSE == $display_support) {

            $support_mode_settings = array(
                'support_messages',
                'errors',
                'request_array',
                'response',
                'data_dump',
                'field_map_array',
            );

            foreach ( $support_mode_settings as $setting ) {

                unset( $settings_array[ $setting ] );
            }
        }

        $settings[ 'zohocrm' ] = $settings_array;

        return $settings;
    }

    public function plugin_settings_groups( $groups ) {

        $groups = array_merge( $groups, NF_ZohoCRM()->config( 'PluginSettingsGroups' ) );

        return $groups;
    }

    /**
     * Add html markup to request array for Settings page display
     */
    protected function mark_up_request_array() {

        $markup = __( 'No request information available', 'ninja-forms-zoho-crm' ); // default

        if ( isset( $this->comm_data[ 'request_array' ] ) && is_array( $this->comm_data[ 'request_array' ] ) ) {

            $markup = '<table>'; // re-initialize
            $markup .='<tr><th>Module</th><th>Zoho Field</th><th>Value</th></tr>';
            
            foreach ( $this->comm_data[ 'request_array' ] as $single_field_array ) {
                $markup .='<tr><td>'. $single_field_array[ 'module' ] . '</td><td>' . $single_field_array[ 'field_map' ] . '</td><td>' . $single_field_array[ 'form_field' ] . '</td></tr>';
            }
            $markup .='</table>';
        }

        $this->readable_comm_data[ 'request_array' ] = $markup;
    }

    /**
     * Build table for each module and response
     */
    protected function mark_up_response() {

        $markup = __( 'No response information available', 'ninja-forms-zoho-crm' ); // default

        if ( isset( $this->comm_data[ 'response' ] ) && is_array( $this->comm_data[ 'response' ] ) ) {

            $markup = '<table>'; // re-initialize

            foreach ( $this->comm_data[ 'response' ] as $module => $response ) {
                $markup .='<tr><td>' . $module . '</td><td> ' . serialize( $response ) . '</td></tr>';
            }
            $markup .= '</table>';
        }

        $this->readable_comm_data[ 'response' ] = $markup;
    }

    /**
     * Build mark up for errors
     */
    protected function mark_up_errors() {
        
        $markup = __( 'No errors currently available', 'ninja-forms-zoho-crm' ); // default

        if ( isset( $this->comm_data[ 'errors' ] ) && is_array( $this->comm_data[ 'errors' ] ) ) {

            $markup = serialize( $this->comm_data[ 'errors' ] );
        }

        $this->readable_comm_data[ 'errors' ] = $markup;
    }
    
    /**
     * Mark up the field map array
     */
    protected function mark_up_field_map_array(){
              
        $markup = __( 'No field map array currently available', 'ninja-forms-zoho-crm' ); // default

        if ( isset( $this->comm_data['field_map_array'] ) && is_array( $this->comm_data['field_map_array'] ) ) {


            $markup = '<table>'; // re-initialize
            $markup .='<tr><th>Form Field</th><th>Field Map</th><th>Custom Field</th></tr>';
            
            foreach ( $this->comm_data[ 'field_map_array' ] as $single_field_array ) {
                $markup .='<tr><td>'. $single_field_array[ 'form_field' ] . '</td><td>' . $single_field_array[ 'field_map' ] . '</td><td>' . $single_field_array[ 'custom_field' ] . '</td></tr>';
            }
            $markup .='</table>';
        }

        $this->readable_comm_data[ 'field_map_array' ] = $markup;  
        
    }

        /**
     * Returns the listener link to test the API
     */
    protected function authtoken_test_link(){
        
        $url = home_url().'/?nfzohocrm_instructions=test-connection';
        $link = '<a id="zoho-settings" href="'.$url.'">Click to test your Zoho connection</a>';

        return $link;
    }
}

// End Class NF_ZohoCRM_Admin_Settings
