<?php

add_action('init', 'nfzohocrm_listener');

/**
 * Listens for GET requests with specific commands
 * 
 * Calls specific functions based on the request made; uses 
 * a switch/case so that only vetted functions are called instead of allowing
 * for unvetted function calls
 */
function nfzohocrm_listener() {

    $listener_url = 'nfzohocrm_instructions';
    
    if (isset($_GET[$listener_url])) {

        $trigger = $_GET[$listener_url];
    } else {
        return;
    }

    switch ($trigger) {

        case 'test-connection':
            nfzohocrm_connection_test();
            break;

        default:
            break;
    }
}

function nfzohocrm_connection_test(){
        
    global $nfzohocrm_site_options;
        
        if(!isset($nfzohocrm_site_options['nfzohocrm_authtoken'])){
            
            NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'errors', __('Authtoken has not be set', 'ninja-forms-zoho-crm'));
            return;
        }else{
            
            $authtoken = $nfzohocrm_site_options['nfzohocrm_authtoken'];
        }

        $request_array = NF_ZohoCRM::config('ConnectionTester');

        NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'request_array', $request_array );

        $zohocomm = new ZohoCommObject( $authtoken );
        

        foreach ( $request_array as $field_iterator ) {

            $zohocomm->add_field_to_request( $field_iterator[ 'form_field' ], $field_iterator );
        }


        $zohocomm->process_form_request();

        $response = $zohocomm->get_processed_response();
        NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'response', $response );
        
        $comm_status = $zohocomm->get_status_update();
        NF_ZohoCRM()->modify_nfzohocrm_comm_data('zoho_comm_status',$comm_status);
                
        $errors = $zohocomm->get_error_array();
        NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'errors', $errors );
               
        NF_ZohoCRM()->update_nfzohocrm_comm_data();
        

    $redirect = admin_url().'admin.php?page=nf-settings#zoho-settings';

    wp_redirect($redirect);
    exit;
}