<?php

if ( !defined( 'ABSPATH' ) || !class_exists( 'NF_Abstracts_Action' ) )
    exit;

/**
 * Class NF_Action_ZohoCRMExample
 */
final class NF_ZohoCRM_Actions_AddToZohoCRM extends NF_Abstracts_Action {

    protected $_name = 'addtozohocrm'; // child CRM
    protected $_tags = array();
    protected $_timing = 'normal';
    protected $_priority = '10';

    /**
     * The field data from the form submission needed for building the field map array
     * @var array
     */
    protected $fields_to_extract;

    /**
     * The array of mapping data to be built into the request object
     * 
     * '    form_field'=>'form_field' , 
     *      'map_args' =>{
     *          'field_map'=>,
     *          'entry_type'=>,
     *          'custom_field_map'=>,
     *      }
     * @var array
     */
    protected $field_map_array;

    /**
     * The lookup array to convert readable field map to programmtic field map
     * @var array
     */
    protected $field_map_lookup;

    public function __construct() {
        parent::__construct();

        $this->_nicename = __( 'Add To Zoho CRM', 'ninja-forms' );

        $this->fields_to_extract = NF_ZohoCRM::config( 'FieldsToExtract' );
        $this->field_map_lookup = NF_ZohoCRM::config( 'FieldMapLookup' );

        // initialize the action settings
        add_action( 'admin_init', array( $this, 'init_settings' ) );

        // create the output template
        add_action( 'ninja_forms_builder_templates', array( $this, 'builder_templates' ) );
    }

    /*
     * PUBLIC FUNCTIONS
     * 
     */
    public function save( $action_settings ) {

        return $action_settings;
    }

    /**
     * Process the submitted form
     * @param array $action_settings
     * @param type $form_id
     * @param array $data
     */
    public function process( $action_settings, $form_id, $data ) {

        global $nfzohocrm_site_options;
        
        if(!isset($nfzohocrm_site_options['nfzohocrm_authtoken'])){
            
            NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'errors', __('Authtoken has not be set', 'ninja-forms-zoho-crm'));
            return;
        }else{
            
            $authtoken = $nfzohocrm_site_options['nfzohocrm_authtoken'];
        }
        
        // isolate the action_data for the submission
        $field_map_data = $action_settings[ 'zoho_field_map' ];

        $request_object = new ZohoRequestObject( $field_map_data );

        $request_array = $request_object->get_request_array();

        NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'field_map_array', $field_map_data );
        NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'request_array', $request_array );


        if ( class_exists( 'ZohoCommObjectPlus' ) ) {

            $zohocomm = new ZohoCommObjectPlus( $authtoken );
        } else {

            $zohocomm = new ZohoCommObject( $authtoken );
        }

        foreach ( $request_array as $field_iterator ) {

            $zohocomm->add_field_to_request( $field_iterator[ 'form_field' ], $field_iterator );
        }


        $zohocomm->process_form_request();

        $response = $zohocomm->get_processed_response();
        NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'response', $response );
        
        $comm_status = $zohocomm->get_status_update();
        NF_ZohoCRM()->modify_nfzohocrm_comm_data('zoho_comm_status',$comm_status);
                
        $errors = $zohocomm->get_error_array();
        NF_ZohoCRM()->modify_nfzohocrm_comm_data( 'errors', $errors );
       

        
        NF_ZohoCRM()->update_nfzohocrm_comm_data();
        
        /**
         * Array of data for each newly created module
         * 
         * Includes Message, Id, Created Time, Created By
         */
        $new_record_ids = $zohocomm->get_new_record_id_array();
        
        /*
         * Make the new IDs available for other uses
         */
        do_action('nfzohocrm_process_new_record_ids', $new_record_ids);
        
        return $data;
    }

    public function builder_templates() {
        NF_ZohoCRM::template( 'custom-field-map-row.html' );
    }

    public function init_settings() {

        // bring in configured settings
        $settings = NF_ZohoCRM::config( 'ActionFieldMapSettings' );
        $this->_settings = array_merge( $this->_settings, $settings );

        // set dropdown for fields from config file
        $zoho_fields = NF_ZohoCRM::config( 'FieldMapLookup' );

        $this->_settings[ 'zoho_field_map' ][ 'columns' ][ 'field_map' ][ 'options' ] = $this->build_field_map_dropdown( $zoho_fields );
    }

    /*
     * PROTECTED METHODS
     */
    /**
     * Build the array of each field to be sent
     * 
     * @param type $field_map_array
     * @return array
     */
    protected function build_field_map_dropdown( $field_map_array ) {

        $dropdown_array = array();

        foreach ( $field_map_array as $key => $label_map_array ) {

            $dropdown_array[] = array(
                'label' => $label_map_array[ 'label' ],
                'value' => $key,
            );
        }

        return $dropdown_array;
    }

}
