<?php if ( ! defined( 'ABSPATH' ) ) exit;

return apply_filters( 'nf_slack_action_slack_settings', array(

    /*
    |--------------------------------------------------------------------------
    | Botname
    |--------------------------------------------------------------------------
    */

    'botname' => array(
        'name' => 'botname',
        'type' => 'textbox',
        'label' => __( 'Botname', 'ninja-forms-slack' ),
        'group' => 'advanced',
        'width' => 'one-half',
        'value' => apply_filters( 'ninja-forms-botname' , __( 'Ninja Forms', 'ninja-forms' ) ) ,
        'help'  => __( 'This is the name that will appear in your slack channel.', 'ninja-forms-slack' ),
        'use_merge_tags' => TRUE,
    ),
    
    /*
    |--------------------------------------------------------------------------
    | Message
    |--------------------------------------------------------------------------
    */

    'message' => array(
        'name' => 'message',
        'type' => 'textarea',
        'label' => __( 'Message', 'ninja-forms-slack' ),
        'group' => 'primary',
        'width' => 'full',
        'use_merge_tags' => TRUE,
    ),

    /*
    |--------------------------------------------------------------------------
    | Slack URL
    |--------------------------------------------------------------------------
    */

    'slack_url' => array(
        'name' => 'slack_url',
        'type' => 'textbox',
        'label' => __( 'Slack URL', 'ninja-forms-slack' ),
        'group' => 'primary',
        'width' => 'full',
        'help'  => __( "Go To https://'your-team-name'.slack.com/services/new/incoming-webhook to get this URL.", 'ninja-forms-slack'  )

    ),

    /*
    |--------------------------------------------------------------------------
    | Image Icon
    |--------------------------------------------------------------------------
    */

    'image_icon' => array(
        'name'  => 'image_icon',
        'type'  => 'textbox',
        'label' => __( 'Slack Emoji', 'ninja-forms-slack' ),
        'group' => 'advanced',
        'width' => 'one-half',
        'help'  => __( "Insert one of slack's emoji codes for example :simple_smile:",
                        'ninja-forms-slack'),
        'value' => ':page_facing_up:'
    ),

));
