<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_Action' )) exit;

/**
 * Class NF_Action_Slack
 */
final class NF_Slack_Actions_Slack extends NF_Abstracts_Action
{
    /**
     * @var string
     */
    protected $_name  = 'slack';

    /**
     * @var array
     */
    protected $_tags = array();

    /**
     * @var string
     */
    protected $_timing = 'normal';

    /**
     * @var int
     */
    protected $_priority = '10';

    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
    
        $this->_nicename = __( 'Slack', 'ninja-forms-slack' );
        $settings = NF_Slack::config( 'ActionSlackSettings' );
        $this->_settings = array_merge( $this->_settings, $settings );
    }

    /*
    * PUBLIC METHODS
    */

    public function save( $action_settings )
    {
    
    }

    public function process( $action_settings, $form_id, $data )
    {
        $payload = array(
            'text' => strip_tags(preg_replace('/(<\/[^>]+?>)(<[^>\/][^>]*?>)/', PHP_EOL,  $action_settings[ 'message' ] ) ),
            'username' => strip_tags( $action_settings[ 'botname' ] ),
            'icon_emoji' => strip_tags( $action_settings[ 'image_icon' ] ),
        );

        // Send it away!
        $output  = 'payload=' . json_encode( $payload );
        $response = wp_remote_post( $action_settings[ 'slack_url' ], array(
            'body' => $output,
            )
        );
        
        if ( is_wp_error( $response ) ) {
            $error_message = $response->get_error_message();
            $data[ 'actions' ][ 'slack' ][ 'error' ] = __( "Slack Notifications not sent, Something went wrong: $error_message", 'ninja-forms-slack');
        }

        $data[ 'actions' ][ 'slack' ][ 'response' ] = $response;

        return $data;
    }
}
