<?php if ( ! defined( 'ABSPATH' ) ) exit;

/*
 * Plugin Name: Ninja Forms - Twilio SMS
 * Plugin URI: http://ninjaforms.com/downloads/twilio
 * Description: Integrates Ninja Forms with Twilio to send SMS messages.
 * Version: 3.0.1
 * Author: fatcatapps
 * Author URI: fatcatapps.com
 * Text Domain: ninja-forms-twilio
 *
 * Copyright 2016 fatcatapps.
 */

if( version_compare( get_option( 'ninja_forms_version', '0.0.0' ), '3.0', '<' ) || get_option( 'ninja_forms_load_deprecated', FALSE ) ) {

    // NO DEPRECATED VERSION, NATIVE 3.0 ONLY
	//include 'deprecated/ninja-forms-twilio.php';

} else {

    /**
     * Class NF_Twilio
     */
    final class NF_Twilio
    {
        const VERSION = '3.0.1';
        const SLUG    = 'twilio-sms';
        const NAME    = 'Twilio SMS';
        const AUTHOR  = 'fatcatapps';
        const PREFIX  = 'NF_Twilio';

        /**
         * @var NF_Twilio
         * @since 3.0
         */
        private static $instance;

        /**
         * Plugin Directory
         *
         * @since 3.0
         * @var string $dir
         */
        public static $dir = '';

        /**
         * Plugin URL
         *
         * @since 3.0
         * @var string $url
         */
        public static $url = '';

        /**
         * Main Plugin Instance
         *
         * Insures that only one instance of a plugin class exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since 3.0
         * @static
         * @static var array $instance
         * @return NF_Twilio Highlander Instance
         */
        public static function instance()
        {
            if (!isset(self::$instance) && !(self::$instance instanceof NF_Twilio)) {
                self::$instance = new NF_Twilio();

                self::$dir = plugin_dir_path(__FILE__);

                self::$url = plugin_dir_url(__FILE__);

                /*
                 * Register our autoloader
                 */
                spl_autoload_register(array(self::$instance, 'autoloader'));
            }
        }

        public function __construct()
        {

            add_action( 'admin_init', array( $this, 'setup_license') );
            add_filter( 'ninja_forms_register_actions', array($this, 'register_actions'));

        }

        /**
         * Optional. If your extension processes or alters form submission data on a per form basis...
         */
        public function register_actions($actions)
        {
            $actions[ 'twilio-sms' ] = new NF_Twilio_Actions_TwilioSMS(); // includes/Actions/TwilioSMS.php

            return $actions;
        }

        /*
         * Optional methods for convenience.
         */

		public function autoloader($class_name)
        {
            if (class_exists($class_name)) return;

            if ( false === strpos( $class_name, self::PREFIX ) ) return;

            $class_name = str_replace( self::PREFIX, '', $class_name );
            $classes_dir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR;
            $class_file = str_replace('_', DIRECTORY_SEPARATOR, $class_name) . '.php';

            if (file_exists($classes_dir . $class_file)) {
                require_once $classes_dir . $class_file;
            }
        }
        
        /**
         * Template
         *
         * @param string $file_name
         * @param array $data
         */
        public static function template( $file_name = '', array $data = array() )
        {
            if( ! $file_name ) return;

            extract( $data );

            include self::$dir . 'includes/Templates/' . $file_name;
        }
        
        /**
         * Config
         *
         * @param $file_name
         * @return mixed
         */
        public static function config( $file_name )
        {
            return include self::$dir . 'includes/Config/' . $file_name . '.php';
        }

        /*
         * Required methods for all extension.
         */

        public function setup_license()
        {
            if ( ! class_exists( 'NF_Extension_Updater' ) ) return;

            new NF_Extension_Updater( self::NAME, self::VERSION, self::AUTHOR, __FILE__, self::SLUG );
        }
    }
	
	//FUNCTIONS
	
	function nf_twilio_plugin_settings( $settings ) {
		
		$settings[ 'twilio' ] = array(
			'twilio-sid' => array(
				'id'    => 'twilio-sid',
				'type'  => 'textbox',
				'label'  => __( 'Twilio Account SID', 'ninja-forms-twilio' ),
				'desc' => __( 'Enter your Account SID from the <a target="_blank" href="http://twilio.com/console">Console Dashboard</a>', 'ninja-forms-twilio' ),
			),
			'twilio-auth' => array(
				'id'    => 'twilio-auth',
				'type'  => 'textbox',
				'label' => __( 'Twilio Auth Token', 'ninja-forms-twilio' ),
				'desc' => __( 'Enter your Account Auth Token from the <a target="_blank" href="http://twilio.com/console">Console Dashboard</a>', 'ninja-forms-twilio' ),
			),			
		);

		return $settings;
	}
	add_filter( 'ninja_forms_plugin_settings', 'nf_twilio_plugin_settings' );
	
	function nf_twilio_plugin_settings_groups ( $groups ) {
		$groups[ 'twilio' ] = array(
			'id' => 'twilio',
			'label' => __( 'Twilio', 'ninja-forms-twilio' ),
		);
		
		return $groups;
	}
	
	add_filter( 'ninja_forms_plugin_settings_groups', 'nf_twilio_plugin_settings_groups', 10, 1 );

	function nf_twilio_get_phone_numbers( $sid = '', $auth = '' ) {
		//GET ACTIVE NUMBERS FROM TWILIO
		$phones_formatted = array (
			array ( 
				'label' => 'Not Set',
				'value' => 'not-set',
			)
		);
		
		if ( !empty ( $sid ) && ( !empty ( $auth ) ) ) {

			$url = 'https://api.twilio.com/2010-04-01/Accounts/' . $sid . '/IncomingPhoneNumbers.json';
			$headers = array( 
				"Authorization" => "Basic " . base64_encode( "$sid:$auth" )
			);
			
			$response = wp_remote_get( $url, array(	'headers' => $headers ) );
			
			if ( !is_wp_error ( $response ) ) {
				$body = json_decode( $response['body'] );
				if ( isSet ($body->incoming_phone_numbers) ) {
					forEach ( $body->incoming_phone_numbers as $phone ) {
						$phones_formatted[] = array ( 
							'label' => $phone->phone_number,
							'value' => $phone->phone_number
						);
					}
				}
			}
		}
		
		return $phones_formatted;
	}
	
	function validate_ninja_forms_twilio_sid ( $setting ) {
		
        $sid = trim( $setting[ 'value' ] );
		$auth =  Ninja_Forms()->get_setting( 'twilio-auth' );
		
		if ( empty ($sid) ) {
			$setting[ 'errors' ][] = __( 'Please enter a Twilio Account SID.', 'ninja-forms-twilio');
		}
		
        return $setting;
	}
	
	add_filter( 'ninja_forms_check_setting_twilio-sid', 'validate_ninja_forms_twilio_sid', 10, 1 );
	
	function validate_ninja_forms_twilio_auth ( $setting ) {
		
        $auth = trim( $setting[ 'value' ] );
		$sid =  Ninja_Forms()->get_setting( 'twilio-sid' );
		
		if ( empty ($auth) ) {
			$setting[ 'errors' ][] = __( 'Please enter a Twilio Auth Token.', 'ninja-forms-twilio');
		} else if ( !empty( $sid ) ) {
			if ( !nf_twilio_validate_account( $sid, $auth ) ) {
				$setting[ 'errors' ][] = __( 'The Twilio credentials you have entered appear to be invalid.', 'ninja-forms-twilio');
			}
		}
		
        return $setting;
	}
	
	add_filter( 'ninja_forms_check_setting_twilio-auth', 'validate_ninja_forms_twilio_auth', 10, 1 );
	
	function nf_twilio_validate_account( $sid, $auth ) {
		$url = 'https://api.twilio.com/2010-04-01/Accounts/' . $sid;
		$headers = array( 
			"Authorization" => "Basic " . base64_encode( "$sid:$auth" )
		);
		try {
			$response = wp_remote_get( $url, array(	'headers' => $headers ) );
			if ( is_wp_error ( $response ) OR $response['response']['code'] != 200 ) {
				return false;
			} else {
				return true;
			}
		} catch (Exception $e) {
			return false;
		}
	}
	
    /**
     * The main function responsible for returning The Highlander Plugin
     * Instance to functions everywhere.
     *
     * Use this function like you would a global variable, except without needing
     * to declare the global.
     *
     * @since 3.0
     * @return {class} Highlander Instance
     */
    function NF_Twilio()
    {
        return NF_Twilio::instance();
    }

    NF_Twilio();
}


