<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_Action' )) exit;

/**
 * Class NF_Twilio_Actions_TwilioSMS
 */
final class NF_Twilio_Actions_TwilioSMS extends NF_Abstracts_Action
{
    /**
     * @var string
     */
    protected $_name  = 'twilio-sms';

    /**
     * @var array
     */
    protected $_tags = array('Twilio', 'SMS');

    /**
     * @var string
     */
    protected $_timing = 'normal';

    /**
     * @var int
     */
    protected $_priority = '10';

    /**
     * Constructor
     */
    public function __construct() {
		parent::__construct();

		$this->_nicename = __( 'Twilio SMS', 'ninja-forms-twilio' );
		
		$last_from_number = get_option( 'nf-twillio-last-from' );
		$last_to_number = get_option( 'nf-twillio-last-to' );
		$last_to_number = empty ( $last_to_number ) ? '' : $last_to_number;
		
		$sid = Ninja_Forms()->get_setting( 'twilio-sid' );
		$auth =  Ninja_Forms()->get_setting( 'twilio-auth' );
		
		if ( nf_twilio_validate_account( $sid, $auth ) ) {
			
			$phones_formatted = nf_twilio_get_phone_numbers( $sid, $auth );

			$settings = array (	
				'twilio-phone-from' => array(
					'name' => 'twilio-phone-from',
					'type' => 'select',
					'options' => $phones_formatted,
					'label' => __( 'Twilio Phone Number', 'ninja-forms-twilio' ),
					'width' => 'full',
					'group' => 'primary',
					'value' => $last_from_number,
					'use_merge_tags' => FALSE,
					'help' => sprintf ( __( "Select which Twilio Phone you want to send the SMS. If you don't see your number, check the %s Twilio Phone Numbers Dashboard%s and refresh.", 'ninja-forms-twilio' ), '<a target="_blank" href="http://twilio.com/console/phone-numbers/">', '</a>', '<a target="_blank" href="http://twilio.com/console/phone-numbers/">', '</a>'),
				),
				'twilio-phone-to' => array(
					'name' => 'twilio-phone-to',
					'value' => $last_to_number,
					'type' => 'textbox',
					'label' => __( 'To', 'ninja-forms-twilio' ),
					'placeholder' => __( '1-555-867-5309', 'ninja-forms-twilio' ),
					'width' => 'full',
					'group' => 'primary',
					'use_merge_tags' => TRUE,
					'help' =>  __( 'Enter the phone number you wish to receive the SMS.  Include the country code (e.g. 1 for US: 1-555-555-1234)', 'ninja-forms-twilio' ),
				),
				'twilio-message' => array(
					'name' => 'twilio-message',
					'type' => 'textarea',
					'label' => __( 'SMS Message', 'ninja-forms-twilio' ),
					'width' => 'full',
					'group' => 'primary',
					'use_merge_tags' => TRUE,
					'help' => __( 'Enter the message you want to send. You can add merge tags to customize the message. Messages longer than 160 characters will be broken up into multiple messages.', 'ninja-forms-twilio' ),
				)
			);
			
		} else {
			//SHOW INVALID AUTH ERROR
			$setting_url = get_admin_url( get_current_blog_id(), 'admin.php?page=nf-settings#row_ninja_forms[twilio-sid]' );
			$settings = array (	
				'twilio-error' => array(
					'name' => 'twilio-error',
					'type' => 'textarea',
					'label' => "<a target='_blank' href='$setting_url'>" . __( "Click Here to Update Your Twilio Settings", 'ninja-forms-twilio' ) . "</a>",
					'value' => __ ( 'Make sure the Twilio Account SID and Auth Token are correctly set on the Ninja Forms setting page', 'ninja-forms-twilio' ),
					'width' => 'full',
					'group' => 'primary',
					'use_merge_tags' => FALSE,
				)
			);
		
		}
		$this->_settings = array_merge ( $this->_settings, $settings );
		
	}

    /*
    * PUBLIC METHODS
    */

    public function save( $action_settings ) {
		
		//SAVE THE LAST SETTINGS TO AUTO-LOAD
		$last_from_number = empty ( $action_settings['twilio-phone-from'] ) ? '' : trim ( $action_settings['twilio-phone-from'] );
		$last_to_number = empty ( $action_settings['twilio-phone-to'] ) ? '' : trim ( $action_settings['twilio-phone-to'] );

		update_option( 'nf-twillio-last-from', $last_from_number );
		update_option( 'nf-twillio-last-to', $last_to_number );
    }

    public function process( $action_settings, $form_id, $data ) {

		$sid = Ninja_Forms()->get_setting( 'twilio-sid' );
		$auth =  Ninja_Forms()->get_setting( 'twilio-auth' );
		
		$phone_to =  empty ( $action_settings['twilio-phone-to'] ) ? '' : '+' . preg_replace( "/[^0-9]/", "", $action_settings['twilio-phone-to'] );
		$phone_from = $action_settings['twilio-phone-from'];
		
		$msg = $action_settings['twilio-message'];
		
		if ( !empty ( $sid ) && !empty ( $auth ) && !empty ( $phone_to ) && !empty ( $phone_from ) && !empty ( $msg ) ) {
			//strip tags if it's a ninja forms generated table
			if ( strpos ( $msg, '<table>' ) !== FALSE ) {
				$msg = rtrim ( strip_tags ( str_replace ("</tr>", "\n",  ( str_replace ( "</td>", " ", $msg ) ) ) ) );
			}
			
			$url = 'https://api.twilio.com/2010-04-01/Accounts/' . $sid . '/Messages.json';
			
			$body = array(
				'Body'	=> $msg,
				'From' => $phone_from,
				'To'	=> $phone_to,
			);
			
			$headers = array( 
				"Authorization" => "Basic " . base64_encode( "$sid:$auth" )
			);
			
			try {
				$response = wp_remote_post( $url, array(
					'headers' => $headers,
					'body' => $body,
					)
				);
			} catch (Exception $e) {
				//an error occured
			}
		}
		
		return $data;
    }
}
