<?php

if (!defined('ABSPATH'))
    exit;

/*
 * Plugin Name: Ninja Forms - Insightly CRM
 * Plugin URI: http://lb3computingsolutions.com
 * Description: Use the power of Ninja Forms to add entries to your Insightly CRM
 * Version: 3.2.0
 * Author: Stuart Sequeira
 * Author URI: http://lb3computingsolutions.com/about
 * Text Domain: ninja-forms-insightly-crm
 *
 * Copyright 2016 Stuart Sequeira.
 */

if (version_compare(get_option('ninja_forms_version', '0.0.0'), '3.0.0', '<') || get_option('ninja_forms_load_deprecated', FALSE)) {


    // deprecated version number
    if (!defined('NF2INSIGHTLYCRM_VERSION')) {
        define('NF2INSIGHTLYCRM_VERSION', '1.10.0');
    }

    // deprecated folder url
    if (!defined('NF2INSIGHTLYCRM_PLUGIN_URL')) {
        define('NF2INSIGHTLYCRM_PLUGIN_URL', plugin_dir_url(__FILE__));
    }

    // deprecated folder path
    if (!defined('NF2INSIGHTLYCRM_PLUGIN_DIR')) {
        define('NF2INSIGHTLYCRM_PLUGIN_DIR', plugin_dir_path(__FILE__));
    }

    // deprecated root file
    if (!defined('NF2INSIGHTLYCRM_PLUGIN_FILE')) {
        define('NF2INSIGHTLYCRM_PLUGIN_FILE', __FILE__);
    }

    include 'deprecated/nf-insightly-crm-deprecated.php';
} else {

    // define Insightly mode as POST3
    if (!defined('NFINSIGHTLYCRM_MODE')) {
        define('NFINSIGHTLYCRM_MODE', 'POST3');
    }

    /*
     * Include shared functions
     */
    include 'includes/Admin/Functions.php';
    /*
     * Constants used throughout
     */
    include 'includes/Admin/Constants.php';
    
    /*
     * Listener class - listens and swichboards instructions
     */
    include 'includes/Admin/Listener.php';
    
    /*
     * Markup class - given data returns html markup
     */
    include 'includes/Admin/Markup.php';
    
    /*
     * Functionality for Advanced Commands in Settings section
     */
    include 'includes/Admin/AdvancedCommands.php';
    
    /**
     * Class NF_InsightlyCRM
     */
    final class NF_InsightlyCRM {

        const VERSION = '3.2.0';
        const SLUG = 'insightly-crm';
        const NAME = 'Insightly CRM';
        const AUTHOR = 'Stuart Sequeira';
        const PREFIX = 'NF_InsightlyCRM';

        /**
         * @var NF_InsightlyCRM
         * @since 3.0
         */
        private static $instance;

        /**
         * Plugin Directory
         *
         * @since 3.0
         * @var string $dir
         */
        public static $dir = '';

        /**
         * Plugin URL
         *
         * @since 3.0
         * @var string $url
         */
        public static $url = '';

        /**
         * Associative array of CRM account data
         * @var array
         */
        protected $account_data;
        
        /**
         * Main Plugin Instance
         *
         * Insures that only one instance of a plugin class exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since 3.0
         * @static
         * @static var array $instance
         * @return NF_InsightlyCRM Highlander Instance
         */
        public static function instance() {

            if (!isset(self::$instance) && !(self::$instance instanceof NF_InsightlyCRM)) {
                self::$instance = new NF_InsightlyCRM();

                self::$dir = plugin_dir_path(__FILE__);

                self::$url = plugin_dir_url(__FILE__);

                /*
                 * Register our autoloader
                 */
                spl_autoload_register(array(self::$instance, 'autoloader'));
            }

            return self::$instance;
        }

        public function __construct() {
            /*
             * load the global variables
             */
            nfinsightly_load_globals();

            $this->load_classes();
            
            $this->retrieve_account_data();
            
            /*
             * Set up Licensing
             */
            add_action('admin_init', array($this, 'setup_license'));

            /*
             * Create Admin settings
             */
            add_action('ninja_forms_loaded', array($this, 'setup_admin'));


            /*
             * Load Templates
             */
            add_action('ninja_forms_builder_templates', array($this, 'builder_templates'));

            /*
             * Register Actions
             */
            add_filter('ninja_forms_register_actions', array($this, 'register_actions'));
        }

        public function register_actions($actions) {

            $actions['addtoinsightly'] = new NF_InsightlyCRM_Actions_AddToInsightly();

            return $actions;
        }

        /*
         * Set up the licensing
         */

        public function setup_license() {

            if (!class_exists('NF_Extension_Updater'))
                return;

            new NF_Extension_Updater(self::NAME, self::VERSION, self::AUTHOR, __FILE__, self::SLUG);
        }

        /**
         * Create the settings page
         */
        public function setup_admin() {

            if (!is_admin())
                return;

            new NF_InsightlyCRM_Admin_Settings();
        }

        public function load_classes() {

            NF_InsightlyCRM::file_include('Comm', 'InsightlyRawRequest');
            NF_InsightlyCRM::file_include('Comm', 'InsightlyCommunication');
        }

        /**
         * Retrieves the stored wp_option; initializes missing values
         */
        protected function retrieve_account_data(){
            
            $temp_account_data = get_option(NF_InsightlyCRM_Constants::ACCOUNT_DATA);
            
            if(isset($temp_account_data['user_array'])){
                
                $this->account_data['user_array']= $temp_account_data['user_array'];
            }else{
                
                $this->account_data['user_array']=array();
            }
               
            if(isset($temp_account_data['nfinsightlycrm_custom_field_list'])){
                
                $this->account_data['custom_field_list']= $temp_account_data['nfinsightlycrm_custom_field_list'];
            }else{
                
                $this->account_data['custom_field_list']='';
            }         
        }
        
        
        /**
         * Returns a configuration specified in a given Config file
         * @param string $file_name
         * @return mixed
         */
        public static function config($file_name) {

            return include self::$dir . 'includes/Config/' . $file_name . '.php';
        }

        /**
         * Includes a specific file in an Includes directory
         * 
         * @param string $sub_dir
         * @param string $file_name
         */
        public static function file_include($sub_dir, $file_name) {

            include self::$dir . 'includes/' . $sub_dir . '/' . $file_name . '.php';
        }

        /**
         * Creates a template for display
         * 
         * @param string $file_name
         * @param array $data
         * @return mixed
         */
        public static function template($file_name = '', array $data = array()) {

            if (!$file_name) {
                return;
            }
            extract($data);

            include self::$dir . 'includes/Templates/' . $file_name;
        }

        /*
         * Optional methods for convenience.
         */

        public function autoloader($class_name) {

            if (class_exists($class_name))
                return;

            if (false === strpos($class_name, self::PREFIX))
                return;

            $class_name = str_replace(self::PREFIX, '', $class_name);
            $classes_dir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR;
            $class_file = str_replace('_', DIRECTORY_SEPARATOR, $class_name) . '.php';

            if (file_exists($classes_dir . $class_file)) {
                require_once $classes_dir . $class_file;
            }
        }

        /**
         * Returns the stored user array from the account data wp_option
         * @return array
         */
        public function get_user_array(){
            
                return $this->account_data['user_array'];
        }
    }

    /**
     * The main function responsible for returning The Highlander Plugin
     * Instance to functions everywhere.
     *
     * Use this function like you would a global variable, except without needing
     * to declare the global.
     *
     * @since 3.0
     * @return {class} Highlander Instance
     */
    function NF_InsightlyCRM() {
        return NF_InsightlyCRM::instance();
    }

    NF_InsightlyCRM();
}

add_filter('ninja_forms_upgrade_settings', 'NF_InsightlyCRM_Upgrade');

function NF_InsightlyCRM_Upgrade($data) {
    
    /*
     * Sitewide settings
     */
    $plugin_settings = get_option('nfinsightlycrm_settings', array(
        'nfinsightlycrm_apikey' => '',
            )
    );

    Ninja_Forms()->update_settings(array(
        'nfinsightlycrm_apikey' => $plugin_settings['nfinsightlycrm_apikey'],
            )
    );

    /*
     * Form settings
     */

    // Convert form settings to action.
    if (isset($data['settings']['nfinsightlycrm_create_new_contact']) && 1 == $data['settings']['nfinsightlycrm_create_new_contact']) {

        $new_action = array(
            'type' => 'addtoinsightly',
            'label' => __('Add to Insightly', 'ninja-forms-insightly-crm'),
        );

        $fieldmap_lookup = nfinsightlycrm_upgrade_fieldmap_lookup();

//        update_option('data_fields', $data['fields']);  // debug only
        foreach ($data['fields'] as $key => $field) {
            
            if(!isset($field['data']['nfinsightlycrm_field_map']) || 'none'==$field['data']['nfinsightlycrm_field_map']){
                // this field does not have an insightly field map
                continue;
            }else{
                
                /*
                 * Check if value is in lookup array, if not, transfer existing value
                 * If not in lookup, it is a custom field
                 */
                if(isset($fieldmap_lookup[$field['data']['nfinsightlycrm_field_map']])){
                    
                    $fieldmap_key = $fieldmap_lookup[$field['data']['nfinsightlycrm_field_map']];
                }else{
                    
                    $fieldmap_key = $field['data']['nfinsightlycrm_field_map'];
                }
                
                
            }
            
            $new_action['insightly_field_map'][]=array(
                'form_field'=>'{field:' .$field['id'] . '}',
                'field_map'=>$fieldmap_key,
                'entry_type'=>$field['data']['nfinsightlycrm_entry_type'],
                
            );
        }
        
        $data[ 'actions' ][] = $new_action;

    }
// update_option('returned_data',$data);   
    return $data;
}

/**
 * Converts the 2.9 map instructions into the 3.0 key
 * @return array Lookup array of map_instructions with $key
 */
function nfinsightlycrm_upgrade_fieldmap_lookup(){
    
     $standard_fields_lookup = include plugin_dir_path(__FILE__).'includes/Config/InsightlyFields.php' ;
     
     $lookup_array = array(); // initialize
     
     foreach($standard_fields_lookup as $key=>$array){
         
         $lookup_array[$array['map_instructions']]=$key;
         
     }
     
     return $lookup_array;
}
