<?php

if ( !defined( 'ABSPATH' ) )
    exit;

/**
 * Configures the plugin settings and formats support data
 * 
 * Uses shared functions from Functions.php
 */
final class NF_InsightlyCRM_Admin_Settings {

    /**
     * Reader friendly string of custom fields
     * 
     * @var string
     */
    protected $custom_field_list;

    /** Associative array of the account users
     *
     * @var array
     */
    protected $user_list;
    
    /**
     *
     * @var array Communication Data array for support 
     */
    protected $comm_data;

    /**
     *
     * @var array Marked up html for readable disply in settings
     */
    protected $readable_comm_data;

    public function __construct() {

        $this->comm_data = nfinsightlycrm_extract_comm_data();

        $this->user_list = NF_InsightlyCRM()->get_user_array();
        
        $this->mark_up_raw_request();

        $this->custom_field_list = nfinsightlycrm_userfriendly_custom_field_list();

        
        add_filter( 'ninja_forms_plugin_settings', array( $this, 'plugin_settings' ), 10, 1 );
        add_filter( 'ninja_forms_plugin_settings_groups', array( $this, 'plugin_settings_groups' ), 10, 1 );
    }

    public function plugin_settings( $settings ) {

        $insightly_settings = NF_InsightlyCRM()->config( 'PluginSettings' );

        $insightly_settings[ 'nfinsightlycrm_api_connection_test_link' ][ 'html' ] = $this->api_test_link();
        
        $insightly_settings[ 'nfinsightlycrm_comm_status' ][ 'html' ] = $this->comm_data[ 'nfinsightlycrm_comm_status' ];

        $insightly_settings[ 'nfinsightlycrm_custom_field_list' ][ 'html' ] = $this->custom_field_list;

        $insightly_settings[ 'nfinsightlycrm_most_recent_raw_request' ][ 'html' ] = $this->readable_comm_data[ 'nfinsightlycrm_most_recent_raw_request' ];

        $insightly_settings[ 'nfinsightlycrm_most_recent_raw_response' ][ 'html' ] = $this->comm_data[ 'nfinsightlycrm_most_recent_raw_response' ];

        $insightly_settings[NF_InsightlyCRM_Constants::REFRESH_ACCOUNT]['html']=$this->refresh_user_link();
        
        $insightly_settings[NF_InsightlyCRM_Constants::USER_LIST]['html']= NF_InsightlyCRM_Markup::markup(NF_InsightlyCRM_Constants::USER_LIST, $this->user_list);

        $display_support = apply_filters('nfinsightlycrm_display_support', FALSE);

        if (FALSE == $display_support) {
            $support_mode_settings = array(
                'nfinsightlycrm_most_recent_raw_request',
                'nfinsightlycrm_most_recent_raw_response',
            );

            foreach ( $support_mode_settings as $setting ) {

                unset( $insightly_settings[ $setting ] );
            }
        }

        $display_account_data = apply_filters('nfinsightlycrm_display_account_data', FALSE);
        
           if (FALSE == $display_account_data) {
            $support_mode_settings = array(
                'nfinsightlycrm_custom_field_list',
                NF_InsightlyCRM_Constants::USER_LIST,
            );

            foreach ( $support_mode_settings as $setting ) {

                unset( $insightly_settings[ $setting ] );
            }
        }     
        
        $settings[ 'insightlycrm' ] = $insightly_settings;

        return $settings;
    }

    public function plugin_settings_groups( $groups ) {
        $groups = array_merge( $groups, NF_InsightlyCRM()->config( 'PluginSettingsGroups' ) );
        return $groups;
    }
  
    /**
     * Add html table for better reading and display on Settings page
     */
    protected function mark_up_raw_request() {

        $markup = $this->comm_data[ 'nfinsightlycrm_most_recent_raw_request' ]; // set default

        $array =  maybe_unserialize($this->comm_data[ 'nfinsightlycrm_most_recent_raw_request' ] );

        // not sure why double unserialize is necessary(?)
        $array2=  maybe_unserialize($array);
        
        if ( is_array( $array2 ) ) {

            $markup = ''; // initialize
           foreach ( $array2 as $key => $value ) {
               $markup.= '<strong>' . $key . '</strong><br />';
               if(is_array($value)){
                   foreach($value as $module=>$request){
                       
                       $markup .= '&nbsp;&nbsp;<strong>'.$module.'</strong><br />';
                       $markup .= '&nbsp;&nbsp;'.serialize($request).'<br />';
                   }
               }else{
                   
                 $markup.= $value . '<br /><br />';
               }
            }
        }else{
            $markup = 'not array';
        }
        
        $this->readable_comm_data[ 'nfinsightlycrm_most_recent_raw_request' ] = $markup;
    }
    
    /**
     * Returns the listener link to test the API
     */
    protected function api_test_link(){
        
        $url = home_url().'/?nfinsightlycrm_instructions=test-connection';
        $link = '<a id="insightly-settings" href="'.$url.'">Click to test your API connection</a>';

        return $link;
    }
    
    /** Returns link to refresh the users list */
    protected function refresh_user_link(){
        
          $url = home_url().'/?'.NF_InsightlyCRM_Constants::LISTENER_URL.'='.NF_InsightlyCRM_Constants::ACCOUNT_DATA_REFRESH;
          $text = __('Click to retrieve your Insightly Users List','ninja-forms-insightly-crm');
        $link = '<a id="insightly-settings" href="'.$url.'">'.$text.'</a>';

        return $link;      
    }
}
// End Class NF_InsightlyCRM_Admin_Settings

    