<?php

/**
 * Listener class
 * 
 * Does not call any class methods outside of its own plugin
 * Checks for Ninja_Forms class because point is moot otherwise
 */
class NF_InsightlyCRM_Listener {

    /**
     * Listens for GET requests with specific commands
     * 
     * Calls specific functions based on the request made; uses 
     * a switch/case so that only vetted functions are called
     */
    public static function listener() {

        /*
         * Check that Ninja_Forms is loaded, otherwise stop listening
         */
        if (!class_exists('Ninja_Forms') || !class_exists('NF_InsightlyCRM')) {

            return;
        }

        $trigger = filter_input(INPUT_GET, NF_InsightlyCRM_Constants::LISTENER_URL);

        switch ($trigger) {

            case NF_InsightlyCRM_Constants::CONNECTION_TEST:

                self::test_connection();
                break;

            case NF_InsightlyCRM_Constants::ACCOUNT_DATA_REFRESH:
                self::refresh_account_data();
                break;

            default:
                break;
        }
    }

    /**
     * Test the connection with a standard request
     */
    public static function test_connection() {

        nfinsightlycrm_connection_test();
    }

    /**
     * Requests the Users associated with the CRM account
     */
    public static function refresh_account_data() {

        global $nfinsightlycrm_crm_account_data;
        global $nfinsightlycrm_comm_data;

        $apikey = Ninja_Forms()->get_setting('nfinsightlycrm_apikey');

        $ico = new InsightlyCommunication;

        $ico->set_apikey($apikey);

        $user_array = $ico->get_resource('Users');

        $api_connection_verification = $ico->get_api_connection_verification();
        $nfinsightlycrm_comm_data['nfinsightlycrm_api_connection_verification'] = $api_connection_verification;

        $nfinsightlycrm_crm_account_data['user_array']=$user_array;
        
        update_option('nfinsightlycrm_comm_data', $nfinsightlycrm_comm_data);
        update_option(NF_InsightlyCRM_Constants::ACCOUNT_DATA, $nfinsightlycrm_crm_account_data);

        $redirect = admin_url() . 'admin.php?page=nf-settings#' . NF_InsightlyCRM::SLUG;

        wp_redirect($redirect);
        exit;
    }

}

add_action('init', 'NF_InsightlyCRM_Listener::listener');
