<?php

/**
 * Constants for use throughout extension
 *
 */
class NF_InsightlyCRM_Constants {
    /* -------------------
     * 
     * Authorization and Connectivity
     * 
     * --------------------
     */

    /** Ninja Form setting for API Key */
    const API_KEY = 'nfinsightlycrm_apikey';

    /** Ninja Forms setting to display connection verification link */
    const CONNECTION_VERIFICATION = 'nfinsightlycrm_connection_verification';

    /* ------------------
     * 
     * Listener
     * 
     * ------------------
     */

    /**
     * URL for listening for instructions
     */
    const LISTENER_URL = 'nfinsightlycrm_instructions';

    /**
     * GET value for testing API connection
     */
    const CONNECTION_TEST = 'test-connection';

    /**
     * GET value for refreshing account data
     */
    const ACCOUNT_DATA_REFRESH = 'refresh-insightly-data';


    /* ------------------
     * 
     * Processing
     * 
     * ------------------
     */

    /** Key used for "add to" action */
    const ACTION_KEY = 'addtoinsightly';

    
    /** Key for option repeater template */
    const FIELD_MAP_REPEATER_KEY = 'field_map';

    /**
     * 
     * Called at form processing to manage the processing steps 
     */
    const PROCESS_CLASS = 'not_used';

    /**
     * 
     * Validates any value in and returns value out using static methods
     */
    const VALIDATION_CLASS = 'InsightlyValidateFields'; // currently not used

    /**
     * Formats the request array into the JSON request
     */
    const FORMAT_REQUEST_CLASS = 'not_used';

    /**
     * Creates an entry in the CRM
     */
    const CREATE_CLASS = 'not_used';

    /**
     * Retrieves existing account data from CRM
     */
    const ACCOUNT_DATA_CLASS = 'InsightlyGetAccountData'; // not implemented yet

    /**
     * Handle the response the comes back from the CRM
     */
    const RESPONSE_CLASS = 'InsightlyHandleResponse'; // not implemented yet
    const SUPPORT_CLASS = 'NF_InsightlyCRM_Support'; // not implemented yet

    /* -------------------
     * 
     * Settings
     * 
     * -------------------- 
     */

    /** Ninja Forms setting for advanced codes */
    const ADVANCED_CODES_KEY = 'nfinsightlycrm_advanced_codes';

    /** wp_options key for storing support data */
    const SUPPORT_DATA = 'nfinsightlycrm_comm_data';

    /** Support data key for submission field map data */
    const FIELD_MAP_DATA = 'nfinsightlycrm_field_map_data';

    /** Support data key for constructed request array */
    const REQUEST_ARRAY = 'nfinsightlycrm_most_recent_raw_request';

    /** Support data key for JSON-formatted request */
    const FORMATTED_REQUEST = 'not_used';

    /** Support data key for full response */
    const FULL_RESPONSE = 'nfinsightlycrm_most_recent_raw_response';

    /** Support data key for response summary */
    const RESPONSE_SUMMARY = 'nfinsightlycrm_comm_status';

    /** Settings data key for account data refresh link html*/
    const REFRESH_ACCOUNT = 'nfinsightlycrm_refresh_account_data';

    /** Settings data key for displaying CRM account users */
    const USER_LIST = 'nfinsightlycrm_user_list';
    
    /** wp_options key for storing account data */
    const ACCOUNT_DATA = 'nfinsightlycrm_crm_account_data';
    
    

    /* --------------------
     * 
     * API-specific settings
     * 
     * -------------------- 
     */

    /** Date format specified by the CRM */
    const DATE_FORMAT = 'Y-m-d';

    /** Base URL for all standard requests */
    const BASE_URL = 'https://api.insight.ly/v';

}
