<?php

/*
  Name: Ninja Forms Insightly CRM For pre-3.0
  Plugin URI: http://lb3computingsolutions.com
 */

/* ----------
  INCLUDES
  ---------------------------------------------------------------------------------------------------------- */

/* ----------
  Create options pages and settings required
  ------ */

include_once( NF2INSIGHTLYCRM_PLUGIN_DIR . '/deprecated/includes/settings.php');

include_once( NF2INSIGHTLYCRM_PLUGIN_DIR . '/deprecated/includes/form-settings.php');

/* ----------
  Create field options for mapping to Insightly
  ----- */

include_once( NF2INSIGHTLYCRM_PLUGIN_DIR . '/deprecated/includes/field-registration.php');


/* ----------
  Process form data to build communication request
  ----- */

include_once( NF2INSIGHTLYCRM_PLUGIN_DIR . '/deprecated/includes/form-processing.php');


/* ----------
  Build the request from the processed form data
  ----- */
include_once( NF2INSIGHTLYCRM_PLUGIN_DIR . '/deprecated/includes/Comm/InsightlyRawRequest.php');


/* ----------
  Include shared functions
  ----- */
include_once( NF2INSIGHTLYCRM_PLUGIN_DIR . '/deprecated/includes/Admin/Functions.php');


/* ----------
  Communicate with Insightly via API
  ----- */
include_once( NF2INSIGHTLYCRM_PLUGIN_DIR . '/deprecated/includes/Comm/InsightlyCommunication.php');

    /*
     * Load the global variables
     */
    nfinsightly_load_globals();
    
/* ----------
  LICENSING
  -------------------------------------------------------------------------------------------------------------- */

add_action( 'admin_init', 'nf2insightlycrm_extension_setup_license' );

function nf2insightlycrm_extension_setup_license() {
    if ( class_exists( 'NF_Extension_Updater' ) ) {
        $NF_Extension_Updater = new NF_Extension_Updater( 'Insightly CRM', NF2INSIGHTLYCRM_VERSION, 'Stuart Sequeira', __FILE__ );
    }
}

/* ----------
  LANGUAGE
  -------------------------------------------------------------------------------------------------------------- */

add_action( 'plugins_loaded', 'nf2insightlycrm_extension_load_lang' );

function nf2insightlycrm_extension_load_lang() {

    /** Set our unique textdomain string */
    $textdomain = 'ninja-forms-insightly-crm';

    /** The 'plugin_locale' filter is also used by default in load_plugin_textdomain() */
    $locale = apply_filters( 'plugin_locale', get_locale(), $textdomain );

    /** Set filter for WordPress languages directory */
    $wp_lang_dir = apply_filters(
            'ninja_forms_wp_lang_dir', WP_LANG_DIR . '/' . basename( dirname( __FILE__ ) ) . '/' . $textdomain . '-' . $locale . '.mo'
    );

    /** Translations: First, look in WordPress' "languages" folder = custom & update-secure! */
    load_textdomain( $textdomain, $wp_lang_dir );

    /** Translations: Secondly, look in plugin's "lang" folder = default */
    $plugin_dir = basename( dirname( __FILE__ ) );
    $lang_dir = apply_filters( 'nfinsightlycrm_extension_lang_dir', $plugin_dir . '/lang/' );
    load_plugin_textdomain( $textdomain, FALSE, $lang_dir );
}

/* ----------
  HOOK INTO THE FLOW
  -------------------------------------------------------------------------------------------------- */

add_action( 'init', 'nf2insightlycrm_frontend_hook' );

function nf2insightlycrm_frontend_hook() {

    add_action( 'ninja_forms_post_process', 'nf2insightlycrm_process_form' ); // form-processing.php
}
