<?php
/* --- NINJA FORMS INSIGHTLY CRM INTEGRATION --- */


/* ----------
  CREATE OPTIONS PAGE AND GET SETTINGS FOR SITE-WIDE VALUES
  ------------------------------------------------------------------------------------------------------------ */

/* ----------
  Create options page location
  ----- */

add_action( 'admin_menu', 'nfinsightlycrm_create_options_page_location', 100 );

function nfinsightlycrm_create_options_page_location() {

    add_submenu_page(
            'ninja-forms', //parent slug
            __( 'Insightly CRM Settings', 'ninja-forms-insightly-crm' ), //page title
            __( 'Insightly CRM Settings', 'ninja-forms-insightly-crm' ), //menu title
            'manage_options', //capability
            'nfinsightlycrm-site-options', //menu-slug
            'nfinsightlycrm_site_options_display_page' //display function
    );
}

// end nfinsightlycrm_create_options_page_location


/* ----------
  Output the html for the options page
  ----- */

function nfinsightlycrm_site_options_display_page() {

    global $nfinsightlycrm_settings;
    ?>
    <div class="wrap">
    <?php screen_icon( 'options-general' ); ?>
        <h2><?php _e( 'Ninja Forms Insightly CRM Settings', 'ninja-forms-insightly-crm' ); ?></h2>

        <form method="post" action="options.php" class="nfinsightlycrm_site_options_form">

    <?php
    // whitelist our variables and output the settings sections
    settings_fields( 'nfinsightlycrm-site-options' ); // whitelists all variables registered to this slug
    do_settings_sections( 'nfinsightlycrm-site-options-section' ); // outputs all sections added via add_settings_section
    // output the communication status
    echo nfinsightlycrm_output_comm_status();
    ?>
            <p class="submit">
                <input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'ninja-forms-insightly-crm' ); ?>" />
            </p>			
        </form>
    </div><!--end .wrap-->
    <?php
}

//end nfinsightlycrm_site_options_display_page


/* ----------
  CREATE OPTIONS FIELD AND SECTION
  Insert these options onto a menu page
  The menu page is a custom settings page created under the Ninja Forms main menu page
  ----- */

add_action( 'admin_init', 'nfinsightlycrm_create_sitewide_settings' );

function nfinsightlycrm_create_sitewide_settings() {

    /* --- Add Settings Section --- */

    $section_id = 'nfinsightlycrm_site_section'; //id for our section
    $section_title = __( 'Insightly Settings and Status', 'ninja-forms-insightly-crm' ); // about our section
    $section_output_function = 'nfinsightlycrm_section_output'; //

    $do_settings_section = 'nfinsightlycrm-site-options-section'; //on which page should our new section go

    add_settings_section(
            $section_id
            , $section_title
            , $section_output_function
            , $do_settings_section
    );


    /* --- register settings --- */
    $settings_fields = 'nfinsightlycrm-site-options';

    // registers our setting to allow it to appear in a given form	
    register_setting( $settings_fields, 'nfinsightlycrm_settings', 'nfinsightlycrm_validate_settings' );

    // registers our setting to allow it to appear in a given form	
    register_setting( $settings_fields, 'nfinsightlycrm_crm_account_data' );


    /* --- Create array to add each sitewide option --- */

    $options_array = array();

    $options_array[ 'apikey' ] = array(
        'field_id' => 'nfinsightlycrm_apikey',
        'field_title' => __( 'Insightly API Key', 'ninja-forms-insightly-crm' )
        , 'field_output_function' => 'nfinsightlycrm_apikey_field_output'
    );

    $options_array[ 'display_raw_comm' ] = array(
        'field_id' => 'nfinsightlycrm_display_raw_comm',
        'field_title' => __( 'Display the Raw Communication Data?', 'ninja-forms-insightly-crm' )
        , 'field_output_function' => 'nfinsightlycrm_display_raw_comm_field_output'
    );

    $options_array[ 'custom_field_list' ] = array(
        'field_id' => 'nfinsightlycrm_custom_field_list',
        'field_title' => __( '', 'ninja-forms-insightly-crm' )
        , 'field_output_function' => 'nfinsightlycrm_display_custom_fields_output'
    );


    /* --- Loop through each option array to add a field to a do_settings_section --- */

    foreach ( $options_array as $option ) {

        add_settings_field(
                $option[ 'field_id' ]//unique id for field
                , $option[ 'field_title' ]//field title
                , $option[ 'field_output_function' ]//function callback
                , $do_settings_section //on which page should our new field go
                , $section_id //in which settings section should our new field go
        );
    }
}

// end nfinsightlycrm_create_sitewide_settings


/* ----------
  Output the settings section tagline
  ----- */

function nfinsightlycrm_section_output() {

    echo __( 'Please enter your Insightly CRM API Key.  You can also use the communication status to ensure everything is connected correctly.', 'ninja-forms-insightly-crm' );
}

// end nfinsightlycrm_section_output


/* ----------
  Output the apikey form html
  ----- */

function nfinsightlycrm_apikey_field_output() {

    global $nfinsightlycrm_settings;

    ob_start();
    ?>

    <input 
        id="nfinsightlycrm_apikey"
        name="nfinsightlycrm_settings[nfinsightlycrm_apikey]"
        size = "50"
        type="text" 
        value = "<?php if ( isset( $nfinsightlycrm_settings[ 'nfinsightlycrm_apikey' ] ) ) {
        echo $nfinsightlycrm_settings[ 'nfinsightlycrm_apikey' ];
    } ?>" 
        />

    <?php
    echo ob_get_clean();
}

//end nfinsightlycrm_apikey_field_output



/* ----------
  Output the display raw comm form html
  Also display the comm strings if set to "Yes"
  ----- */

function nfinsightlycrm_display_raw_comm_field_output() {

    global $nfinsightlycrm_settings;


    if ( isset( $nfinsightlycrm_settings[ 'nfinsightlycrm_display_raw_comm' ] ) ) {

        $checked = $nfinsightlycrm_settings[ 'nfinsightlycrm_display_raw_comm' ];
    } else {
        $checked = 'no';
    }


    ob_start();
    ?>

    <input 
        id="nfinsightlycrm_display_raw_comm-yes"
        name="nfinsightlycrm_settings[nfinsightlycrm_display_raw_comm]"
        type="radio" 
        value = "TRUE" 
    <?php checked( $checked, 'TRUE', true ); ?>
        />
    Yes <br />

    <input 
        id="nfinsightlycrm_display_raw_comm-no"
        name="nfinsightlycrm_settings[nfinsightlycrm_display_raw_comm]"
        type="radio" 
        value = "FALSE" 
    <?php checked( $checked, 'FALSE', true ); ?>
        />
    No <br />


    <?php
    echo ob_get_clean();
}

//end nfinsightlycrm_subdomain_field_output


/* ----------
  Validate the apikey value before saving to database
  ----- */

function nfinsightlycrm_validate_settings( $input ) {

    $output = array();

    foreach ( $input as $key => $value ) {

        if ( isset( $input[ $key ] ) ) {

            $output[ $key ] = strip_tags( stripslashes( $input[ $key ] ) );
        }// endif
    } //end foreach

    return apply_filters( 'nfinsightlycrm_validate_settings', $output, $input );
}

// end nfinsightlycrm_validate_settings


/* ----------
  Create HTML for communication status

  ----- */

function nfinsightlycrm_output_comm_status() {

    global $nfinsightlycrm_settings;
    global $nfinsightlycrm_comm_data;

    if ( isset( $nfinsightlycrm_comm_data[ 'nfinsightlycrm_comm_status' ] ) ) {

        $insightly_comm_status = $nfinsightlycrm_comm_data[ 'nfinsightlycrm_comm_status' ];
    } else {
        $insightly_comm_status = apply_filters( 'nfinsightlycrm_modify_comm_status_default', "No communication has been detected.  Please test using your created form." );
    }


    if ( isset( $nfinsightlycrm_settings[ 'nfinsightlycrm_display_raw_comm' ] ) ) {

        $display_raw_comm = $nfinsightlycrm_settings[ 'nfinsightlycrm_display_raw_comm' ] == "TRUE";
    } else {
        $display_raw_comm = FALSE;
    }


    if ( isset( $nfinsightlycrm_comm_data[ 'nfinsightlycrm_most_recent_raw_request' ] ) ) {

        $most_recent_raw_request = $nfinsightlycrm_comm_data[ 'nfinsightlycrm_most_recent_raw_request' ];
    } else {
        $most_recent_raw_request = __( 'None', 'ninja-forms-insightly-crm' );
    }

    if ( isset( $nfinsightlycrm_comm_data[ 'nfinsightlycrm_most_recent_raw_response' ] ) ) {

        $most_recent_raw_response = $nfinsightlycrm_comm_data[ 'nfinsightlycrm_most_recent_raw_response' ];
    } else {
        $most_recent_raw_response = __( 'None', 'ninja-forms-insightly-crm' );
    }


    ob_start();
    ?>

    <table class="form-table">
        <tbody>
            <tr valign="top">
                <th scope="row"><?php _e( 'Communication Status', 'ninja-forms-insightly-crm' ); ?></th>
                <td>

                    <?php echo $insightly_comm_status; ?>

                </td>
            </tr>

    <?php if ( $display_raw_comm ) { ?>		
                <tr valign="top">
                    <th scope="row"><?php _e( 'Most recent raw request sent to Insightly', 'ninja-forms-insightly-crm' ); ?></th>
                    <td>

        <?php echo $most_recent_raw_request; ?>

                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'Most recent raw response from Insightly', 'ninja-forms-insightly-crm' ); ?></th>
                    <td>

        <?php echo $most_recent_raw_response; ?>

                    </td>
                </tr>			
    <?php } // end if $display_raw_com ?>

        </tbody>
    </table>

    <?php
    $comm_status_string = ob_get_clean();

    return $comm_status_string;
}

// end nfinsightlycrm_output_comm_status


/* ----------
  Retrieve current list of custom fields from Insightly account
  ----- */

function nfinsightlycrm_display_custom_fields_output() {

    global $nfinsightlycrm_crm_account_data;

    $value = ''; //initialize value

    $custom_field_list = nfinsightlycrm_get_custom_field_list();

    if ( is_array( $custom_field_list ) ) {

        $value = esc_html( serialize( $custom_field_list ) );
    } else {

        if ( isset( $nfinsightlycrm_crm_account_data[ 'nfinsightlycrm_custom_field_list' ] ) ) {

            $value = esc_html( $nfinsightlycrm_crm_account_data[ 'nfinsightlycrm_custom_field_list' ] );
        }
    }

    ob_start();
    ?>

    <input 
        id="nfinsightlycrm_custom_field_list"
        name="nfinsightlycrm_crm_account_data[nfinsightlycrm_custom_field_list]"
        size = "50"
        type="hidden"
        value = "<?php echo $value; ?>" 
        />

    <?php
    echo ob_get_clean();
}




