<?php
/* --- NINJA FORMS INSIGHTLY CRM INTEGRATION --- */

/* ----------
  FORM-SPECIFIC OPTIONS
  ------------------------------------------------------------------------------------------------------------------------ */

/* ----------
  Create the form-specific options
  ----- */

/* --- first, hook into the flow --- */
add_action( 'admin_init', 'nfinsightlycrm_admin_hook', 12 );

function nfinsightlycrm_admin_hook() {

    nfinsightlycrm_create_form_options();
}



/* ----------
  Create the form specific options

  filter_nfinsightlycrm_form_options enables you to extend more form options
  ----- */

function nfinsightlycrm_create_form_options() {

    $metabox_settings_array = array( //Add form data as contact?
        array(
            'name' => 'nfinsightlycrm_create_new_contact',
            'type' => 'checkbox',
            'label' => __( 'Create a new Insightly entry?', 'ninja-forms-insightly-crm' ),
            'desc' => __( 'Do you want this form data added to Insightly CRM ?', 'ninja-forms-insightly-crm' ),
            'default_value' => false,
        ),
    );


    $args = array(
        'page' => 'ninja-forms',
        'tab' => 'form_settings',
        'slug' => 'nfinsightlycrm_form_settings',
        'title' => __( 'Insightly CRM Settings', 'ninja-forms-insightly-crm' ),
        'settings' => apply_filters( 'filter_nfinsightlycrm_form_options', $metabox_settings_array ),
    );

    if ( function_exists( 'ninja_forms_register_tab_metabox_options' ) ) {

        ninja_forms_register_tab_metabox( $args );
    }
}

//end nfinsightlycrm_create_form_options

