<?php

/* --- NINJA FORMS INSIGHTLY CRM INTEGRATION --- */


/* ----------
  PROCESS FORM DATA
  ------------------------------------------------------------------------------------------------------------ */

function nf2insightlycrm_process_form() {

    global $nfinsightlycrm_settings;
    global $ninja_forms_processing;
    global $nfinsightlycrm_comm_data;

    $apikey = $nfinsightlycrm_settings[ 'nfinsightlycrm_apikey' ];

    // Check if the form should be inserted as Insightly lead
    $the_droids = $ninja_forms_processing->get_form_setting( 'nfinsightlycrm_create_new_contact' );
    if ( !$the_droids ) {
        return;
    } ///this is not the form you're looking for	
    // create the request object and the communication object

    if ( class_exists( 'InsightlyPlusRawRequest' ) ) {
        $request_object = new InsightlyPlusRawRequest();
    } else {
        $request_object = new InsightlyRawRequest_v2_9();
    }

    if ( class_exists( 'InsightlyPlusCommunication' ) ) {
        $ico = new InsightlyPlusCommunication();
    } else {
        $ico = new InsightlyCommunication_v2_9();
    }


    $ico->set_apikey( $apikey );


    // retrieve an array of all fields on the form
    $field_array = $ninja_forms_processing->get_all_fields();

    // iterate through the fields and extract the field maps and validate the form value

    foreach ( $field_array as $field_id => $form_value ) { //cycle through each submitted field
        
        if(''==$form_value){ continue;} // do not map an empty value - since 1.5.1
        
        
        $field = ninja_forms_get_field_by_id( $field_id );

        if ( isset( $field[ 'data' ][ 'nfinsightlycrm_field_map' ] ) ) {


            // extract mapping arguments into an array for processing
            $map_args = nf2insightlycrm_extract_map_args( $field );
            
            // run any needed validation checks on the submitted form value
            $validated_form_value = nf2insightlycrm_validate_form_value( $form_value );

            $request_object->map_field_data( $validated_form_value, $map_args );
        } 
    } 
    
    // indicate end of form data to finish formatting request object
    $request_object->finalize_raw_request(); 

    $raw_request = $request_object->get_raw_request_array();

    $ico->process_form_request( $raw_request );

    $status_update = $ico->get_status_update();
    $raw_response = $ico->get_raw_response();
    $finalized_request = $ico->get_raw_request_array(); // the request array after additions made during communication

    $request_arrays = array(
        'before' => $raw_request,
        'finalized' => $finalized_request
    );

    $nfinsightlycrm_comm_data[ 'nfinsightlycrm_comm_status' ] = $status_update;
    $nfinsightlycrm_comm_data[ 'nfinsightlycrm_most_recent_raw_request' ] = serialize( $request_arrays );
    $nfinsightlycrm_comm_data[ 'nfinsightlycrm_most_recent_raw_response' ] = serialize( $raw_response );

    update_option( 'nfinsightlycrm_comm_data', $nfinsightlycrm_comm_data );
}

/**
 * Build an array of the mapping arguments
 *  'field_map' => Insightly field for the form value
 *  'entry_type' => Certain field maps require an entry type (Work, Mobile, etc)
 * @param array $field
 * @return array $map_args
 */
function nf2insightlycrm_extract_map_args( $field ) {

    $map_args[ 'field_map' ] = $field[ 'data' ][ 'nfinsightlycrm_field_map' ];
    
    if ( isset( $field[ 'data' ][ 'nfinsightlycrm_entry_type' ] ) ) {

        $map_args[ 'entry_type' ] = $field[ 'data' ][ 'nfinsightlycrm_entry_type' ];
    }

    return $map_args;
}

function nf2insightlycrm_validate_form_value( $form_value ) {

    $validated_form_value = $form_value; // set a default value
    // check for array
    if ( is_array( $form_value ) ) {

        $validated_form_value = implode( ', ', $form_value );
    }


    return $validated_form_value;
}

// end nfinsightlycrm_process_form_to_insert_lead

