<?php

/* --- NINJA FORMS INSIGHTLY CRM INTEGRATION --- */


/* ----------
  Register the Insightly Field Mapping Options for All Mappable Fields
  Includes custom field box and Insightly's entry type (home, work, mobile, fax, etc)
  ------------------------------------------------------------------------------------------------------------ */

function nf2insightlycrm_modify_field_defaults( $field_id ) {

    // Get the field type for the given field
    $field = ninja_forms_get_field_by_id( $field_id );
    $field_type = $field[ 'type' ];

    // Add standard NF fields that will be mapped
    // Special field mapping can be defined in nfinsightlycrm_return_field_map_options and assigned here with a string name
    $mappable_nf_fields_array = nf2insightlycrm_build_mappable_nf_fields_array();


    // Build an array of custom fields pulled from other extensions
    $extension_fields_array = nf2insightlycrm_grab_custom_fields_from_extensions();

    //Combine the two arrays into one master array of mappable fields
    //The two are kept separate so that an error in an extension doesn't mess with the default behavior
    $extended_mappable_fields_array = array_merge( $mappable_nf_fields_array, $extension_fields_array );


    if ( isset( $extended_mappable_fields_array[ $field_type ] ) ) {

        //pull the field map options for this field type and build the selection list	
        $field_map_options = nf2insightlycrm_return_field_map_options( $extended_mappable_fields_array[ $field_type ] );

        if ( isset( $field_map_options ) && is_array( $field_map_options ) ) {
            foreach ( $field_map_options as $field_map => $map_code ) {

                $field_map_options_array[] = array( 'name' => $field_map, 'value' => $map_code );
            }
        } else {
            return;
        }


        // set variables for mapping field select option
        $type = 'select';
        $label = __( 'Insightly CRM Field Map', 'ninja-forms-insightly-crm' );
        $name = 'nfinsightlycrm_field_map';
        $width = 'thin';
        $options = $field_map_options_array;
        $class = 'widefat';
        $desc = ''; //__( 'Map this field to your Insightly CRM', 'ninja-forms-insightly-crm' );
        $label_class = '';


        // check if this field has a field map already selected
        if ( isset( $field[ 'data' ][ 'nfinsightlycrm_field_map' ] ) ) {
            $value = $field[ 'data' ][ 'nfinsightlycrm_field_map' ];

            if ( 'divider' == $value ) {

                $value = 'none';
            }
        } else {

            $value = 'none';
        }//end is set
        // Add field mapping option to the field
        ninja_forms_edit_field_el_output(
                $field_id
                , $type
                , $label
                , $name
                , $value
                , $width
                , $options
                , $class
                , $desc
                , $label_class
        );




        /* -----
          Create the Entry Type Box
          ---------- */

        // Entry type can be Home Work Mobile Fax Direct Postal
        // Not all entry types will apply to all field maps; data processing will use only valid maps depending on mapping context
        // create entry_type dropdown	
        $field_map_options = nf2insightlycrm_return_entry_type_options( $extended_mappable_fields_array[ $field_type ] );
        $field_map_options_array = array();

        foreach ( $field_map_options as $field_map => $map_code ) {

            $field_map_options_array[] = array( 'name' => $field_map, 'value' => $map_code );
        }

        // set variables for mapping entry_type select option
        $type = 'select';
        $label = __( 'Entry Type', 'ninja-forms-insightly-crm' );
        $name = 'nfinsightlycrm_entry_type';
        $width = 'thin';
        $options = $field_map_options_array;
        $class = 'widefat';
        $desc = '';


        //check if this field has a field map already selected
        if ( isset( $field[ 'data' ][ 'nfinsightlycrm_entry_type' ] ) ) {

            $value = $field[ 'data' ][ 'nfinsightlycrm_entry_type' ];
        } else {

            $value = '';
        }//end is set
        // Add entry_type field map text box to this field
        ninja_forms_edit_field_el_output(
                $field_id
                , $type
                , $label
                , $name
                , $value
                , $width
                , $options
                , $class
                , $desc
                , $label_class
        );
    } //end isset( $extended_mappable_fields_array[ $field_type ] )
}

// end nfinsightlycrm_modify_field_defaults

add_action( 'ninja_forms_edit_field_after_registered', 'nf2insightlycrm_modify_field_defaults', 10 );


/* ----------
  Return the selection options for a giving field or option
  Create field map options
  Defaults to full Insightly field list, modified lists are named by a string passed as $map
  ------------------------------------------------------------------------------------------------------------------------ */

// construction for selection value is resource.majorkey.minorkey
function nf2insightlycrm_return_field_map_options( $map = '' ) {

    $complete_field_map_options = array(
       __( '-None-', 'ninja-forms-insightly-crm' ) => 'none',
        __( 'Contact - Salutation', 'ninja-forms-insightly-crm' ) => 'nfcontacts.SALUTATION',
        __( 'Contact - First Name', 'ninja-forms-insightly-crm' ) => 'nfcontacts.FIRST_NAME',
        __( 'Contact - Last Name', 'ninja-forms-insightly-crm' ) => 'nfcontacts.LAST_NAME',
        __( 'Contact - Background', 'ninja-forms-insightly-crm' ) => 'nfcontacts.BACKGROUND',
        __( 'Contact - Street', 'ninja-forms-insightly-crm' ) => 'nfcontacts.ADDRESSES.STREET',
        __( 'Contact - City', 'ninja-forms-insightly-crm' ) => 'nfcontacts.ADDRESSES.CITY',
        __( 'Contact - State', 'ninja-forms-insightly-crm' ) => 'nfcontacts.ADDRESSES.STATE',
        __( 'Contact - Post Code', 'ninja-forms-insightly-crm' ) => 'nfcontacts.ADDRESSES.POSTCODE',
        __( 'Contact - Country', 'ninja-forms-insightly-crm' ) => 'nfcontacts.ADDRESSES.COUNTRY',
        __( 'Contact - Email', 'ninja-forms-insightly-crm' ) => 'nfcontacts.CONTACTINFOS.Email',
        __( 'Contact - Phone', 'ninja-forms-insightly-crm' ) => 'nfcontacts.CONTACTINFOS.Phone',
        __( 'Contact - Social', 'ninja-forms-insightly-crm' ) => 'nfcontacts.CONTACTINFOS.Social',
        __( 'Contact - Website', 'ninja-forms-insightly-crm' ) => 'nfcontacts.CONTACTINFOS.Website',
//        __( 'Contact - Owner User ID', 'ninja-forms-insightly-crm' ) => 'nfcontacts.OWNER_USER_ID',
        __( 'Organization', 'ninja-forms-insightly-crm' ) => 'nforganizations.ORGANISATION_NAME',
        __( 'Role', 'ninja-forms-insightly-crm' ) => 'nfcontacts.LINKS.nforganisation.ROLE',
        __( 'Contact Tag', 'ninja-forms-insightly-crm' ) => 'nfcontacts.TAGS.TAG_NAME',
        __( 'Lead - Salutation', 'ninja-forms-insightly-crm' ) => 'nfleads.SALUTATION',
        __( 'Lead - Title', 'ninja-forms-insightly-crm' ) => 'nfleads.TITLE',
        __( 'Lead - First Name', 'ninja-forms-insightly-crm' ) => 'nfleads.FIRST_NAME',
        __( 'Lead - Last Name', 'ninja-forms-insightly-crm' ) => 'nfleads.LAST_NAME',
        __( 'Lead - Street', 'ninja-forms-insightly-crm' ) => 'nfleads.ADDRESS_STREET',
        __( 'Lead - City', 'ninja-forms-insightly-crm' ) => 'nfleads.ADDRESS_CITY',
        __( 'Lead - State', 'ninja-forms-insightly-crm' ) => 'nfleads.ADDRESS_STATE',
        __( 'Lead - Post Code', 'ninja-forms-insightly-crm' ) => 'nfleads.ADDRESS_POSTCODE',
        __( 'Lead - Country', 'ninja-forms-insightly-crm' ) => 'nfleads.ADDRESS_COUNTRY',
        __( 'Lead - Organization', 'ninja-forms-insightly-crm' ) => 'nfleads.ORGANIZATION_NAME',
        __( 'Lead - Phone', 'ninja-forms-insightly-crm' ) => 'nfleads.PHONE_NUMBER',
        __( 'Lead - Mobile Phone', 'ninja-forms-insightly-crm' ) => 'nfleads.MOBILE_PHONE_NUMBER',
        __( 'Lead - Fax Number', 'ninja-forms-insightly-crm' ) => 'nfleads.FAX_NUMBER',
        __( 'Lead - Email Address', 'ninja-forms-insightly-crm' ) => 'nfleads.EMAIL_ADDRESS',
        __( 'Lead - Website URL', 'ninja-forms-insightly-crm' ) => 'nfleads.WEBSITE_URL',
        __( 'Lead - Description', 'ninja-forms-insightly-crm' ) => 'nfleads.LEAD_DESCRIPTION',
        __( 'Lead - Industry', 'ninja-forms-insightly-crm' ) => 'nfleads.INDUSTRY',
        __( 'Lead - Employee Count', 'ninja-forms-insightly-crm' ) => 'nfleads.EMPLOYEE_COUNT',
        __( 'Lead - Lead Rating', 'ninja-forms-insightly-crm' ) => 'nfleads.LEAD_RATING',
        __( 'Lead - Lead Status ID', 'ninja-forms-insightly-crm' ) => 'nfleads.LEAD_STATUS_ID',
        __( 'Lead - Lead Source ID', 'ninja-forms-insightly-crm' ) => 'nfleads.LEAD_SOURCE_ID',
        __( 'Lead - Responsible User ID', 'ninja-forms-insightly-crm' ) => 'nfleads.RESPONSIBLE_USER_ID',
//        __( 'Lead - Owner User ID', 'ninja-forms-insightly-crm' ) => 'nfleads.OWNER_USER_ID',
        __( 'Lead Tag', 'ninja-forms-insightly-crm' ) => 'nfleads.TAGS.TAG_NAME',
        __( 'Opportunity', 'ninja-forms-insightly-crm' ) => 'nfopportunities.OPPORTUNITY_NAME',
        __( 'Opportunity Details', 'ninja-forms-insightly-crm' ) => 'nfopportunities.OPPORTUNITY_DETAILS',
        __( 'Opportunity State', 'ninja-forms-insightly-crm' ) => 'nfopportunities.OPPORTUNITY_STATE',
        __( 'Opportunity Pipeline', 'ninja-forms-insightly-crm' ) => 'nfopportunities.PIPELINE_ID',
        __( 'Opportunity Stage', 'ninja-forms-insightly-crm' ) => 'nfopportunities.STAGE_ID',
        __( 'Opportunity Tag', 'ninja-forms-insightly-crm' ) => 'nfopportunities.TAGS.TAG_NAME',
        __( 'Opportunity Role', 'ninja-forms-insightly-crm' ) => 'nfcontacts.LINKS.nfopportunities.ROLE',
        __( 'Project Name', 'ninja-forms-insightly-crm' ) => 'nfprojects.PROJECT_NAME',
        __( 'Project Status', 'ninja-forms-insightly-crm' ) => 'nfprojects.STATUS',
        __( 'Project Details', 'ninja-forms-insightly-crm' ) => 'nfprojects.PROJECT_DETAILS',
        __( 'Project Pipeline', 'ninja-forms-insightly-crm' ) => 'nfprojects.PIPELINE_ID',
        __( 'Project Stage', 'ninja-forms-insightly-crm' ) => 'nfprojects.STAGE_ID',
        __( 'Project Tag', 'ninja-forms-insightly-crm' ) => 'nfprojects.TAGS.TAG_NAME',
        __( 'Project Role', 'ninja-forms-insightly-crm' ) => 'nfcontacts.LINKS.nfprojects.ROLE',
        __( 'Note Title', 'ninja-forms-insightly-crm' ) => 'nfnotes.TITLE',
        __( 'Note Body', 'ninja-forms-insightly-crm' ) => 'nfnotes.BODY',
        __( 'Task Title', 'ninja-forms-insightly-crm' ) => 'nftasks.TITLE',
        __( 'Task Due Date', 'ninja-forms-insightly-crm' ) => 'nftasks.DUE_DATE',
        __( 'Task Details', 'ninja-forms-insightly-crm' ) => 'nftasks.DETAILS',
        __( 'Task Status', 'ninja-forms-insightly-crm' ) => 'nftasks.STATUS',
        __( 'Task Priority', 'ninja-forms-insightly-crm' ) => 'nftasks.PRIORITY',
        __( 'Task Percent Complete', 'ninja-forms-insightly-crm' ) => 'nftasks.PERCENT_COMPLETE',
        __( 'Task Responsibility ID', 'ninja-forms-insightly-crm' ) => 'nftasks.RESPONSIBLE_USER_ID',
        __( 'Task Owner ID', 'ninja-forms-insightly-crm' ) => 'nftasks.OWNER_USER_ID',
    );

    switch ($map) { //create custom selection lists for specific field types
        case '_textarea':
            $field_map_options = array(
                __( '-None-', 'ninja-forms-insightly-crm' ) => 'none',
                __( 'Background', 'ninja-forms-insightly-crm' ) => 'nfcontacts.BACKGROUND',
                __( 'Opportunity Details', 'ninja-forms-insightly-crm' ) => 'nfopportunities.OPPORTUNITY_DETAILS',
                __( 'Project Details', 'ninja-forms-insightly-crm' ) => 'nfprojects.PROJECT_DETAILS',
                __( 'Note Body', 'ninja-forms-insightly-crm' ) => 'nfnotes.BODY',
                __( 'Task Details', 'ninja-forms-insightly-crm' ) => 'nftasks.DETAILS',
                __( 'Lead - Description', 'ninja-forms-insightly-crm' ) => 'nfleads.LEAD_DESCRIPTION',
            );

            break;
        case '_country':
            $field_map_options = array(
                __( '-None-', 'ninja-forms-insightly-crm' ) => 'none',
                __( 'Contact - Country', 'ninja-forms-insightly-crm' ) => 'nfcontacts.ADDRESSES.COUNTRY',
                __( 'Lead - Country', 'ninja-forms-insightly-crm' ) => 'nfleads.ADDRESS_COUNTRY',
            );

            break;

        default:
            $field_map_options = $complete_field_map_options; //set a default
    }


    return apply_filters( 'nfinsightlycrm_filter_field_map_options', $field_map_options, $map );
}

//similar to field map options, for the entry-type option
function nf2insightlycrm_return_entry_type_options( $map = '' ) {

    $complete_entry_type_options = array(
        __( '-None', 'ninja-forms-insightly-crm' ) => 'none',
        __( 'Work (web/phone/email/address)', 'ninja-forms-insightly-crm' ) => 'Work',
        __( 'Personal (email/web)', 'ninja-forms-insightly-crm' ) => 'Personal',
        __( 'Home (phone/address)', 'ninja-forms-insightly-crm' ) => 'Home',
        __( 'Other', 'ninja-forms-insightly-crm' ) => 'Other',
        __( 'Blog (web)', 'ninja-forms-insightly-crm' ) => 'Blog',
        __( 'Mobile (phone)', 'ninja-forms-insightly-crm' ) => 'Mobile',
        __( 'Fax (phone)', 'ninja-forms-insightly-crm' ) => 'Fax',
        __( 'Direct (phone)', 'ninja-forms-insightly-crm' ) => 'Direct',
        __( 'Postal (address)', 'ninja-forms-insightly-crm' ) => 'Postal',
        __( 'Pager (phone)', 'ninja-forms-insightly-crm' ) => 'Pager',
        __( 'Y!Messenger (phone)', 'ninja-forms-insightly-crm' ) => 'Y! Messenger',
        __( 'Skype (phone)', 'ninja-forms-insightly-crm' ) => 'Skype',
        __( 'SIP (phone)', 'ninja-forms-insightly-crm' ) => 'SIP',
        __( 'Linked In (social)', 'ninja-forms-insightly-crm' ) => 'LinkedInPublicProfileUrl',
        __( 'TwitterID (social)', 'ninja-forms-insightly-crm' ) => 'TwitterID'
    );

    switch ($map) { //create custom selection lists for specific field types
        case '_textarea':
            $entry_type_options = array(
                __( '-None', 'ninja-forms-insightly-crm' ) => 'none'
            );
            break;
        case '_country':
            $entry_type_options = array(
                __( 'Work (web/phone/email/address)', 'ninja-forms-insightly-crm' ) => 'Work',
                __( 'Home (phone/address)', 'ninja-forms-insightly-crm' ) => 'Home',
                __( 'Other', 'ninja-forms-insightly-crm' ) => 'Other'
            );

            break;

        case '_country':
            $entry_type_options = array(
                __( 'Work (web/phone/email/address)', 'ninja-forms-insightly-crm' ) => 'Work',
                __( 'Home (phone/address)', 'ninja-forms-insightly-crm' ) => 'Home',
                __( 'Other', 'ninja-forms-insightly-crm' ) => 'Other'
            );

            break;


        default:
            $entry_type_options = $complete_entry_type_options; //set a default
    }

    return $entry_type_options;
}

/* -----
  Append Custom Contact fields to field map list
  ---------- */

add_filter( 'nfinsightlycrm_filter_field_map_options', 'nf2insightlycrm_add_custom_fields_to_field_map_options', 10, 2 );

function nf2insightlycrm_add_custom_fields_to_field_map_options( $field_map_options, $map ) {

    global $nfinsightlycrm_crm_account_data;

    if ( isset( $nfinsightlycrm_crm_account_data[ 'nfinsightlycrm_custom_field_list' ] ) ) {

        $temp_array = unserialize( $nfinsightlycrm_crm_account_data[ 'nfinsightlycrm_custom_field_list' ] );

        if ( is_array( $temp_array ) ) {

            foreach ( $temp_array as $key => $label ) {

                if ( 'CONTACT_FIELD' == substr( $key, 0, 13 ) ) { // Map contact custom fields
                    $temp_label = '- Contact';
                    $temp_module = 'nfcontacts';
                }

                if ( 'ORGANISATION_FIELD' == substr( $key, 0, 18 ) ) { // Map organisation custom fields
                    $temp_label = '- Organisation';
                    $temp_module = 'nforganizations';
                }

                if ( 'OPPORTUNITY_FIELD' == substr( $key, 0, 17 ) ) { // Map opportunity custom fields
                    $temp_label = '- Opportunity';
                    $temp_module = 'nfopportunities';
                }

                if ( 'PROJECT_FIELD' == substr( $key, 0, 13 ) ) { // Map project custom fields
                    $temp_label = '- Project';
                    $temp_module = 'nfprojects';
                }

                if ( 'LEAD_FIELD' == substr( $key, 0, 10 ) ) { // Map project custom fields
                    $temp_label = '- Lead';
                    $temp_module = 'nfleads';
                }
                
                $custom_field_list[ $label . $temp_label ] = $temp_module . '.CUSTOMFIELDS.' . $key;
            }
        }
        if ( isset( $custom_field_list ) ) {
            $field_map_options = array_merge( $field_map_options, $custom_field_list );
        }
    }

    return $field_map_options;
}

// Build an array of standard NF fields that can be mapped to Insightly CRM
// Set values to empty string unless using a custom mapping list
function nf2insightlycrm_build_mappable_nf_fields_array() {

    $mappable_nf_fields_array = array();
    $mappable_nf_fields_array[ '_text' ] = '';
    $mappable_nf_fields_array[ '_hidden' ] = '';
    $mappable_nf_fields_array[ '_list' ] = '';
    $mappable_nf_fields_array[ '_textarea' ] = '_textarea';
    $mappable_nf_fields_array[ '_state' ] = '_textarea';
    $mappable_nf_fields_array[ '_country' ] = '_country';
    $mappable_nf_fields_array[ '_calc' ] = '';
    $mappable_nf_fields_array[ '_number' ] = '';
    return $mappable_nf_fields_array;
}

/* ----------
  Grab custom fields from other extensions
  Each new extension will require a function in here to build the array
  ------------------------------------------------------------------------------------------------------------------------ */

// User Analytics
function nf2insightlycrm_grab_custom_fields_from_extensions() {

    $extension_fields_array = array();

    // grab User Analytics fields
    global $NF_User_Analytics;

    // Make sure the $NF_User_Analytics variable is available
    if ( isset( $NF_User_Analytics ) ) {

        // access the get_ua_fields() method of the UA class
        $ua_fields = $NF_User_Analytics->get_ua_fields();

        // do whatever you need with the $ua_fields
        foreach ( $ua_fields as $key => $array ) {

            $extension_fields_array[ $key ] = '';
        }
    }

    return $extension_fields_array;
}
