<?php

/* --- NINJA FORMS INSIGHTLY CRM INTEGRATION --- */

/* ----------
  Class InsightlyRawRequest_v2_9
  ------------------------------------------------------------------------------------------------------------ */

class InsightlyRawRequest_v2_9 {

    protected $raw_request_array;

    function __construct() {

        $this->raw_request_array = array();
    }

    /* Public Methods
      -------------------- */
    public function map_field_data( $form_value, $map_args = array( 'field_map' => 'none' ) ) {

        if ( 'none' == $map_args[ 'field_map' ] ) {
            return;
        }//no mapping shall be done this day
        // modify any needed values before continuing
        switch ($map_args[ 'field_map' ]) {

            case 'nftasks.DUE_DATE': // modify timestamp by form_value
                $date = new DateTime(); // get a timestamp

                date_add( $date, date_interval_create_from_date_string( $form_value ) );

                $form_value = $date->format( 'Y-m-d H:i:s' );

                break;

            default:
        }


        /*
         * NF3 escapes textarea tags; when these get sent to a custom field, these
         * tags appear as text.  The new default function is to decode
         * and then strip these tags, then escape the result
         * 
         * A filter allows one to keep the new functionality
         */
        $keep_tags = apply_filters('nfinsightlycrm_keep_html_tags', FALSE);

        if (!$keep_tags) {
            $decoded = html_entity_decode($form_value);
            $stripped = wp_strip_all_tags($decoded);
            $form_value = esc_html($stripped);
        }

        $mapped_field_array = explode( '.', $map_args[ 'field_map' ] );

        $count = count( $mapped_field_array ); // see how deep the array is


        if ( 2 == $count ) { // top level into a given resource
            $this->map_single_level( $form_value, $map_args );
        }

        if ( 3 == $count ) { // requires additional handling for multi-level array
            switch ($mapped_field_array[ 1 ]) { // handle the various field mapping options
                case "CONTACTINFOS": // map contact info
                    $this->map_contactinfos( $form_value, $map_args );
                    break;

                case "CUSTOMFIELDS":
                    $this->map_customfields( $form_value, $map_args );
                    break;

                case "ADDRESSES": // map address info
                    $this->map_addresses( $form_value, $map_args );
                    break;

                case "TAGS": // map tags
                    $this->map_tags( $form_value, $map_args );
            }
        }

        if ( 4 == $count ) { // requires additional handling for multi-level array
            switch ($mapped_field_array[ 1 ]) { // handle the various field mapping options	
                case "LINKS": // map address info
                    $this->map_links( $form_value, $map_args );


                default:
                    break;
            }
        }
    }

    public function finalize_raw_request() {

        $this->set_address_type();
        $this->set_default_required_fields();
    }

    /*
      Internal Processing
      -------------------- */
    // map custom fields
    protected function map_customfields( $form_value, $map_args ) {

        $mapped_field_array = explode( '.', $map_args[ 'field_map' ] );

        $temp_array = array(
            "CUSTOM_FIELD_ID" => $mapped_field_array[ 2 ],
            "FIELD_VALUE" => $form_value
        );

        $this->raw_request_array[ $mapped_field_array[ 0 ] ][ $mapped_field_array[ 1 ] ][] = $temp_array;
    }

    // map tags
    protected function map_tags( $form_value, $map_args ) {

        if ( isset( $map_args[ 'entry_type' ] ) ) {

            $mapped_field_array = explode( '.', $map_args[ 'field_map' ] );

            $this->raw_request_array[ $mapped_field_array[ 0 ] ][ $mapped_field_array[ 1 ] ][] = array( $mapped_field_array[ 2 ] => $form_value );
        }
    }

    // map single level -- a top level array for given resource ( eg. FIRST_NAME on a Contact)
    protected function map_single_level( $form_value, $map_args ) {

        $mapped_field_array = explode( '.', $map_args[ 'field_map' ] );

        if ( 'ADDRESS_COUNTRY' == $mapped_field_array[ 1 ] ) {

            $form_value = $this->nfinsightlycrm_convert_country_codes( $form_value );
        }
        $this->raw_request_array[ $mapped_field_array[ 0 ] ][ $mapped_field_array[ 1 ] ] = $form_value;

        return;
    }

    // CONTACTINFOS use only one field map but have multiple items in the array detail
    protected function map_contactinfos( $form_value, $map_args ) {

        $mapped_field_array = explode( '.', $map_args[ 'field_map' ] );

        $temp_array = array(
            "TYPE" => $mapped_field_array[ 2 ],
            "LABEL" => $map_args[ 'entry_type' ],
            "DETAIL" => $form_value
        );

        $this->raw_request_array[ $mapped_field_array[ 0 ] ][ $mapped_field_array[ 1 ] ][] = $temp_array;

        return;
    }

    /**
     * Consolidates the contact's address fields during field processing 
     * 
     * The address fields get "finalized" by adding address type to its array and removing the temporary key
     * @param type $form_value
     * @param type $map_args
     * @return type
     */
    protected function map_addresses( $form_value, $map_args ) {

        $mapped_field_array = explode( '.', $map_args[ 'field_map' ] );

        if ( 'COUNTRY' == $mapped_field_array[ 2 ] ) {

            $form_value = $this->nfinsightlycrm_convert_country_codes( $form_value );
        }

        $this->raw_request_array[ $mapped_field_array[ 0 ] ][ $mapped_field_array[ 1 ] ][ $map_args[ 'entry_type' ] ][ $mapped_field_array[ 2 ] ] = $form_value;

        return;
    }

    // add the address type and remove the key
    protected function set_address_type( $resource = 'nfcontacts' ) {

        if ( isset( $this->raw_request_array[ $resource ][ 'ADDRESSES' ] ) ) {
            foreach ( $this->raw_request_array[ $resource ][ 'ADDRESSES' ] as $address_type => $address_array ) {

                $address_array[ "ADDRESS_TYPE" ] = $address_type;

                unset( $this->raw_request_array[ $resource ][ 'ADDRESSES' ][ $address_type ] );

                $this->raw_request_array[ $resource ][ 'ADDRESSES' ][] = $address_array;
            }
        }
    }

    /**
     * Checks raw request for modules that have required fields and if
     * these required fields do not have a mapping to them, add a default
     * value so that the request does not fail.
     * 
     * @since 1.8
     */
    protected function set_default_required_fields() {

        if ( isset( $this->raw_request_array[ 'nfopportunities' ] ) ) {

            if ( !isset( $this->raw_request_array[ 'nfopportunities' ][ 'OPPORTUNITY_STATE' ] ) ) {
                $this->raw_request_array[ 'nfopportunities' ][ 'OPPORTUNITY_STATE' ] = 'Open';
            }

            if ( !isset( $this->raw_request_array[ 'nfopportunities' ][ 'OPPORTUNITY_NAME' ] ) ) {
                $this->raw_request_array[ 'nfopportunities' ][ 'OPPORTUNITY_NAME' ] = 'New Web Inquiry Opportunity';
            }
        }
        
        if ( isset( $this->raw_request_array[ 'nfprojects' ] ) ) {

            if ( !isset( $this->raw_request_array[ 'nfprojects' ][ 'STATUS' ] ) ) {
                $this->raw_request_array[ 'nfprojects' ][ 'STATUS' ] = 'Not Started';
            }

            if ( !isset( $this->raw_request_array[ 'nfprojects' ][ 'PROJECT_NAME' ] ) ) {
                $this->raw_request_array[ 'nfprojects' ][ 'PROJECT_NAME' ] = 'New Web Inquiry Project';
            }
        }
        
        if ( isset( $this->raw_request_array[ 'nftasks' ] ) ) {

            if ( !isset( $this->raw_request_array[ 'nftasks' ][ 'TITLE' ] ) ) {
                $this->raw_request_array[ 'nftasks' ][ 'TITLE' ] = 'Task from Web Inquiry';
            }
            
            if ( !isset( $this->raw_request_array[ 'nftasks' ][ 'STATUS' ] ) ) {
                $this->raw_request_array[ 'nftasks' ][ 'STATUS' ] = 'Not Started';
            }

        }
    }

    // LINKS need additional data after initial responses from Insightly and then "finalized" by adding the link valueto its array and removing the temporary key
    // this can only be finalized by the communication object
    protected function map_links( $form_value, $map_args ) {

        $mapped_field_array = explode( '.', $map_args[ 'field_map' ] );


        $this->raw_request_array[ $mapped_field_array[ 0 ] ][ $mapped_field_array[ 1 ] ][ $mapped_field_array[ 2 ] ][ $mapped_field_array[ 3 ] ] = $form_value;

        return;
    }

    protected function nfinsightlycrm_convert_country_codes( $country_code ) {

        $country_conversion_array = array(
            'AF' => 'Afghanistan',
            'AL' => 'Albania',
            'DZ' => 'Algeria',
            'AS' => 'American Samoa',
            'AD' => 'Andorra',
            'AO' => 'Angola',
            'AI' => 'Anguilla',
            'AQ' => 'Antarctica',
            'AG' => 'Antigua And Barbuda',
            'AR' => 'Argentina',
            'AM' => 'Armenia',
            'AW' => 'Aruba',
            'AU' => 'Australia',
            'AT' => 'Austria',
            'AZ' => 'Azerbaijan',
            'BS' => 'Bahamas',
            'BH' => 'Bahrain',
            'BD' => 'Bangladesh',
            'BB' => 'Barbados',
            'BY' => 'Belarus',
            'BE' => 'Belgium',
            'BZ' => 'Belize',
            'BJ' => 'Benin',
            'BM' => 'Bermuda',
            'BT' => 'Bhutan',
            'BO' => 'Bolivia',
            'BA' => 'Bosnia And Herzegowina',
            'BW' => 'Botswana',
            'BV' => 'Bouvet Island',
            'BR' => 'Brazil',
            'IO' => 'British Indian Ocean Territory',
            'BN' => 'Brunei Darussalam',
            'BG' => 'Bulgaria',
            'BF' => 'Burkina Faso',
            'BI' => 'Burundi',
            'KH' => 'Cambodia',
            'CM' => 'Cameroon',
            'CA' => 'Canada',
            'CV' => 'Cape Verde',
            'KY' => 'Cayman Islands',
            'CF' => 'Central African Republic',
            'TD' => 'Chad',
            'CL' => 'Chile',
            'CN' => 'China',
            'CX' => 'Christmas Island',
            'CC' => 'Cocos (Keeling) Islands',
            'CO' => 'Colombia',
            'KM' => 'Comoros',
            'CG' => 'Congo,  Republic Of',
            'CD' => 'Congo,  Democratic Republic Of',
            'CK' => 'Cook Islands',
            'CR' => 'Costa Rica',
            'CI' => 'Cote Divoire',
            'HR' => 'Croatia',
            'CU' => 'Cuba',
            'CY' => 'Cyprus',
            'CZ' => 'Czech Republic',
            'DK' => 'Denmark',
            'DJ' => 'Djibouti',
            'DM' => 'Dominica',
            'DO' => 'Dominican Republic',
            'TL' => 'Timor-Leste',
            'EC' => 'Ecuador',
            'EG' => 'Egypt',
            'SV' => 'El Salvador',
            'GQ' => 'Equatorial Guinea',
            'ER' => 'Eritrea',
            'EE' => 'Estonia',
            'ET' => 'Ethiopia',
            'FK' => 'Falkland Islands',
            'FO' => 'Faroe Islands',
            'FJ' => 'Fiji',
            'FI' => 'Finland',
            'FR' => 'France',
            'FX' => '',
            'GF' => 'French Guiana',
            'PF' => 'French Polynesia',
            'TF' => 'French Southern Territories',
            'GA' => 'Gabon',
            'GM' => 'Gambia',
            'GE' => 'Georgia',
            'DE' => 'Germany',
            'GH' => 'Ghana',
            'GI' => 'Gibraltar',
            'GR' => 'Greece',
            'GL' => 'Greenland',
            'GD' => 'Grenada',
            'GP' => 'Guadeloupe',
            'GU' => 'Guam',
            'GT' => 'Guatemala',
            'GN' => 'Guinea',
            'GW' => 'Guinea-Bissau',
            'GY' => 'Guyana',
            'HT' => 'Haiti',
            'HM' => 'Heard And Mc Donald Islands',
            'VA' => 'Vatican City',
            'HN' => 'Honduras',
            'HK' => 'Hong Kong',
            'HU' => 'Hungary',
            'IS' => 'Iceland',
            'IN' => 'India',
            'ID' => 'Indonesia',
            'IR' => 'Iran',
            'IQ' => 'Iraq',
            'IE' => 'Ireland',
            'IL' => 'Israel',
            'IT' => 'Italy',
            'JM' => 'Jamaica',
            'JP' => 'Japan',
            'JO' => 'Jordan',
            'KZ' => 'Kazakhstan',
            'KE' => 'Kenya',
            'KI' => 'Kiribati',
            'KP' => 'North Korea',
            'KR' => 'South Korea',
            'KW' => 'Kuwait',
            'KG' => 'Kyrgyzstan',
            'LA' => 'Lao',
            'LV' => 'Latvia',
            'LB' => 'Lebanon',
            'LS' => 'Lesotho',
            'LR' => 'Liberia',
            'LY' => 'Libya',
            'LI' => 'Liechtenstein',
            'LT' => 'Lithuania',
            'LU' => 'Luxembourg',
            'MO' => 'Macau',
            'MK' => 'Macedonia',
            'MG' => 'Madagascar',
            'MW' => 'Malawi',
            'MY' => 'Malaysia',
            'MV' => 'Maldives',
            'ML' => 'Mali',
            'MT' => 'Malta',
            'MH' => 'Marshall Islands',
            'MQ' => 'Martinique',
            'MR' => 'Mauritania',
            'MU' => 'Mauritius',
            'YT' => 'Mayotte',
            'MX' => 'Mexico',
            'FM' => 'Micronesia',
            'MD' => 'Moldova',
            'MC' => 'Monaco',
            'MN' => 'Mongolia',
            'ME' => 'Montenegro',
            'MS' => 'Montserrat',
            'MA' => 'Morocco',
            'MZ' => 'Mozambique',
            'MM' => 'Myanmar',
            'NA' => 'Namibia',
            'NR' => 'Nauru',
            'NP' => 'Nepal',
            'NL' => 'Netherlands',
            'AN' => 'Netherlands Antilles',
            'NC' => 'New Caledonia',
            'NZ' => 'New Zealand',
            'NI' => 'Nicaragua',
            'NE' => 'Niger',
            'NG' => 'Nigeria',
            'NU' => 'Niue',
            'NF' => 'Norfolk Island',
            'MP' => 'Northern Mariana Islands',
            'NO' => 'Norway',
            'OM' => 'Oman',
            'PK' => 'Pakistan',
            'PW' => 'Palau',
            'PA' => 'Panama',
            'PG' => 'Papua New Guinea',
            'PY' => 'Paraguay',
            'PE' => 'Peru',
            'PH' => 'Philippines',
            'PN' => 'Pitcairn',
            'PL' => 'Poland',
            'PT' => 'Portugal',
            'PR' => 'Puerto Rico',
            'QA' => 'Qatar',
            'RE' => 'Reunion',
            'RO' => 'Romania',
            'RU' => 'Russia',
            'RW' => 'Rwanda',
            'KN' => 'Saint Kitts And Nevis',
            'LC' => 'Saint Lucia',
            'VC' => 'Saint Vincent And The Grenadines',
            'WS' => 'Samoa',
            'SM' => 'San Marino',
            'ST' => 'Sao Tome And Principe',
            'SA' => 'Saudi Arabia',
            'SN' => 'Senegal',
            'SR' => 'Serbia',
            'SC' => 'Seychelles',
            'SL' => 'Sierra Leone',
            'SG' => 'Singapore',
            'SK' => 'Slovakia',
            'SI' => 'Slovenia',
            'SB' => 'Solomon Islands',
            'SO' => 'Somalia',
            'ZA' => 'South Africa',
            'GS' => 'South Georgia',
            'ES' => 'Spain',
            'LK' => 'Sri Lanka',
            'SH' => 'Saint Helena',
            'PM' => 'Saint Pierre And Miquelon',
            'SD' => 'Sudan',
            'SR' => 'Suriname',
            'SJ' => 'Svalbard And Jan Mayen Islands',
            'SZ' => 'Swaziland',
            'SE' => 'Sweden',
            'CH' => 'Switzerland',
            'SY' => 'Syria',
            'TW' => 'Taiwan',
            'TJ' => 'Tajikistan',
            'TZ' => 'Tanzania',
            'TH' => 'Thailand',
            'TG' => 'Togo',
            'TK' => 'Tokelau',
            'TO' => 'Tonga',
            'TT' => 'Trinidad And Tobago',
            'TN' => 'Tunisia',
            'TR' => 'Turkey',
            'TM' => 'Turkmenistan',
            'TC' => 'Turks And Caicos Islands',
            'TV' => 'Tuvalu',
            'UG' => 'Uganda',
            'UA' => 'Ukraine',
            'AE' => 'United Arab Emirates',
            'GB' => 'United Kingdom',
            'US' => 'United States',
            'UM' => 'United States Minor Outlying Islands',
            'UY' => 'Uruguay',
            'UZ' => 'Uzbekistan',
            'VU' => 'Vanuatu',
            'VE' => 'Venezuela',
            'VN' => 'Vietnam',
            'VG' => 'British Virgin Islands',
            'VI' => 'United States Virgin Islands',
            'WF' => 'Wallis And Futuna Islands',
            'EH' => 'Western Sahara',
            'YE' => 'Yemen',
            'YU' => 'Yugoslavia',
            'ZM' => 'Zambia',
            'ZW' => 'Zimbabwe '
        );

        if ( isset( $country_conversion_array[ $country_code ] ) ) {

            $insightly_country = $country_conversion_array[ $country_code ];
        } else {

            $insightly_country = $country_code;
        }

        return $insightly_country;
    }

    /*
      Gets and Sets
      -------------------- */
    function get_raw_request_array() {

        if ( empty( $this->raw_request_array ) ) {
            return false;
        } else {
            return $this->raw_request_array;
        }
    }

}

// end class InsightlyRawRequest_v2_9