<?php

if (!defined('ABSPATH'))
    exit;

/**
 * Retrieve db options as global variables to minimize db calls
 * 
 * @global type $nfinsightlycrm_settings
 * @global type $nfinsightlycrm_comm_data
 * @global type $nfinsightlycrm_crm_account_data
 */
function nfinsightly_load_globals() {

    global $nfinsightlycrm_settings;
    global $nfinsightlycrm_comm_data;
    global $nfinsightlycrm_crm_account_data;

    /*
     * the most recent communication messages in a separate variable array 
     * so it doesn't get overwritten when updating the options
     */
    $nfinsightlycrm_comm_data = get_option('nfinsightlycrm_comm_data');


    /*
     * stored crm account data, example : current list of custom fields
     */
    $nfinsightlycrm_crm_account_data = get_option('nfinsightlycrm_crm_account_data');
    /*
     * The site-wide settings
     * 
     * If a Post-NF3 mode isn't defined, grab the array of options stored
     * in the wp-options database 
     */
    if (!defined('NFINSIGHTLYCRM_MODE')) {

        $nfinsightlycrm_settings = get_option('nfinsightlycrm_settings');
    } else {
        /*
         * In a NF 3.0 setup, the settings are all stored in option ninja_forms_settings
         */

        $nf_settings_array = get_option(' ninja_forms_settings');



        if (isset($nf_settings_array['nfinsightlycrm_apikey'])) {
            // use the NF3 version if already set
            $nfinsightlycrm_settings['nfinsightlycrm_apikey'] = $nf_settings_array['nfinsightlycrm_apikey'];
        } else {
            // If NF3 key isn't set, grab the NF2.9 version
            $nfinsightlycrm_settings = get_option('nfinsightlycrm_settings');
        }
    }
}

/**
 * Returns an array of the communication data
 * 
 *     $comm_data = array(
 *          'nfinsightlycrm_comm_status' =>
 *          'nfinsightlycrm_most_recent_raw_request' =>
 *          'nfinsightlycrm_most_recent_raw_response' =>
 *          'nfinsightlycrm_api_connection_verification' =>
 *      )
 * 
 * @global type $nfinsightlycrm_comm_data
 * @return array
 */
function nfinsightlycrm_extract_comm_data() {

    global $nfinsightlycrm_comm_data;

    $comm_data = array(
        'nfinsightlycrm_comm_status' => __('No Communication Status Available', 'ninja-forms-insightly-crm'),
        'nfinsightlycrm_most_recent_raw_request' => __('No Raw Request Available', 'ninja-forms-insightly-crm'),
        'nfinsightlycrm_most_recent_raw_response' => __('No Response Available', 'ninja-forms-insightly-crm'),
        'nfinsightlycrm_api_connection_verification' => __('No Connection to Insightly Detected', 'ninja-forms-insightly-crm'),
    );

    if (isset($nfinsightlycrm_comm_data['nfinsightlycrm_comm_status'])) {
        $comm_data['nfinsightlycrm_comm_status'] = $nfinsightlycrm_comm_data['nfinsightlycrm_comm_status'];
    }

    if (isset($nfinsightlycrm_comm_data['nfinsightlycrm_most_recent_raw_request'])) {

        $comm_data['nfinsightlycrm_most_recent_raw_request'] = maybe_serialize($nfinsightlycrm_comm_data['nfinsightlycrm_most_recent_raw_request']);
    }

    if (isset($nfinsightlycrm_comm_data['nfinsightlycrm_most_recent_raw_response'])) {

        $comm_data['nfinsightlycrm_most_recent_raw_response'] = maybe_serialize($nfinsightlycrm_comm_data['nfinsightlycrm_most_recent_raw_response']);
    }

    if (isset($nfinsightlycrm_comm_data['nfinsightlycrm_api_connection_verification'])) {

        $comm_data['nfinsightlycrm_api_connection_verification'] = maybe_serialize($nfinsightlycrm_comm_data['nfinsightlycrm_api_connection_verification']);
    }
    return $comm_data;
}

/**
 * Retrieve the custom field list by communicating with Insightly
 * Returns serialized only if custom fields available
 * @global array $nfinsightlycrm_settings
 * @return string
 */
function nfinsightlycrm_get_custom_field_list() {

    global $nfinsightlycrm_settings;
    global $nfinsightlycrm_crm_account_data;
    global $nfinsightlycrm_comm_data;
    // initialize
    $custom_field_list = __('No Custom Fields Available', 'ninja-forms-insightly-crm');

    if (!defined('NFINSIGHTLYCRM_MODE')) { // pre3
        if (isset($nfinsightlycrm_settings['nfinsightlycrm_apikey'])) {

            $apikey = $nfinsightlycrm_settings['nfinsightlycrm_apikey'];

            $ico = new InsightlyCommunication_v2_9;

            $ico->set_apikey($apikey);

            $custom_field_list = $ico->get_resource('CustomFields');
        }
    } else { // post3
        
    }

    update_option('nfinsightlycrm_comm_data', $nfinsightlycrm_comm_data);
    update_option('nfinsightlycrm_crm_account_data', $nfinsightlycrm_crm_account_data);
    return $custom_field_list;
}

/**
 * Returns a comma separated list of the custom fields
 * 
 * @return string
 */
function nfinsightlycrm_userfriendly_custom_field_list() {

    $custom_field_list = nfinsightlycrm_get_custom_field_list();

    $unserialized_list = maybe_unserialize($custom_field_list);

    if (is_array($unserialized_list)) {
        // list is not a comm status string, it is a custom field array
        // retrieve array of values and implode

        $unserialized_list = array_values($unserialized_list);
        $unserialized_list = implode(', ', $unserialized_list);
    }
    $userfriendly_custom_field_list = $unserialized_list;

    return $unserialized_list;
}

function nfinsightlycrm_extract_advanced_codes() {

    $settings_key = 'nfinsightlycrm_advanced_codes';

    $advanced_codes_array = array(); //initialize
    $nf_settings_array = get_option(' ninja_forms_settings');

    if (isset($nf_settings_array[$settings_key])) {

        $advanced_codes_setting = $nf_settings_array[$settings_key];

        $advanced_codes_array = array_map('trim', explode(',', $advanced_codes_setting));
    }

    return $advanced_codes_array;
}

/**
 * @since 3.2.0
 * Remove listener from 2.9 version of files
 */
//add_action('init', 'nfinsightlycrm_listener');

/**
 * Listens for GET requests with specific commands
 * 
 * Calls specific functions based on the request made; uses 
 * a switch/case so that only vetted functions are called instead of allowing
 * for unvetted function calls
 */
function nfinsightlycrm_listener() {


    if (isset($_GET['nfinsightlycrm_instructions'])) {

        $trigger = $_GET['nfinsightlycrm_instructions'];
    } else {
        return;
    }



    switch ($trigger) {

        case 'test-connection':
            nfinsightlycrm_connection_test();
            break;

        default:
            break;
    }
}

/**
 * Tests the API connection by trying to create a simple contact
 * 
 * @global array $nfinsightlycrm_settings
 * @global array $nfinsightlycrm_comm_data
 */
function nfinsightlycrm_connection_test() {

    global $nfinsightlycrm_settings;
    global $nfinsightlycrm_comm_data;

    $sample_request = NF_InsightlyCRM::config('ConnectionTester');

    $apikey = $nfinsightlycrm_settings['nfinsightlycrm_apikey'];

    $ico = new InsightlyCommunication_v2_9();

    $ico->set_apikey($apikey);

    $ico->process_form_request($sample_request);

    $status_update = $ico->get_status_update();
    $raw_response = $ico->get_raw_response();
    $finalized_request = $ico->get_raw_request_array(); // the request array after additions made during communication

    $request_arrays = array(
        'before' => $sample_request,
        'finalized' => $finalized_request
    );

    $nfinsightlycrm_comm_data['nfinsightlycrm_comm_status'] = $status_update;
    $nfinsightlycrm_comm_data['nfinsightlycrm_most_recent_raw_request'] = serialize($request_arrays);
    $nfinsightlycrm_comm_data['nfinsightlycrm_most_recent_raw_response'] = serialize($raw_response);

    update_option('nfinsightlycrm_comm_data', $nfinsightlycrm_comm_data);
    
    $redirect = admin_url().'admin.php?page=nf-settings#insightly-settings';

    wp_redirect($redirect);
    exit;
}
