/**
 * Updates action merge tags when keys are updated
 *
 * @package Ninja Forms builder
 * @subpackage Advanced
 * @copyright (c) 2017 WP Ninjas
 * @since 3.2.0
 */
var nfInsightlyMetadataController = Marionette.Object.extend({
    initialize: function () {

        var nfRadio = Backbone.Radio;

        this.listenTo(nfRadio.channel('app'), 'replace:fieldKey', this.replaceFieldKey);
    },

    /**
     * Listen for field key changes and update our
     * option repeater values as necessary.
     * 
     * @param backbone.model  dataModel     the action model making the call
     * @param backbone.model  keyModel      the field model that was updated
     * @param backbone.model  settingModel  the setting model being passed
     * @return void
     */
    replaceFieldKey: function (dataModel, keyModel, settingModel) {

        var nfRadio = Backbone.Radio;

        // check for the action type
        if ('addtoinsightly' !== dataModel.get('type'))
            return false;

        var oldKey = nfRadio.channel('app').request('get:fieldKeyFormat', keyModel._previousAttributes[ 'key' ]);
        var newKey = nfRadio.channel('app').request('get:fieldKeyFormat', keyModel.get('key'));

        // If the insightly_field_map setting has something in it...
        if ('undefined' != typeof dataModel.get('insightly_field_map')) {

            var metaModel = dataModel.get('insightly_field_map');

            if (Array.isArray(metaModel)) {

                metaModel.forEach(function (model) {

                    if ('undefined' !== typeof model.form_field) {

                        var tempFormField = model.form_field;

                        model.form_field = tempFormField.replace(oldKey, newKey);
                    }
                });
            } // Otherwise we don't know what it is, so end gracefully

            dataModel.set('insightly_field_map', metaModel);
        }
    }
});

jQuery(document).ready(function ($) {

    new nfInsightlyMetadataController();
});