<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_ActionNewsletter' )) exit;
require NF_CleverReach::$dir . '/vendor/cleverreach_rest_client.php';
/**
 * Class NF_Action_CleverReachExample
 */
final class NF_CleverReach_Actions_CleverReachSubscribe extends NF_Abstracts_ActionNewsletter
{
    protected $_name  = 'cleverreach';
    
    protected  $_tags = array('newsletter','campaign','cleverreach');

    /**
     * Constructor
     */
    public function __construct()
    {
        NF_Abstracts_Action::__construct();
        $this->_nicename = __( 'CleverReach', 'nf_cleverreach' );
        $this->_transient_expiration = DAY_IN_SECONDS;

        $settings = NF_CleverReach()->config( 'ActionCleverReachSettings' );

        add_action( 'wp_ajax_nf_' . $this->_name . '_get_lists', array( $this, '_get_lists' ) );

        $this->get_list_settings();
        $this->_settings =  array_merge( $this->_settings, $settings );

        //echo '<pre>'.print_r($this->_settings,true).'</pre>';
    }



    /*
    * PUBLIC METHODS
    */

    public function save( $action_settings )
    {

    }




    public function process( $action_settings, $form_id, $data )
    {
        if( ! $this->is_opt_in( $data ) ) return $data;
        
        // echo '<pre>';
        // print_r( $action_settings );
        // echo '########################';
        // print_r( $data );
        // echo '</pre>';

        $cr_form = explode('-', $action_settings['newsletter_list']);
        $double_opt_in = $action_settings[ 'double_opt_in' ];

        $list_id = $cr_form[0];
        $form_id = $cr_form[1];
        $email = $action_settings[NF_CleverReach::PREFIX.'_email'];
        $user_data = array();

        $lists = get_transient( $this->_transient );

        if( ! isset($lists) || empty( $lists ) ) {
            $lists = $this->get_lists();
            if( is_array( $lists ) && count( $lists ) > 0 && !array_key_exists('error', $lists) )
                $this->cache_lists( $lists );
        }

        if( $lists ){

            $selected_list = false;
            foreach ($lists as $list) {
                if( $list['value'] == $action_settings['newsletter_list'] ){
                    $selected_list = $list;
                    break;
                }
            }

            if( $selected_list ){
                foreach ($action_settings as $key => $value) {
                    if( FALSE !== strpos($key, NF_CleverReach::PREFIX.'_') 
                        && $key != NF_CleverReach::PREFIX.'_email' 
                        && !empty($value)){

                        $field_exists = false;
                        foreach ($selected_list['fields'] as $field ) {
                            if( $field['value'] == $key ){
                                $field_exists = true;
                                break;
                            }

                        }

                        if( $field_exists )
                            $user_data[str_replace(NF_CleverReach::PREFIX.'_','',$key)] = $value;
                    }
                }

                // echo '<pre>';
                // print_r( $action_settings );
                // echo '########################';
                // print_r( $user_data );
                // echo '</pre>';
                 
                $this->subscribe_user($list_id,$form_id,$email,$user_data,get_bloginfo('name').': '.$data['settings']['title'],$double_opt_in);
            } // selected_list exists
        } // list exist

        return $data;
    }



    protected function is_opt_in( $data )
    {
        $opt_in = TRUE;
        foreach( $data[ 'fields' ] as $field ){

            if( 'cleverreachoptin' == $field[ 'type' ] && !$field[ 'value' ] ) 
                $opt_in = FALSE;
        }
        return $opt_in;
    }


    /*
     * PROTECTED METHODS
     */

    protected function get_lists()
    {
        $token = Ninja_Forms()->get_setting('nf_cleverreach_token');
        $api_key = Ninja_Forms()->get_setting('nf_cleverreach_api_key');
        if( $token ){ // REST API
            try{
                $rest = new CR\tools\rest( NF_CleverReach::NF_CLEVERREACH_REST_API_URL );
                $rest->setAuthMode("bearer", $token);
                $forms_result = $rest->get("/forms");
                //var_dump($forms_result);
                if( is_array($forms_result) ){
                    $lists = array();

                    foreach($forms_result AS $form){
                        $group = $rest->get("/groups/" . $form->customer_tables_id );
                        $lists[] = array(
                                'value'     =>  $form->customer_tables_id.'-'.$form->id,
                                'label'     =>  $form->name,
                                'groups'    =>  array( ),
                                'fields'    =>  $this->get_list_fields( $form->customer_tables_id )
                            );
                        
                    }
                    //var_dump($lists);
                    return $lists;
                }
            } catch(Exception $e){
                $lists = array( 'error' => array(
                                    'value'     =>  '',
                                    'label'     =>  $e->getMessage(),
                                    'groups'    =>  array( ),
                                    'fields'    =>  array( )
                                ) );
                return $lists;
            }

        }else if( $api_key ){ // old SOAP API
            try{
                $api = new SoapClient(NF_CleverReach::NF_CLEVERREACH_API_URL);
                $result = $api->groupGetList($api_key);
                
                if($result->status=="SUCCESS"){
                    if( is_array($result->data) ){
                        $lists = array();
                        foreach( $result->data AS $cr_list ){
                            $forms_result = $api->formsGetList($api_key,$cr_list->id);

                            foreach($forms_result->data AS $form){

                                $lists[] = array(
                                        'value'     =>  $cr_list->id.'-'.$form->id,
                                        'label'     =>  $cr_list->name.': '.$form->name,
                                        'groups'    => array( ),
                                        'fields'    =>  $this->get_list_fields($cr_list->id)
                                    );
                            };
                        }
                        return $lists;
                    }
                }
            } catch(Exception $e){
            
            }
        }

        return array();
    }

    /*
     * PRIVATE METHODS
     */

    private function get_list_fields($list_id){
        $token = Ninja_Forms()->get_setting('nf_cleverreach_token');
        $api_key = Ninja_Forms()->get_setting('nf_cleverreach_api_key');
        if( $token ){ // REST API
            $rest = new CR\tools\rest( NF_CleverReach::NF_CLEVERREACH_REST_API_URL );
            $rest->setAuthMode("bearer", $token);

            $global_attributes = $rest->get("/attributes");
            $list_attributes = $rest->get("/attributes", array( 'group_id' => $list_id ));

            $fields = array();
            foreach( $global_attributes as $attribute ){
                $fields[] = array(
                        'value' => NF_CleverReach::PREFIX.'_GLOBAL_'.$attribute->name,
                        'label' => $attribute->description
                    );
            }
            foreach( $list_attributes as $attribute ){
                $fields[] = array(
                        'value' => NF_CleverReach::PREFIX.'_LIST_'.$attribute->name,
                        'label' => $attribute->description
                    );
            }
            $fields[] = array(
                    'value' => NF_CleverReach::PREFIX.'_email',
                    'label' => 'Email'
                );
            return $fields;


        }elseif( $api_key ){ // old SOAP API
            try{
                $api = new SoapClient(NF_CleverReach::NF_CLEVERREACH_API_URL);
                $result = $api->groupGetDetails($api_key, $list_id);
                if($result->status=="SUCCESS"){
                    $global_attributes = $result->data->globalAttributes;
                    if( !is_array($global_attributes) )
                        $global_attributes = array();
                    $list_attributes = $result->data->attributes;
                    if( !is_array($list_attributes) )
                        $list_attributes = array();

                    $attributes = array_merge($global_attributes, $list_attributes);

                    $attributes = array_merge($result->data->globalAttributes,$result->data->attributes);

                    $fields = array();
                    foreach( $attributes as $attribute ){
                        $fields[] = array(
                                'value' => NF_CleverReach::PREFIX.'_'.$attribute->key,
                                'label' => ucfirst( str_replace('_',' ',$attribute->key) )
                            );
                    }
                    $fields[] = array(
                            'value' => NF_CleverReach::PREFIX.'_email',
                            'label' => 'Email'
                        );
                    return $fields;
                }
            } catch(Exception $e){
                
            }
        }
        return;
    }





    private function subscribe_user($list_id,$form_id,$email,$user_data,$source,$send_optin_mail){
        if(!$list_id || !$email || !$form_id)
            return;

        $token = Ninja_Forms()->get_setting('nf_cleverreach_token');
        $api_key = Ninja_Forms()->get_setting('nf_cleverreach_api_key');
        if( $token ){ // REST API
            $rest = new CR\tools\rest( NF_CleverReach::NF_CLEVERREACH_REST_API_URL );
            $rest->setAuthMode("bearer", $token);

            //$global_attributes = $rest->get("/attributes");
            $attributes = array();
            $global_attributes = array();

            foreach ($user_data as $key => $value ) {
                if( strpos( $key, 'LIST_' ) !== FALSE ){
                    $key = str_replace( 'LIST_', '', $key );
                    $attributes[$key] = $value;
                }elseif( strpos( $key, 'GLOBAL_' ) !== FALSE ){
                    $key = str_replace( 'GLOBAL_', '', $key );
                    $global_attributes[$key] = $value;
                }
            }
            $user = array(
                "email" => $email,
                "registered" => time(),
                "activated" => ($send_optin_mail ?false:time()),
                "source" => $source,
                "attributes" => $attributes,
                "global_attributes" => $global_attributes,
            );

            
            try{
                $rest->post("/groups/" . $list_id . '/receivers', array( 'postdata' => $user ) );

                $activationdata = array(
                        "user_ip"       => $_SERVER['REMOTE_ADDR'], //the IP of the user who registered. not yours!
                        "user_agent"    => "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:14.0) Gecko/20100101 Firefox/14.0.1",
                        "referer"       => esc_url( home_url( '/' ) ),
                        "postdata"      => $postdata,
                        "info"          => $source,
                    );
                $rest->post("/forms/" . $form_id . '/send/activate', array( 'email' => $email, 'groups_id' => $list_id, 'doidata' => $activationdata ) );

            } catch(Exception $e){
                
            }

        }elseif( $api_key ){ // old SOAP API
            try{
                $api = new SoapClient(NF_CleverReach::NF_CLEVERREACH_API_URL);
                $user = array(
                    "email" => $email,
                    "registered" => time(),
                    "activated" => ($send_optin_mail ?false:time()),
                    "source" => $source,
                    "attributes" => $user_data,
                );
                $result = $api->receiverAdd($api_key, $list_id, $user);
                if($result->status=="SUCCESS"){                 //successfull list call
                    if($send_optin_mail){
                        $postdata='';
                        foreach ($user_data as $attribute) {
                            $postdata = $attribute['key'].':'.$attribute['value'].',';
                        }
                        $activationdata = array(
                                "user_ip"       => $_SERVER['REMOTE_ADDR'], //the IP of the user who registered. not yours!
                                "user_agent"    => "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:14.0) Gecko/20100101 Firefox/14.0.1",
                                "referer"       => esc_url( home_url( '/' ) ),
                                "postdata"      => $postdata,
                                "info"          => $source,
                        );
                        $api->formsSendActivationMail($api_key, $form_id, $email, $activationdata);
                    }
                }elseif($result->message=='duplicate data'){
                    $existing_user = $result->data;
                    $api->receiverSetActive($api_key, $list_id, $email);
                }
            } catch(Exception $e){
                
            }
        }
        return;
    }




    private function get_list_settings()
    {
        $label_defaults = array(
            'list'   => 'List',
            'fields' => 'List Field Mapping',
            'groups' => 'Interest Groups',
        );
        $labels = array_merge( $label_defaults, $this->_setting_labels );

        $prefix = $this->get_name();

        $lists = get_transient( $this->_transient );

        $error_message = __( 'You have either no groups or no associated forms in your CleverReach Account. Please add both and click reload.', 'nf_cleverreach' );

        if( ! isset($lists) || empty( $lists ) ) {
            $lists = $this->get_lists();
            if( is_array( $lists ) && count( $lists ) > 0 && !array_key_exists('error', $lists) )
                $this->cache_lists( $lists );
            elseif( array_key_exists('error', $lists) ){
                $error_message = __( 'CleverReach API Error:', 'nf_cleverreach' ) . ' ' . $lists['error'];
                $lists = array();
            }
        }

        if( count( $lists ) <= 1 ){

            $this->_settings[ $prefix . 'newsletter_list' ] = array(
                'name' => 'newsletter_list',
                'type' => 'select',
                'label' => $labels[ 'list' ] . ' <a class="js-newsletter-list-update extra"><span class="dashicons dashicons-update"></span></a> ' . $error_message,
                'width' => 'full',
                'group' => 'primary',
                'value' => '0',
                'options' => array(),
                'use_merge_tags' => TRUE
            );
        }else{

            $this->_settings[ $prefix . 'newsletter_list' ] = array(
                'name' => 'newsletter_list',
                'type' => 'select',
                'label' => $labels[ 'list' ] . ' <a class="js-newsletter-list-update extra"><span class="dashicons dashicons-update"></span></a>',
                'width' => 'full',
                'group' => 'primary',
                'value' => '0',
                'options' => array(),
                'use_merge_tags' => TRUE
            );

            $fields = array();
            foreach( $lists as $list ){
                $this->_settings[ $prefix . 'newsletter_list' ][ 'options' ][] = $list;
                if( is_array($list[ 'fields' ]) )
                    foreach( $list[ 'fields' ] as $field ){
                        $name = $list[ 'value' ] . '_' . $field[ 'value' ];
                        $fields[] = array(
                            'name' => $name,
                            'type' => 'textbox',
                            'label' => $field[ 'label' ],
                            'width' => 'full',
                            'use_merge_tags' => TRUE
                        );
                    }
            }

            $this->_settings[ $prefix . 'newsletter_list_fields' ] = array(
                'name' => 'newsletter_list_fields',
                'label' => __( 'List Field Mapping', 'ninja-forms' ),
                'type' => 'fieldset',
                'group' => 'primary',
                'settings' => array()
            );

            $this->_settings[ $prefix . 'newsletter_list_groups' ] = array(
                'name' => 'newsletter_list_groups',
                'label' => __( 'Interest Groups', 'ninja-forms' ),
                'type' => 'fieldset',
                'group' => 'primary',
                'settings' => array()
            );
        }
    }




    private function cache_lists( $lists )
    {
        set_transient( $this->_transient, $lists, $this->_transient_expiration );
    }
}