<?php
/*
Plugin Name: Ninja Forms - Cleverreach
Plugin URI: http://etzelstorfer.com/
Description: Connect your Ninja Forms to your Cleverreach newsletter
Version: 1.2
Author: Hannes Etzelstorfer
Author URI: http://etzelstorfer.com
License: GPLv2 or later
*/

/*  Copyright 2015 Hannes Etzelstorfer (email : hannes@etzelstorfer.com) */


define( 'NF_CLEVERREACH_PATH', plugin_dir_path(__FILE__) );
define( 'NF_CLEVERREACH_URL', plugin_dir_url(__FILE__) );
define( 'NF_CLEVERREACH_API_URL', 'http://api.cleverreach.com/soap/interface_v5.1.php?wsdl' );

require NF_CLEVERREACH_PATH . 'includes/class-nf-cleverreach.php';

load_plugin_textdomain('nf_cleverreach', false, dirname( plugin_basename( __FILE__ ) ) . '/translations' );



if (class_exists("nf_cleverreach")) {
	$nf_cleverreach = new NF_Cleverreach();
}

//Actions and Filters	
if (isset($nf_cleverreach)) {
    add_action( 'admin_menu', array(&$nf_cleverreach, 'admin_page'),20);
    add_action( 'admin_init', array(&$nf_cleverreach, 'admin_tab'),20);
    add_action( 'init', array(&$nf_cleverreach, 'form_fields'));
    add_action( 'ninja_forms_display_fields', array(&$nf_cleverreach, 'activate_user'));
    add_action( 'ninja_forms_display_fields', array(&$nf_cleverreach, 'get_user_subscriptions'));
    add_filter( 'ninja_forms_field', array(&$nf_cleverreach, 'populate_subscription_data'),10,2);
}

function nf_cleverreach_optin_mail( $types ) {
  $types['cleverreach_optin'] = require_once( NF_CLEVERREACH_PATH . 'includes/class-opt-in-mail.php' );
  return $types;
}
add_filter( 'nf_notification_types', 'nf_cleverreach_optin_mail' );

function nf_cleverreach_init(){
    if(!isset($nf_cleverreach)) 
        $nf_cleverreach = new nf_cleverreach();
    $nf_cleverreach->init();
}
register_activation_hook( __FILE__, 'nf_cleverreach_init');



function nf_cleverreach_setup_license() {
    if ( class_exists( 'NF_Extension_Updater' ) ) {
        $NF_Extension_Updater = new NF_Extension_Updater( 'CleverReach', '1.1', 'Hannes Etzelstorfer', __FILE__ );
    }
}

add_action( 'admin_init', 'nf_cleverreach_setup_license' );
