<?php

class NF_Cleverreach {
	/**
	 * initialize the plugin on activation
	 *  - set options with default values
	 */
	function init() {
		$this->get_options();
	}

	/**
	 * Register config page
	 *
	 * @return void
	 */
	function admin_page() {
	    add_submenu_page( 'ninja-forms', __('Cleverreach','nf_cleverreach'), __('Cleverreach','nf_cleverreach'), 'manage_options', 'ninja-forms-cleverreach', 'ninja_forms_admin' );
	}

	/**
	 * Register tab for config fields
	 *
	 * @return void
	 */
	function admin_tab(){
	    $args = array(
	        'name' => __('Cleverreach API Settings','nf_cleverreach'),
	        'page' => 'ninja-forms-cleverreach',
	        'save_function' => array(&$this,'save_options'),
	        'show_save' => true,
	    );
	     
	    if( function_exists( 'ninja_forms_register_tab' ) ){
	        ninja_forms_register_tab('cleverreach', $args);
	        $this->register_cleverreach_admin_page_metabox();
	    }
	}

	/**
	 * Add custom form fields
	 *
	 * @return void
	 */
	function form_fields(){
	    $this->register_field_group();
	    $this->register_fields();
	    add_action( 'ninja_forms_post_process', array($this,'process_form'),20 );
	}

	/**
	 * Register metabox for config fields
	 *
	 * @return void
	 */
	function register_cleverreach_admin_page_metabox(){
        $options = $this->get_options();
        $api_key = (isset($_POST['nf_cleverreach_api_key'])?$_POST['nf_cleverreach_api_key']:$options['api_key']);
        $opt_in = (isset($_POST['nf_cleverreach_opt_in'])?$_POST['nf_cleverreach_opt_in']:$options['opt_in']);
        $message='';
        if(isset($api_key)){
        	$test_result=$this->test_api_key($api_key);
        	if(true===$test_result['success']){
        		$message='	<div class="updated">
						        <p>'.$test_result['message'].'</p>
						    </div>';
        	}else{
        		$message='	<div class="error">
						        <p>'.$test_result['message'].'</p>
						    </div>';
        	}
        }
        $args = array(
            'page' => 'ninja-forms-cleverreach',
            'tab' => 'cleverreach',
            'slug' => 'cleverreach-connection',
            'title' => __('Cleverreach API key','nf_cleverreach'),
            'settings' => array(
	            array(
		            'name' => 'nf_cleverreach_api_key',
		            'type' => 'text',
		            'label' => __('Cleverreach API key','nf_cleverreach'),
		            'desc' => __('You can find the API key in your cleverreach account settings','nf_cleverreach'),
		            'default_value' => $api_key,
	            ),
	            array(
	            	'type' => 'select',
	            	'options' =>
	            		array(
	            			array(
	            				'name' => __('Send confirmation mail','nf_cleverreach' ),
	            				'value' => 'mail',
	            			),
	            			array(
	            				'name' => __('Activate user without confirmation mail','nf_cleverreach' ),
	            				'value' => 'auto',
	            			),
	            		),
	            	'name' => 'nf_cleverreach_opt_in',
	            	'label' => __( 'Opt In', 'nf_cleverreach' ),
	            	'default_value' => $opt_in,
	            ),
	            array(
	             	'name' => 'key_valid',
	            	'type' => '',
	            	'label' => $message,
	            	'desc' => '',
	            ),
	            array(
	             	'name' => 'nf_cleverreach_description',
	            	'type' => '',
	            	'label' => '',
	            	'desc' => __('In order to connect fields from your forms to Cleverreach please make sure you use the user data fields <strong>first name, last name, email, ...</strong> instead of ordinary textboxes.<br>If you also want to use a salutation, please use the <strong>salutation</strong> field from the <strong>Cleverreach fields</strong> sidebar.','nf_cleverreach'),
	            ),
            ), 
        );
         
        if( function_exists( 'ninja_forms_register_tab_metabox' ) ) {
            ninja_forms_register_tab_metabox($args);
            $args_refresh_metabox = array(
                'page' => 'ninja-forms-cleverreach',
                'tab' => 'cleverreach',
                'slug' => 'cleverreach-refresh',
                'title' => __('Refresh CleverReach Data','nf_cleverreach'),
                'display_function' => array( $this, 'show_reload_metabox' )
            );
            ninja_forms_register_tab_metabox($args_refresh_metabox);
        }
	}




	public function show_reload_metabox(){
    	?>
		<h3><?php _e('Reload Lists and Forms','nf_cleverreach'); ?></h3>
		<p>
			<?php _e('We automatically update your CleverReach data once a day.<br>If you need your latest changes now click the <strong>Refresh</strong> button.','nf_cleverreach'); ?>
		</p>
		<p>
			<a class="button" href="<?php echo esc_url( add_query_arg( 'nf_cleverreach_refresh', '1' ) ); ?>"><?php _e('Refresh Data','nf_cleverreach'); ?></a>
		</p>
    	<?php
    }



	/**
	 * Get Options
	 *
	 * @return array
	 */
	function get_options() {
		$options = array(
			'api_key' 	=>	'',
			'opt_in'	=>	'mail'
		);
		 
		$nf_cr_options = get_option('nf_cleverreach_options');
		if (!empty($nf_cr_options)) {
			foreach ($nf_cr_options as $key => $option)
				$options[$key] = $option;
		}				
		update_option('nf_cleverreach_options', $options);
		return $options;
	}

	/**
	 * Save options
	 *
	 * @return update message
	 */
	function save_options(){  
		$new_options = array(
			'api_key'	=>	$_POST['nf_cleverreach_api_key'],
			'opt_in'	=>	$_POST['nf_cleverreach_opt_in']
		);
		$saved_options = $this->get_options();
		$options = array_merge($saved_options,$new_options);

		update_option('nf_cleverreach_options', $options);
		$update_msg = __( 'Settings Saved', 'ninja-forms' );
		return $update_msg;
	}

	/**
	 * Test API Key (valid / write-access)
	 *
	 * @return array
	 */
	private function test_api_key($api_key=null){
		if(!$api_key){
			$options = $this->get_options();
			$api_key = $options['api_key'];
		}

		$test_result=array();
		
		try{
			$api = new SoapClient(NF_CLEVERREACH_API_URL);
			$result = $api->groupGetList($api_key);
			if($result->status!="SUCCESS"){
				$test_result['success']=false;
				$test_result['message']=__( 'Your API key is invalid.', 'nf_cleverreach' );
			}else{
				$test_group_name = 'Ninja-Forms-Cleverreach-Write-Access-Test';
				$result = $api->groupAdd($api_key, $test_group_name);
				if($result->status=='ERROR'){
					$test_result['success']=false;
					$test_result['message']=__( 'Your API has read-only permissions, please change to read-write-access.', 'nf_cleverreach' );
				}else{
					$test_result['success']=true;
					$test_result['message']=__( 'We successfully connected to Cleverreach with your API key.', 'nf_cleverreach' );
					$api->groupDelete($api_key, $result->data->id);
				}
			}
		} catch(Exception $e){
			$test_result['success']=false;
			$test_result['message']=__( 'Your API key is invalid.', 'nf_cleverreach' );
		}
		return $test_result;
	}

	/**
	 * Register group for fields
	 *
	 * @return void
	 */
	private function register_field_group()
	{
		if( function_exists( 'ninja_forms_register_sidebar' ) ){
			$tab = 'builder';
			
			if (floatval( substr(NF_PLUGIN_VERSION,0,3) ) < 2.9)
				$tab = 'field_settings';

			$args = array(
				'name' => __( 'Cleverreach Fields', 'nf-nf_cleverreach' ),
				'page' => 'ninja-forms',
				'tab' => $tab,
				'display_function' => 'ninja_forms_sidebar_display_fields'
			);
			ninja_forms_register_sidebar('cleverreach_fields', $args);
		}
	}

	/**
	 * Retreive all lists from cleverreach API
	 *
	 * @return array
	 */
	private function get_cleverreach_forms(){
		$options = $this->get_options();
		$api_key = $options['api_key'];
		if( !$api_key ){
			$return['success']=false;
			$return['message']=__( 'Please enter your API key on the Cleverreach config page.', 'nf_cleverreach' );
			return $return;
		}

		try{
			$api = new SoapClient(NF_CLEVERREACH_API_URL);
			$result = $api->groupGetList($api_key);
			if($result->status=="SUCCESS"){
				if( !is_array($result->data) ){
					$return['success']=false;
					$return['message']=__( 'You don\'t have any Cleverreach forms.', 'nf_cleverreach' );
				}else{
					$return['success']=true;
					$return['forms']=array();
					foreach( $result->data AS $cr_list ){
						$forms_result = $api->formsGetList($api_key,$cr_list->id);
						foreach($forms_result->data AS $form){
							$return['forms'][] = array('name'=>$cr_list->name.': '.$form->name, 'value'=>$cr_list->id.'-'.$form->id);
						};
					}
				}
			}else{
				$return['success']=false;
				$return['message']=$result->message;
			}
		} catch(Exception $e){
			$return['success']=false;
			$return['message']=__( 'Could not connect to the Cleverreach API.', 'nf_cleverreach' );
		}
		return $return;
	}

	

	/**
	 * Register Cleverreach form fields
	 *
	 * @return void
	 */
	function register_fields(){
		if ( function_exists( 'ninja_forms_register_field' ) ){
			if( false === ( $cache_cleverreach_data = get_transient( 'ninja_forms_cleverreach_cache' ) ) 
				|| isset($_GET['nf_cleverreach_refresh'])){
				$forms_result = $this->get_cleverreach_forms();
				if( $forms_result['success'] === true ){
					$forms = $forms_result['forms'];
					set_transient( 
						'ninja_forms_cleverreach_cache',
						$forms, 
						23 * HOUR_IN_SECONDS
					);
				}
			}else{
				$forms = $cache_cleverreach_data;
			}

			if(!isset($forms))
				return;

			//Signup checkbox
			$args_checkbox = array(
				'name' => __( 'Signup checkbox', 'nf_cleverreach' ),
				'edit_options' => 
					array(
						array(
							'type' => 'select',
							'options' =>
								array(
									array(
										'name' => __('checked','nf_cleverreach' ),
										'value' => true,
									),
									array(
										'name' => __('unchecked','nf_cleverreach' ),
										'value' => false,
									),
								),
							'name' => 'cleverreach_behavior',
							'label' => __( 'Default Value', 'ninja-forms' ),
							'class' => 'widefat',
						),
						array(
							'type' => 'select',
							'options' => $forms,
							'name' => 'cleverreach_form',
							'label' => __( 'Cleverreach form', 'nf_cleverreach' ),
							'class' => 'widefat',
						),
					),
					'display_function' => array( $this, 'show_checkbox_field' ),
					'sidebar' => 'cleverreach_fields'
				);
			ninja_forms_register_field('cleverreach_checkbox', $args_checkbox);

			//Auto signup
			$args_auto = array(
				'name' => __( 'Auto signup', 'nf_cleverreach' ),
				'edit_options' => 
					array(
						array(
							'type' => 'select',
							'options' => $forms,
							'name' => 'cleverreach_form',
							'label' => __( 'Cleverreach form', 'nf_cleverreach' ),
							'class' => 'widefat',
						),
					),
					'display_function' => array( $this, 'show_hidden_field' ),
					'display_label' => false,
					'display_wrap' => false,
					'sidebar' => 'cleverreach_fields'
				);
			ninja_forms_register_field('cleverreach_auto', $args_auto);

			//Salutation 
			$args_salutation = array(
				'name'          => __( 'Salutation', 'nf_cleverreach' ),
				'edit_function' => 'ninja_forms_field_list_edit',
				'edit_options'  => array(
					array(
						'type'    => 'select',
						'name'    => 'list_type',
						'label'   => __( 'List Type', 'ninja-forms' ),
						'width'   => 'wide',
						'class'   => 'widefat',
						'options' => array(
							array('name' => __( 'Dropdown', 'ninja-forms' ), 'value' => 'dropdown'),
							array('name' => __( 'Radio', 'ninja-forms' ), 'value' => 'radio'),
						),
					),
				),
				'display_function' => 'ninja_forms_field_list_display',
				'sidebar' => 'cleverreach_fields',
				'edit_conditional' => true,
				'conditional' => array(
					'action' => array(
						'show' => array(
							'name'        => __( 'Show This', 'ninja-forms' ),
							'js_function' => 'show',
							'output'      => 'hide',
						),
						'hide' => array(
							'name'        => __( 'Hide This', 'ninja-forms' ),
							'js_function' => 'hide',
							'output'      => 'hide',
						),
						'change_value' => array(
							'name'        => __( 'Selected Value', 'ninja-forms' ),
							'js_function' => 'change_value',
							'output'      => 'list',
						),
						'add_value' => array(
							'name'        => __( 'Add Value', 'ninja-forms' ),
							'js_function' => 'add_value',
							'output'      => 'ninja_forms_field_list_add_value',
						),
						'remove_value' => array(
							'name'        => __( 'Remove Value', 'ninja-forms' ),
							'js_function' => 'remove_value',
							'output'      => 'list',
						),
					),
					'value' => array(
						'type' => 'list',
					),
				),
				'edit_sub_value' => 'nf_field_list_edit_sub_value',
				'sub_table_value' => 'nf_field_list_sub_table_value',
			);

			ninja_forms_register_field('cleverreach_salutation', $args_salutation);


			//OptIn Url
			$args_optin = array(
					'name' => __( 'OptIn Url', 'nf_cleverreach' ),
					'sidebar' => 'cleverreach_fields',
					'edit_function' => 'ninja_forms_field_hidden_edit',
					'display_function' => 'ninja_forms_field_hidden_display',
					'save_function' => '',
					'edit_label' => true,
					'edit_label_pos' => false,
					'edit_req' => false,
					'edit_custom_class' => false,
					'edit_help' => false,
					'edit_meta' => false,
					'edit_conditional' => false,
					'display_label' => false,
					'sub_edit_function' => 'ninja_forms_field_hidden_edit_sub',
				);
			ninja_forms_register_field('cleverreach_optinurl', $args_optin);

		}
	}



	/**
	 * Show the Cleverreach Field
 	 *
	 * @return 	void
	 */
	function show_checkbox_field( $field_id, $data ){
		if( isset( $data['cleverreach_behavior'] ) ) {
			$cleverreach_behavior = $data['cleverreach_behavior'];

			if($cleverreach_behavior == true ) {
				echo '<input type="checkbox" name="ninja_forms_field_'.$field_id.'" id="ninja_forms_field_'.$field_id.'" class="ninja-forms-field" value="checked" checked>';
			} else {
				echo '<input type="checkbox" name="ninja_forms_field_'.$field_id.'" id="ninja_forms_field_'.$field_id.'" class="ninja-forms-field" value="checked">';
			} 
		}
	}

	/**
	 * Show the Cleverreach Field
 	 *
	 * @return 	void
	 */
	function show_hidden_field( $field_id, $data ){
		echo '<input type="hidden" name="ninja_forms_field_'.$field_id.'" id="ninja_forms_field_'.$field_id.'" class="ninja-forms-field" value="checked" >';
	}	



	function process_form(){
		global $ninja_forms_processing;
		$notifications = nf_get_notifications_by_form_id( $ninja_forms_processing->data['form_ID'], false );
		$optin_notification = '';
		if ( is_array( $notifications ) ) {
			foreach ( $notifications as $id ) {
				do_action( 'nf_notification_before_process', $id );
				if ( Ninja_Forms()->notification( $id )->active && 'cleverreach_optin' == Ninja_Forms()->notification( $id )->type ) {
					$optin_notification = Ninja_Forms()->notification( $id );
				}
			}
		}
		// echo '<pre>';
		// print_r($ninja_forms_processing);
		// echo '</pre>';

		$is_manage_profile_form = false;

		if( strpos($ninja_forms_processing->data['form']['form_url'], 'manage_profile=') && strpos($ninja_forms_processing->data['form']['form_url'], 'email=') )
			$is_manage_profile_form = true;


		if(isset($ninja_forms_processing->data) && isset($ninja_forms_processing->data['field_data']) ){
			$source=$ninja_forms_processing->data['form']['form_title'];
			$user_data=array();
			$subscriptions = array();
			$deactivations = array();
			foreach ($ninja_forms_processing->data['field_data'] as $field) {
				//list id
				if( ( $field['type']=='cleverreach_checkbox' || $field['type']=='cleverreach_auto' ) && isset($field['data']) ){
					if( $ninja_forms_processing->data['fields'][$field['id']]=='checked' ){
						$cr_form = $field['data']['cleverreach_form'];
						$cr_form = explode('-',$cr_form);
						if(is_array($cr_form)){
							$subscriptions[]=array(
									'list_id'	=>	$cr_form[0],
									'form_id'	=>	$cr_form[1]
								);
						}
					}elseif( $is_manage_profile_form ){
						$cr_form = $field['data']['cleverreach_form'];
						$cr_form = explode('-',$cr_form);
						if(is_array($cr_form)){
							$deactivations[] = $cr_form[0];
						}
					}

				}
				//salutation
				elseif( $field['type']=='cleverreach_salutation' ){
					$user_data[]=array(
						'key' => 'salutation', 
						'value' => $ninja_forms_processing->data['fields'][$field['id']]
					);
				}
				//first name
				elseif( $field['type']=='_text' && isset( $field['data']['first_name']) && $field['data']['first_name'] ) {
					$user_data[]=array(
						'key' => 'firstname', 
						'value' => $ninja_forms_processing->data['fields'][$field['id']]
					);
				}
				//last name
				elseif( $field['type']=='_text' && isset( $field['data']['last_name']) && $field['data']['last_name'] ) {
					$user_data[]=array(
						'key' => 'lastname', 
						'value' => $ninja_forms_processing->data['fields'][$field['id']]
					);
				}
				//address
				elseif( $field['type']=='_text' && isset( $field['data']['user_address_1']) && $field['data']['user_address_1'] ) {
					$user_data[]=array(
						'key' => 'street', 
						'value' => $ninja_forms_processing->data['fields'][$field['id']]
					);
				}
				//city
				elseif( $field['type']=='_text' && isset( $field['data']['user_city']) && $field['data']['user_city'] ) {
					$user_data[]=array(
						'key' => 'city', 
						'value' => $ninja_forms_processing->data['fields'][$field['id']]
					);
				}
				//zip
				elseif( $field['type']=='_text' && isset( $field['data']['user_zip']) && $field['data']['user_zip'] ) {
					$user_data[]=array(
						'key' => 'zip', 
						'value' => $ninja_forms_processing->data['fields'][$field['id']]
					);
				}
				//email
				elseif( $field['type']=='_text' && isset( $field['data']['user_email']) && $field['data']['user_email'] ) {
					$email = $ninja_forms_processing->data['fields'][$field['id']];
				}
				//country
				elseif( $field['type']=='_country' ) {
					$user_data[]=array(
						'key' => 'country', 
						'value' => $ninja_forms_processing->data['fields'][$field['id']]
					);
				}
				//optin url
				elseif( $field['type']=='cleverreach_optinurl' ){
					$form_url = $ninja_forms_processing->data['form']['form_url'];
					$form_url = add_query_arg( array('confirm_subscription' => $ninja_forms_processing->get_form_setting( 'sub_id' ) ), $form_url );
					$ninja_forms_processing->update_field_value($field['id'], $form_url );

				}
			}

			if(isset($email) && count($subscriptions)>0 ){
				foreach ($subscriptions as $subscription) {
					$this->subscribe_user($subscription['list_id'],$subscription['form_id'],$email,$user_data,$source,empty($optin_notification),$is_manage_profile_form);	
				}
			}

			if(isset($email) && count($deactivations)>0 ){
				foreach ($deactivations as $deactivation) {
					$this->disable_user($deactivation,$email);	
				}
			}
		}
	}




	/**
	 * Subscribe user
	 *
	 * @return array
	 */
	private function subscribe_user($list_id,$form_id,$email,$user_data,$source,$send_optin_mail,$is_manage_profile_form){
		if( $is_manage_profile_form )
			$send_optin_mail = false;

		$return=array();
		if(!$list_id || !$email || !$form_id){
			$return['success']=false;
			return $return;
		}

		$options = $this->get_options();
		$api_key = $options['api_key'];
		if( !$api_key ){
			$return['success']=false;
			$return['message']=__( 'Please enter your API key on the Cleverreach config page.', 'nf_cleverreach' );
			return $return;
		}

		try{
			$api = new SoapClient(NF_CLEVERREACH_API_URL);
			$user = array(
			    "email" => $email,
			    "registered" => time(),
			    "activated" => ($options['opt_in']=='auto' || $is_manage_profile_form?time():false),
			    "source" => $source,
			    "attributes" => $user_data,
			);
			$result = $api->receiverAdd($api_key, $list_id, $user);
			if($result->status=="SUCCESS"){                 //successfull list call
				if($options['opt_in']=='mail' && $send_optin_mail){
					$postdata='';
					foreach ($user_data as $key => $value) {
						$postdata=$key.':'.$value.',';
					}
				    $activationdata = array(
				            "user_ip"       => $_SERVER['REMOTE_ADDR'], //the IP of the user who registered. not yours!
				            "user_agent"    => "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:14.0) Gecko/20100101 Firefox/14.0.1",
				            "referer"       => esc_url( home_url( '/' ) ),
				            "postdata"      => $postdata,
				            "info"          => $source,
				    );
				    $api->formsSendActivationMail($api_key, $form_id, $email, $activationdata);
				}
			}elseif($result->message=='duplicate data'){
				$existing_user = $result->data;
				$api->receiverSetActive($api_key, $list_id, $email);
			}else{                                         //lists call failed
			    $return['success']=false;
			    $return['message']=$result->message;
			}
		} catch(Exception $e){
			$return['success']=false;
			$return['message']=__( 'Could not connect to the Cleverreach API.', 'nf_cleverreach' );
		}
		return $return;
	}



	/**
	 * disable user
	 *
	 * @return array
	 */
	private function disable_user($list_id,$email){
		$return=array();
		if(!$list_id || !$email ){
			$return['success']=false;
			return $return;
		}

		$options = $this->get_options();
		$api_key = $options['api_key'];
		if( !$api_key ){
			$return['success']=false;
			$return['message']=__( 'Please enter your API key on the Cleverreach config page.', 'nf_cleverreach' );
			return $return;
		}

		try{
			$api = new SoapClient(NF_CLEVERREACH_API_URL);

			$result = $api->receiverSetInactive($api_key, $list_id, $email);
		} catch(Exception $e){
			$return['success']=false;
			$return['message']=__( 'Could not connect to the Cleverreach API.', 'nf_cleverreach' );
		}
		return $return;
	}



	/**
	 * Activate user
	 * This function is called when a user clicks the link in a custom activation email
	 */
	public function activate_user($form_id) {
	    if( isset( $_GET['confirm_subscription'] ) ) {  
	    	$sub_id = $_GET['confirm_subscription'];
	    	$form_fields = ninja_forms_get_fields_by_form_id(  Ninja_Forms()->sub( $sub_id )->form_id );
	    	$sub_fields = Ninja_Forms()->sub( $sub_id )->get_all_fields();


	    	$list_ids = array();
	    	foreach ($form_fields as $field) {
	    		if( $field['type'] == 'cleverreach_auto' || $field['type'] == 'cleverreach_checkbox' ){
	    			if( $sub_fields[$field['id']]=='checked' ){
	    				$cr_form = $field['data']['cleverreach_form'];
	    				$cr_form = explode('-',$cr_form);
	    				if(is_array($cr_form)){
	    					$list_ids[] = $cr_form[0];
	    				}
	    			}
	    		}elseif( $field['type']=='_text' && isset( $field['data']['user_email']) && $field['data']['user_email'] ) {
					$email = $sub_fields[$field['id']];
				}
	    	}


	    	if( isset($email) && is_array($list_ids)){
	    		$options = $this->get_options();
	    		$api_key = $options['api_key'];
	    		$api = new SoapClient(NF_CLEVERREACH_API_URL);
	    		foreach ($list_ids as $list_id) {
	    			$api->receiverSetActive($api_key, $list_id, $email);

	    			$notifications = nf_get_notifications_by_form_id( Ninja_Forms()->sub( $sub_id )->form_id, false );

	    			if ( is_array( $notifications ) ) {
	    				foreach ( $notifications as $id ) {
	    					do_action( 'nf_notification_before_process', $id );
	    					if ( Ninja_Forms()->notification( $id )->active && 'cleverreach_optin' == Ninja_Forms()->notification( $id )->type ) {
	    						$success_redirect = Ninja_Forms()->notification( $id )->get_setting( 'success_redirect' );
	    						if( isset($success_redirect) ){
	    							?>
	    							<script>
	    								window.location.href="<?php echo get_permalink( $success_redirect ); ?>";
	    							</script>
	    							<?php
	    						}
	    					}
	    				}
	    			}
	    		}
	    	}
	    }
	}



	/**
	 * Get user subscriptions
	 * If this form is called with parameters from CleverReach get users subscriptions
	 * ?manage_profile=65&email=me@example.org
	 */
	public function get_user_subscriptions($form_id) {
	    if( isset( $_GET['manage_profile'] ) && isset( $_GET['email'] ) ) {  
	    	global $cr_subscription;
	    	$cr_subscription = array();
	    	$user_id = $_GET['manage_profile'];
	    	$email = $_GET['email'];

	    	$form_fields = ninja_forms_get_fields_by_form_id( $form_id );
	    	$list_ids = array();
	    	foreach ($form_fields as $field) {
	    		if( $field['type'] == 'cleverreach_checkbox' ){
    				$cr_form = $field['data']['cleverreach_form'];
    				$cr_form = explode('-',$cr_form);
    				if(is_array($cr_form)){
    					$list_ids[$field['id']] = $cr_form[0];
    				}
	    		}elseif( $field['type']=='_text' && isset( $field['data']['user_email']) && $field['data']['user_email'] ) {
					$cr_subscription[$field['id']] = $email;
				}
	    	}

    		$options = $this->get_options();
    		$api_key = $options['api_key'];
    		$api = new SoapClient(NF_CLEVERREACH_API_URL);

 
    		foreach ($list_ids as $field_id => $list_id) {
				$user_result = $api->receiverGetById($api_key,$list_id,$user_id,3);
				if( $user_result->data->email == $email ){
					$cr_subscription[$field_id] = $user_result->data->active;
				}
				//TODO: also populate name and address fields
				
				// echo '<pre>';
				// print_r($user_result);
				// echo '</pre>';
    		}
	    }
	}
	




	public function populate_subscription_data($field_data,$field_id){
		global $cr_subscription;
		if(isset($cr_subscription[$field_id])){
			if( array_key_exists( 'cleverreach_behavior', $field_data )  )
				$field_data['cleverreach_behavior'] = $cr_subscription[$field_id];
			else{
				$field_data['default_value'] = $cr_subscription[$field_id];
				$field_data['default_value_type'] = '_custom';
			}

			if( isset( $cr_subscription[$field_id]['user_email'] ) && $cr_subscription[$field_id]['user_email'] )
				$field_data['disable_input'] = true;

			// echo '<pre>';
			// print_r($field_data);
			// echo '</pre>';
		}
		//TODO: also populate name and address fields
		return $field_data;
	}
}
