<?php if ( ! defined( 'ABSPATH' ) ) exit;

/*
 * Plugin Name: Ninja Forms - ConvertKit
 * Description: Email Capture forms for ConvertKit using Ninja Forms.
 * Version: 3.0.1
 * Author: The WP Ninjas
 * Author URI: http://ninjaforms.com
 * Text Domain: ninja-forms-convertkit
 * Domain Path: /lang/
 *
 * Copyright 2017 WP Ninjas.
 */

if ( version_compare( get_option( 'ninja_forms_version', '0.0.0' ), '3', '<' ) || get_option( 'ninja_forms_load_deprecated', FALSE ) ) {

    // This section intentionally left blank

} else {

    require_once plugin_dir_path(__FILE__) . 'includes/autoloader.php';
    require_once plugin_dir_path(__FILE__) . 'includes/convertkit.php';

    // Declare our highlander function.
    if ( ! function_exists( 'NF_ConvertKit' ) ) {
        function NF_ConvertKit()
        {
            static $instance;
            if( ! isset( $instance ) ) {
                $instance = new NF_ConvertKit( '3.0.1', __FILE__ );
            }
            return $instance;
        }
    }
    NF_ConvertKit();
}
