<?php if ( ! defined( 'ABSPATH' ) ) exit;

if( ! function_exists( 'NF_ConvertKit_Autoloader' ) ) {
    function NF_ConvertKit_Autoloader( $class_name )
    {
        $prefix = 'NF_ConvertKit_';
        // If the class isn't prefixed...
        // Exit.
        if ( false === strpos( $class_name, $prefix ) ) return;

        $class_name = str_replace( $prefix, '', $class_name );
        $classes_dir = realpath( plugin_dir_path( __FILE__ ) ) . DIRECTORY_SEPARATOR ;
        $class_file = strtolower( str_replace( '_', DIRECTORY_SEPARATOR, $class_name ) . '.php' );

        // If the class file doesn't exist...
        // Exit.
        if ( ! file_exists( $classes_dir . $class_file ) ) return;
        require_once $classes_dir . $class_file;
    }
}

spl_autoload_register( 'NF_ConvertKit_Autoloader' );