<?php if ( ! defined( 'ABSPATH' ) ) exit;

class NF_ConvertKit_Actions_Subscribe extends NF_Abstracts_Action
{
    /** @var string */
    protected $_name  = 'convertkit';

    /** @var array */
    protected $_tags = array();

    /** @var string */
    protected $_timing = 'normal';

    /** @var int */
    protected $_priority = '10';

    public function __construct()
    {
        parent::__construct();

        // Set the human-readable, translatable name for the action.
        $this->_nicename = __( 'ConvertKit', 'ninja-forms-convertkit' );

        $this->_settings = array_merge( $this->_settings, NF_ConvertKit()->config( 'actions-subscribe' ) );
    }

    public function process( $settings, $form_id, $data )
    {
        $api_key = Ninja_Forms()->get_setting( 'convertkit_api_key' );
        // If we don't have an API key...
        if ( ! $api_key ){
            // Error out.
            $data[ 'errors' ][ 'form' ][] = 'ConvertKit API Key is not set.';
            return $data;
        }
        $convertkit = NF_ConvertKit()->api( $api_key );

        // If we are in debug mode...
        if( $debug = $settings[ 'debug' ] ) {
            $convertkit->set_debugging( true );
            // Setup a slug for reference when debugging.
            $debug_ref = $settings[ 'id' ] . ' ' . sanitize_title( $settings[ 'label' ] );
        }

        // TODO: Validate email address.
        $email = is_email( $settings[ 'email' ] );
        if( ! $email ) {
            $data[ 'actions' ][ 'convertkit' ][] = __( 'Email address is missing or not valid.', 'ninja-forms-convertkit' );
            return $data;
        }

        $args = array(
            'email' => $email
        );

        if( isset( $settings[ 'name' ] ) && '' != $settings[ 'name' ] ){
            $args[ 'name' ]  = $settings[ 'name' ];
        }

        // TODO: Extract functionality for scraping tags/fields settings.
        // Sort out Custom Field and Tag settings.
        foreach( $settings as $key => $value ){

            if( '' == $value ) continue;

            if( 0 === strpos( $key, 'custom_field_' ) ){
                // Use substr, instead of str_replace, to avoid false positives in the key.
                $key = substr( $key, strlen( 'custom_field_' ) );
                $args[ 'fields' ][ $key ] = $value;
            }

            // For toggle setting, 0 is OFF.
            if( 0 == $value ) continue;

            if( 0 === strpos( $key, 'tags_' ) ) {
                // Use substr, instead of str_replace, to avoid false positives in the key.
                $key = substr( $key, strlen( 'tags_' ) );
                $args[ 'tags' ][] = $key;
            }
        }

        /*
         * Add subscriber to a form
         */
        if( isset( $settings[ 'form' ] ) && $settings[ 'form' ] ) {
            $form_id = $settings[ 'form' ];
            $response = $convertkit->post( "forms/$form_id/subscribe", $args );
            /* DEBUG */ if( $debug ) $data[ 'actions' ][ 'convertkit' ][ $debug_ref ][ 'form' ] = compact( 'form_id', 'args', 'response' );
            unset( $args[ 'tags' ] ); // Already sent. Do not re-send.
            unset( $args[ 'custom_fields' ] );  // Already sent. Do not re-send.
        }

        /*
         * Add subscriber to a sequence
         */
        if( isset( $settings[ 'sequence' ] ) && $settings[ 'sequence' ] ) {
            $sequence_id = $settings[ 'sequence' ];
            $response = $convertkit->post( "courses/$sequence_id/subscribe", $args );
            /* DEBUG */ if( $debug ) $data[ 'actions' ][ 'convertkit' ][ $debug_ref ][ 'sequence' ] = compact( 'sequence_id', 'args', 'response' );
            unset( $args[ 'tags' ] ); // Already sent. Do not re-send.
            unset( $args[ 'custom_fields' ] );  // Already sent. Do not re-send.
        }

        /*
         * Tag a subscriber
         */
        if( isset( $args[ 'tags' ] ) && ! empty( $args[ 'tags' ] ) ){
            $tag_id = array_shirt( $args[ 'tags' ] ); // Use the first tag as the request endpoint, pass the rest.
            $response = $convertkit->post( "tags/$tag_id/subscribe", $args );
            /* DEBUG */ if( $debug ) $data[ 'actions' ][ 'convertkit' ][ $debug_ref ][ 'tags' ] = compact( 'args', 'response' );
            unset( $args[ 'custom_fields' ] );  // Already sent. Do not re-send.
        }

        /*
         * Update subscriber
         */
        if( isset( $args[ 'custom_fields' ] ) && ! empty( $args[ 'custom_fields' ] ) ){
            /*
             * If the custom_fields haven't been passed with a form, sequence/course, or tags
             * then we would need to update by ID. However, the `subscribers` expects and ID, which we do not have.
             * TODO: Maybe add support for just updating a subscribers custom fields.
             */
        }

        return $data;
    }

    public function save( $action_settings )
    {
        // This section intentionally left blank.
    }
}