<?php if ( ! defined( 'ABSPATH' ) ) exit;

/*
 * Plugin Name: Ninja Forms - ClickSend
 * Plugin URI: https://ninjaforms.com/extensions/clicksend
 * Description: 
 * Version: 3.0.1
 * Author: 
 * Author URI: 
 * Text Domain: ninja-forms-clicksend
 *
 * Copyright 2016 .
 */

if( version_compare( get_option( 'ninja_forms_version', '0.0.0' ), '3', '<' ) || get_option( 'ninja_forms_load_deprecated', FALSE ) ) {

    // v3.0 Compatibility Only.

} else {

    /**
     * Class NF_ClickSend
     */
    final class NF_ClickSend
    {
        const VERSION = '3.0.1';
        const SLUG    = 'clicksend';
        const NAME    = 'ClickSend';
        const AUTHOR  = '';
        const PREFIX  = 'NF_ClickSend';

        /**
         * @var NF_ClickSend
         * @since 3.0
         */
        private static $instance;

        /**
         * Plugin Directory
         *
         * @since 3.0
         * @var string $dir
         */
        public static $dir = '';

        /**
         * Plugin URL
         *
         * @since 3.0
         * @var string $url
         */
        public static $url = '';

        /**
         * Main Plugin Instance
         *
         * Insures that only one instance of a plugin class exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since 3.0
         * @static
         * @static var array $instance
         * @return NF_ClickSend Highlander Instance
         */
        public static function instance()
        {
            if (!isset(self::$instance) && !(self::$instance instanceof NF_ClickSend)) {
                self::$instance = new NF_ClickSend();

                self::$dir = plugin_dir_path(__FILE__);

                self::$url = plugin_dir_url(__FILE__);

                /*
                 * Register our autoloader
                 */
                spl_autoload_register(array(self::$instance, 'autoloader'));
            }
            
            return self::$instance;
        }

        public function __construct()
        {
            add_action( 'admin_init', array( $this, 'admin_settings' ) );
            add_action( 'admin_init', array( $this, 'setup_license' ) );
            add_filter( 'ninja_forms_register_actions', array($this, 'register_actions'));
            add_action( 'ninja_forms_loaded', array( $this, 'ninja_forms_loaded' ) );
        }

        public function ninja_forms_loaded()
        {
            new NF_ClickSend_Admin_Metaboxes_Submission();
        }

        public function admin_settings()
        {
            new NF_ClickSend_Admin_Settings();
        }

        public function register_actions($actions)
        {
            $actions[ 'clicksend-sms' ] = new NF_ClickSend_Actions_SMS();
            return $actions;
        }

        /*
         * Optional methods for convenience.
         */

        public function autoloader($class_name)
        {
            if (class_exists($class_name)) return;

            if ( false === strpos( $class_name, self::PREFIX ) ) return;

            $class_name = str_replace( self::PREFIX, '', $class_name );
            $classes_dir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR;
            $class_file = str_replace('_', DIRECTORY_SEPARATOR, $class_name) . '.php';

            if (file_exists($classes_dir . $class_file)) {
                require_once $classes_dir . $class_file;
            }
        }
        
        /**
         * Template
         *
         * @param string $file_name
         * @param array $data
         */
        public static function template( $file_name = '', array $data = array() )
        {
            if( ! $file_name ) return;

            extract( $data );

            include self::$dir . 'includes/Templates/' . $file_name;
        }
        
        /**
         * Config
         *
         * @param $file_name
         * @return mixed
         */
        public static function config( $file_name )
        {
            return include self::$dir . 'includes/Config/' . $file_name . '.php';
        }

        /*
         * Required methods for all extension.
         */

        public function setup_license()
        {
            if ( ! class_exists( 'NF_Extension_Updater' ) ) return;

            new NF_Extension_Updater( 'ClickSend SMS', self::VERSION, self::AUTHOR, __FILE__, 'clicksend-sms' );
        }
    }

    /**
     * The main function responsible for returning The Highlander Plugin
     * Instance to functions everywhere.
     *
     * Use this function like you would a global variable, except without needing
     * to declare the global.
     *
     * @since 3.0
     * @return {class} Highlander Instance
     */
    function NF_ClickSend()
    {
        return NF_ClickSend::instance();
    }

    NF_ClickSend();
}
