<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class NF_ClickSend_Admin_Metaboxes_Submission extends NF_Abstracts_SubmissionMetabox
{
    public function __construct()
    {
        parent::__construct();

        $this->_title = __( 'ClickSend SMS', 'ninja-forms-clicksend' );

        if( $this->sub && ! $this->sub->get_extra_value( 'clicksend_status' ) ){
            remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        }
    }

    public function render_metabox( $post, $metabox )
    {
        $extra = array(
            __( 'To', 'ninja-forms-clicksend' )      => $this->sub->get_extra_value( 'clicksend_to' ),
            __( 'From', 'ninja-forms-clicksend' )    => $this->sub->get_extra_value( 'clicksend_from' ),
            __( 'Message', 'ninja-forms-clicksend' ) => $this->sub->get_extra_value( 'clicksend_body' ),
//            __( 'ID', 'ninja-forms-clicksend' )      => $this->sub->get_extra_value( 'clicksend_message_id' ),
            __( 'Status', 'ninja-forms-clicksend' )  => $this->sub->get_extra_value( 'clicksend_status' ),
        );

        echo '<dl>';
        foreach( $extra as $label => $value ) {
            echo '<dt>' . $label . '</dt>';
            echo '<dd>' . $value . '</dd>';
        }
        echo '</dl>';

        echo '<hr />';

        echo '<small>' . $this->sub->get_extra_value( 'clicksend_message_id' ) . '</small>';
    }
}