<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_Action' )) exit;

/**
 * Class NF_ClickSend_Actions_SMS
 */
final class NF_ClickSend_Actions_SMS extends NF_Abstracts_Action
{
    /**
     * @var string
     */
    protected $_name  = 'clicksend-sms';

    /**
     * @var array
     */
    protected $_tags = array( 'sms' );

    /**
     * @var string
     */
    protected $_timing = 'normal';

    /**
     * @var int
     */
    protected $_priority = '10';

    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->_nicename = __( 'ClickSend SMS', 'ninja-forms' );

//        $this->_image = NF_ClickSend::$url . 'assets/img/action-clicksend.png';

        $this->_settings[ 'to' ] = array(
            'name' => 'to',
            'type' => 'textbox',
            'label' => __( 'To', 'ninja-forms'),
            'width' => 'full',
            'group' => 'primary',
            'value' => '',
            'use_merge_tags' => true,
        );

        $this->_settings[ 'body' ] = array(
            'name' => 'body',
            'type' => 'textarea',
            'label' => __( 'Message', 'ninja-forms'),
            'width' => 'full',
            'group' => 'primary',
            'value' => '',
            'use_merge_tags' => true,
        );
    }

    /*
    * PUBLIC METHODS
    */

    public function save( $action_settings )
    {
    
    }

    public function process( $action_settings, $form_id, $data )
    {
        $url = 'https://rest.clicksend.com/v3/sms/send';
        $username = Ninja_Forms()->get_setting( 'clicksend_username' );
        $api_key = Ninja_Forms()->get_setting( 'clicksend_api_key' );

        $args = array(
            'headers' => array(
                'Authorization' => 'Basic ' . base64_encode( $username . ':' . $api_key ),
                'content-type' => 'application/json'
            ),
            'body' => json_encode( array( 'messages' => array(
                array(
                    'to' => $action_settings[ 'to' ],
                    'body' => strip_tags( $action_settings[ 'body' ] ),
                    'source' => 'ninjaforms'
                )
            ) ) )
        );

        $response = wp_remote_post( $url, $args );
        $response_body = json_decode( $response[ 'body' ], ARRAY_A );
        $message = array_shift( $response_body[ 'data' ][ 'messages' ] );

        $data[ 'extra' ][ 'clicksend_to' ]         = $message[ 'to' ];
        $data[ 'extra' ][ 'clicksend_body' ]       = $message[ 'body' ];
        $data[ 'extra' ][ 'clicksend_from' ]       = $message[ 'from' ];
        $data[ 'extra' ][ 'clicksend_status' ]     = $message[ 'status' ];
        $data[ 'extra' ][ 'clicksend_message_id' ] = $message[ 'message_id' ];

        $data[ 'actions' ][ 'clicksend-sms' ][] = array(
            'code' => $response_body[ 'http_code' ],
            'data' => array(
                'to'         => $message[ 'to' ],
                'body'       => $message[ 'body' ],
                'from'       => $message[ 'from' ],
                'status'     => $message[ 'status' ],
                'message_id' => $message[ 'message_id' ],
            ),
            'response' => $response
        );

        return $data;
    }
}
