<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_Helpscout_Admin_Settings
 */
final class NF_Helpscout_Admin_Settings
{
    public function __construct()
    {
        $tls_transient = get_transient( 'nf_helpscout_tls_check' );

        if( 1 == $tls_transient ) return;

        add_filter( 'ninja_forms_plugin_settings', array( $this, 'helpscout_plugin_settings' ), 10, 1 );

        add_filter( 'ninja_forms_plugin_settings_groups', array( $this, 'helpscout_plugin_settings_groups' ), 10, 1 );

        add_filter( 'ninja_forms_check_setting_helpscout_api_key', array($this, 'validate_ninja_forms_helpscout_api'), 10, 1);

    }

    public function helpscout_plugin_settings( $settings )
    {
        $settings[ 'helpscout' ] = NF_Helpscout()->config( 'PluginSettings' );
        return $settings;
    }

    public function helpscout_plugin_settings_groups( $groups )
    {
        $groups = array_merge( $groups, NF_Helpscout()->config( 'PluginSettingsGroups' ) );
        return $groups;
    }

    public function validate_ninja_forms_helpscout_api( $setting )
    {
        if( ! class_exists( 'NF_Helpscout' ) ) return $setting;

        if( NF_Helpscout()->validate_api_key( $setting[ 'value' ] ) ) {
            return $setting;
        }else {
            $setting[ 'errors' ][] = __( 'Your Helpscout API Key is invalid.',
                'ninja-forms-helpscout' );

            $setting[ 'value' ] = '';
            Ninja_Forms()->update_setting( 'helpscout_api_key', '' );
        }
        return $setting;
    }
}