<?php

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit;

// Require admin settings page
require_once( 'classes/admin/helpscout-settings.php' );

/**
 * Loads the Ninja Forms Help Scout Class file
 *
 * @param $types The Notification Types
 *
 * @return mixed
 */
function nf_helpscout_load( $types ) {
        $types[ 'helpscout' ] = require_once( 'classes/action-helpscout.php' );
        return $types;
}
add_filter( 'nf_notification_types', 'nf_helpscout_load' );

/**
 * Ninja Forms License Setup
 */
function nf_helpscout_setup_license() {
        if ( class_exists( 'NF_Extension_Updater' ) ) {
                $NF_Extension_Updater = new NF_Extension_Updater( 'Help Scout', '3.0.0', 'WP Ninjas', __FILE__ );
        }
}

add_action( 'admin_init', 'nf_helpscout_setup_license' );

/**
 * Load Ninja Forms Help Scout Textdomain
 */
function nf_helpscout_load_plugin_textdomain() {
        load_plugin_textdomain( 'ninja-forms-helpscout', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'nf_helpscout_load_plugin_textdomain' );
