<?php if ( ! defined( 'ABSPATH' ) ) exit;



/**
 * Add Helpscout settings page under Forms
 *
 * @since 1.0
 * @return void
 */
function nf_helpscout_submenu() {
        $helpscout_settings = add_submenu_page("ninja-forms", __( 'Helpscout', 'ninja-forms-helpscout' ), __( 'Helpscout', 'ninja-forms-helpscout' ), apply_filters( 'ninja_forms_admin_settings_capabilities', 'manage_options' ), "nf-helpscout-settings", "ninja_forms_admin");

        add_action('admin_print_styles-' . $helpscout_settings, 'ninja_forms_admin_js');
        add_action('admin_print_styles-' . $helpscout_settings, 'ninja_forms_admin_css');

}

add_action( 'admin_menu', 'nf_helpscout_submenu', 30 );

function ninja_forms_register_tab_helpscout_settings(){
        $args = array(
                'name'                                  => __( 'Helpscout Settings', 'ninja-forms-helpscout' ),
                'page'                                  => 'nf-helpscout-settings',
                'display_function'                      => '',
                'save_function'                         => 'nf_helpscout_save_settings',
                'tab_reload'                            => true,
                'show_save'                             => true,
        );
    if( ! function_exists('ninja_forms_register_tab')) return;
    //TODO: LINE 29 AND 61 ARE BOTH CAUSING FATAL ERRORS UPON CONVERSION.
    ninja_forms_register_tab( 'nf_helpscout_settings', $args );
}

add_action( 'admin_init', 'ninja_forms_register_tab_helpscout_settings' );

function ninja_forms_register_helpscout_settings_metabox(){

        $nf_helpscout_apikey = get_option( 'nf_helpscout_apikey' );
        $nf_helpscout_mailbox = get_option( 'nf_helpscout_mailbox' );

        $args = array(
                'page' => 'nf-helpscout-settings',
                'tab' => 'nf_helpscout_settings',
                'slug' => 'nf_helpscout_settings',
                'title' => __( 'Helpscout Settings', 'ninja-forms-helpscout' ),
                'settings' => array(
                        array(
                                'name'          => 'nf_helpscout_apikey',
                                'type'          => 'text',
                                'default_value' => $nf_helpscout_apikey,
                                'label'         => __( 'API Key', 'ninja-forms-helpscout' ),
                                'desc'          => __( 'You can generate this API Key in your Manage/Users section of Help Scout.', 'ninja-forms-helpscout' ),
                        ),
                        array(
                                'name'         => 'nf_helpscout_mailbox',
                                'type'         => 'text',
                                'default_value' => $nf_helpscout_mailbox,
                                'label'        => __( 'Default Mailbox ID', 'ninja-forms-helpscout' ),
                                'desc'         => __( 'A 5 or 6 digit number found at the end of the web address when viewing Manage/Mailbox settings for the mailbox you want to use in Help Scout. This setting can be overwritten on a case-by-case basis in the action settings.', 'ninja-forms-helpscout' ),
                        ),
                ),
        );

    if( ! function_exists('ninja_forms_register_tab')) return;
    //TODO: FIX THIS BEFORE SHIPPING
    ninja_forms_register_tab_metabox( $args );
}

add_action( 'admin_init', 'ninja_forms_register_helpscout_settings_metabox' );

function nf_helpscout_save_settings( $data ) {
        
        foreach( $data as $key => $val ){
                update_option( $key, $val );
        }

        $update_msg = __( 'Settings Saved', 'ninja-forms-helpscout' );
        return $update_msg;
        
}
