<?php if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Class for Help Scout Action in Ninja Forms
 *
 * Extends the NF_Notification_Base_Type class
 *
 * @since 1.0
 */

class NF_Action_HelpScout extends NF_Notification_Base_Type {

        /**
         * Get things rolling
         */
        function __construct() {
                $this->name = __( 'Help Scout', 'ninja-forms-helpscout' );

        }

        /**
         * Output our edit screen
         *
         * @access public
         * @since 1.0
         * @return void
         */
        public function edit_screen( $id = '' ) {

                // Message Settings
                $settings = array(
                        'textarea_name' => 'settings[helpscout]',
                        'tinymce' => true,
                        'quicktags' => true,
                );
                
                // Default the message to include all ninja forms fields
                if ( Ninja_Forms()->notification( $id )->get_setting( 'helpscout' ) == '' ) {
                        $helpscoutmsg = '[ninja_forms_all_fields]';
                } else {
                        $helpscoutmsg = Ninja_Forms()->notification( $id )->get_setting( 'helpscout' );
                }
                ?>
                <tr>
                        <th scope="row"><label for="settings-helpscout-selector"><?php _e( 'Select Email Field', 'ninja-forms-helpscout' ); ?></label></th>
                        <td>
                                <select name="settings[helpscout_selector]" id="settings-helpscout-selector">
                                    <option name="settings[helpscout_selector]" id="settings-helpscout-selector" value=''><?php _e( 'Please select an email field', 'ninja-forms-helpscout' ); ?></option>
                                    <?php
                                        // Pulls all form fields and only keeps the ones marked as Email to create the dropdown
                                        $nf_fields = ninja_forms_get_fields_by_form_id( $_REQUEST['form_id'] );
                                        $helpscout_email_check = 0;
                                        foreach ( $nf_fields as $key => $value ){
                                                if ( isset ( $nf_fields[$key]['data']['email'] ) && $nf_fields[$key]['data']['email'] == 1 ) {
                                                        $helpscout_email_check = 1;
                                                ?>
                                                        <option name="settings[helpscout_selector]" id="settings-helpscout-selector" value="<?php echo $nf_fields[$key]['id']; ?>" <?php selected ( Ninja_Forms()->notification( $id )->get_setting( 'helpscout_selector' ), $nf_fields[$key]['id'] ); ?>><?php echo $nf_fields[$key]['data']['label'] ?> [ID: <?php echo $nf_fields[$key]['id']; ?>]</option>

                                                <?php
                                                }

                                        }
                                        // Adds a field to the select dropdown if there is no email field
                                        if ( $helpscout_email_check == 0 ){
                                        ?>
                                                <option disabled name="settings[helpscout_selector]" id="settings-helpscout-selector" value=''><?php _e( '- Please add an email field to your form', 'ninja-forms-helpscout' ); ?></option>
                                        <?php
                                        }
                                ?>
                                
                                </select>
                                <p class="description"><?php _e( 'An email field is required or the default admin email will be used when generating conversations in Help Scout.', 'ninja-forms-helpscout' ); ?></p>
                        </td>
                </tr>

                <tr>
                        <th scope="row"><label for="settings-helpscout-mailbox"><?php _e( 'Helpscout Mailbox ID', 'ninja-forms-helpscout' ); ?></label></th>
                        <td><input type="mailbox" name="settings[helpscout_mailbox]"  size="60" id="settings-helpscout-mailbox" value="<?php echo Ninja_Forms()->notification( $id )->get_setting( 'helpscout_mailbox' ) ; ?>" placeholder="<?php _e( 'Optional', 'ninja-forms' ); ?>" />
                        <p class="description"><?php _e( 'This can be set to override the default Helpscout Mailbox ID from the settings page.', 'ninja-forms-helpscout' ); ?></p>
                        </td>
                </tr>
                <tr>
                        <th scope="row"><label for="settings-helpscout-message"><?php _e( 'Message', 'ninja-forms-helpscout' ); ?></label></th>
                        <td>
                                <?php wp_editor( $helpscoutmsg, 'helpscout', $settings ); ?>
                        </td>
                </tr>
                <tr>
                        <th scope="row"><label for="settings-helpscout-debug"><?php _e( 'Run in Debug Mode', 'ninja-forms-helpscout' ); ?></label></th>
                        <td>
                                <?php
                                $debug = Ninja_Forms()->notification( $id )->get_setting( 'helpscout_debug' );
                                ?>
                                <input type="hidden" value="0" name="settings[helpscout_debug]">
                                <input type="checkbox" id="settings-helpscout-debug" value="1" name="settings[helpscout_debug]" <?php checked( $debug, 1 ); ?> >
                                <span class="howto"><?php _e( 'This will terminate the page load and show the response received from Help Scout.', 'ninja-forms-helpscout' ); ?></span>
                        </td>
                </tr>
<?php

        }

        /**
         * Process our Help Scout Action, then send to Help Scout
         *
         * @access public
         * @since 1.0
         * @return void
         */
        public function process( $id ) {

                global $ninja_forms_processing;

                $form_id = $ninja_forms_processing->get_form_ID();

                // Get the field ID for the email address to use
                $field_id = preg_replace( '/\D/', '', Ninja_Forms()->notification( $id )->get_setting( 'helpscout_selector' ) );
                
                // Get submitted email address to create the conversation or use admin email
                if ( $field_id != '' ) {
                        $email = $ninja_forms_processing->get_field_value( $field_id );
                } else {
                        $email = get_bloginfo( 'admin_email' );
                }
                
                $helpscout_action = apply_filters( 'nf_filter_helpscout', Ninja_Forms()->notification( $id )->get_setting( 'helpscout' ), $id );

                $success_msg = do_shortcode( $helpscout_action );

                // The Selected Form Title
                $form_title = $ninja_forms_processing->get_form_setting( 'form_title' );

                // Grab the Help Scout settings
                $helpscout_apikey = apply_filters( 'nf_filter_helpscout_apikey', get_option( 'nf_helpscout_apikey' ) );
                $helpscout_mailbox = Ninja_Forms()->notification( $id )->get_setting( 'helpscout_mailbox' );
                $helpscout_mailbox = !empty ( $helpscout_mailbox ) ? $helpscout_mailbox : get_option( 'nf_helpscout_mailbox' );
                $helpscout_debug = Ninja_Forms()->notification( $id )->get_setting( 'helpscout_debug' );

                // Header information
                $header = array(
                        "Authorization" => "Basic ".base64_encode( $helpscout_apikey . ":X" ),
                        "content-type" => "application/json"
                );

                // Body information to send
                $output = array(
                        'type' => 'email',
                        'customer' => (object)array(
                                'email' => $email
                        ),
                        'subject' => 'Submitted by Ninja Forms: '.$form_title,
                        'mailbox' => (object)array(
                                'id' => $helpscout_mailbox
                        ),
                        'threads' => array(
                                (object)array(
                                        'type' => 'customer',
                                        'createdBy' => (object)array(
                                                'email' => $email,
                                                'type' => 'customer'
                                        ),
                                        'body' => strip_tags( preg_replace( '/(<\/[^>]+?>)(<[^>\/][^>]*?>)/', '$1 $2'."\n\n", nf_parse_fields_shortcode( $success_msg ) ) )
                                )
                        )
                );

                // JSON the body to be sent
                $output = json_encode( $output );

                // URL for creating a conversation
                $url = 'https://api.helpscout.net/v1/conversations.json';
                
                // Send post request
                $response = wp_remote_post( $url, array(
                        'headers' => $header,
                        'body' => $output,
                ) );

                // If set to debug then output the response information
                if ( $helpscout_debug == 1 ) {
                        echo "<pre>";
                        echo "<strong>Response:</strong> ";
                        print_r( $response );
                        echo "</pre>";
                        die();
                }
        }
}
return new NF_Action_HelpScout();
