<?php

require_once WP_PLUGIN_DIR . '/nichecreator/includes/libraries/action-scheduler/action-scheduler.php';
require_once plugin_dir_path(__FILE__).'../includes/comprobarcarga.php';

add_action('cargar_imagenescsv','fun_cargar_imagenescsv',10,5);

function carga_tabla_scripts()
{
wp_enqueue_style('wp-jquery-ui-dialog');
wp_register_script( 'carga-tabla', plugins_url('../js/comprobarcarga.js',__FILE__), array('jquery','jquery-ui-dialog','wp-i18n'), '1.1', true );
wp_set_script_translations( 'carga-tabla', 'nichecreator', plugin_dir_path(__FILE__) . 'languages' );
$arr = array( 'ajaxurl' => admin_url('admin-ajax.php'),'nonce' => wp_create_nonce('cargatabla_nonce'));
wp_localize_script('carga-tabla','obj',$arr ); 
wp_enqueue_script( 'carga-tabla');
}


function lanzar_cargar_tabla()
{
	///////////////////////////////////////////////////////////////////////////////////////
	// ASOCIAR CAMPOS DEL FICHERO CSV....
	//////////////////////////////////////////////////////////////////////////////////////
	require_once ABSPATH .'wp-includes/pluggable.php';
	if (isset($_POST['fileToUpload']))
	{
	if (!wp_verify_nonce($_POST['_wpnonce'], 'cargar_csv'.get_the_ID())) 
		{
		add_action('admin_notices','mostrar_error');
		}
	else
	{
	delete_option('nichecreator_numfichas');
	delete_option('nichecreator_ordenacion');
	delete_option('nichecreator_tipoordenacion');
	update_option('nichecreator_auto','manual');
	add_action( 'admin_enqueue_scripts', 'carga_tabla_scripts' );
	add_action( 'wp_loaded', 'schedule_cargar_tabla',99 );
	}
	}
	///////////////////////////////////////////////////////////////////////////////////////
	// FIN ASOCIAR CAMPOS DEL FICHERO CSV....
	//////////////////////////////////////////////////////////////////////////////////////
}
add_action('init','lanzar_cargar_tabla');

function schedule_cargar_tabla() {
	if ( false === as_has_scheduled_action( 'cargar_tabla' ) ) {
		$ejecucion = as_enqueue_async_action('cargar_tabla', array($_POST), '',true);
		//$transient = 'carga_tabla'.get_current_user_id();
		$transient = 'carga_tabla';
		set_transient( $transient, $ejecucion, 60*60*12 );
	}
}


add_action('cargar_tabla', 'fun_cargar_tabla',10,1);

function fun_cargar_tabla($datos)
{
	$csv = $datos['fileToUpload'];
	// Fichero log
	$contadorerr = 0;
	$_POST = $datos;
	$seleccion = [
    			'modo' => "manual"
			];
	$resultado = update_option('nichecreator_datosescrapeo', $seleccion);
	wp_cache_delete('nichecreator_datosescrapeo', 'options'); 
	$escrapeo = 'MANUAL_'.sanitize_text_field($_POST["escrapeo"]);
	$ficherolog = fopen(plugin_dir_path(__FILE__)."../logs/logcarga.log", "w");
	global $wpdb;
	$tabla = $wpdb->prefix.'niche_tabla';
//    $theCSV = str_getcsv(file_get_contents($csv));
	$delimiter = get_delimiter($csv);
	$fichero = fopen($csv, "r");
    $header = fgetcsv($fichero,0,$delimiter);
	$theCSV = [];
	$contador = 1;
	while ( $data = fgetcsv($fichero,0,$delimiter))   
		{
		//$theCSV[$contador] = array_combine($header, $data);
		$data = array_map('trim', $data);
		if (count($header) === count($data)) {
			$theCSV[$contador] = array_combine($header, $data);
			} else {
			fwrite($ficherolog, date("Y-m-d H:i:s") . __(" Línea $contador con columnas desajustadas: encabezado vs datos ",'nichecreator').count($header).' vs '.count($data)."\r\n");
			}
		$contador = $contador + 1;
		}
	fclose($fichero);
	$numentradas = 0;
	$imagenes = false;
	for ($contadorvariables = 1;$contadorvariables<=60;$contadorvariables++)
	{	
	$campo = 'campo'.$contadorvariables;
	$valor = 'valor'.$contadorvariables;
	if ($_POST[$valor] == 'sinrellenar')
		continue;
	$numentradas = $numentradas + 1;
	switch ($_POST[$campo])
		{
		case 'nombre':
		$nombre = $_POST[$valor];
		break;
		case 'valoracion':
		$valoracion = $_POST[$valor];
		break;
		case 'reviews':
		$reviews = $_POST[$valor];
		break;
		case 'direccion':
		$direccion = $_POST[$valor];
		break;
		case 'municipio':
		$municipio = ucwords(strtolower($_POST[$valor]));
		break;
		case 'provincia':
		$provincia = ucwords(strtolower($_POST[$valor]));
		break;
		case 'codigoPostal':
		$cp = $_POST[$valor];
		break;
		case 'pais':
		$pais = $_POST[$valor];
		break;
		case 'website':
		$website = $_POST[$valor];
		break;
		case 'telefono':
		$telefono = $_POST[$valor];
		break;
		case 'horario':
		$horario = $_POST[$valor];
		break;
		case 'latitud':
		$latitud = $_POST[$valor];
		break;
		case 'longitud':
		$longitud = $_POST[$valor];
		break;
		case 'foto':
		$foto = $_POST[$valor];
		$imagenes = true;
		break;
		case 'fotos':
		$fotos = $_POST[$valor];
		break;
		case 'email':
		$email = $_POST[$valor];
		break;
		case 'categoria':
		$categoria = ucwords(strtolower($_POST[$valor]));
		break;
		case 'categoriapadre':
		$categoriapadre = ucwords(strtolower($_POST[$valor]));
		break;
		case 'etiqueta':
		$etiqueta = $_POST[$valor];
		break;
		case 'mapaiframe':
		$iframe = $_POST[$valor];
		break;
		case 'link':
		$link = $_POST[$valor];
		break;
		case 'metatitle':
		$metatitle = $_POST[$valor];
		break;
		case 'metadescription':
		$metadesc = $_POST[$valor];
		break;
		case 'h1':
		$h1 = $_POST[$valor];
		break;
		case 'slug':
		$slug = $_POST[$valor];
		break;
		case 'lunes':
		$lunes = $_POST[$valor];
		break;
		case 'martes':
		$martes = $_POST[$valor];
		break;
		case 'miercoles':
		$miercoles = $_POST[$valor];
		break;
		case 'jueves':
		$jueves = $_POST[$valor];
		break;
		case 'viernes':
		$viernes = $_POST[$valor];
		break;
		case 'sabado':
		$sabado = $_POST[$valor];
		break;
		case 'domingo':
		$domingo = $_POST[$valor];
		break;
		case 'miga':
		$miga = $_POST[$valor];
		break;
		case 'var1':
		$var1 = $_POST[$valor];
		break;
		case 'var2':
		$var2 = $_POST[$valor];
		break;
		case 'var3':
		$var3 = $_POST[$valor];
		break;
		case 'var4':
		$var4 = $_POST[$valor];
		break;
		case 'var5':
		$var5 = $_POST[$valor];
		break;
		case 'var6':
		$var6 = $_POST[$valor];
		break;
		case 'var7':
		$var7 = $_POST[$valor];
		break;
		case 'var8':
		$var8 = $_POST[$valor];
		break;
		case 'var9':
		$var9 = $_POST[$valor];
		break;
		case 'var10':
		$var10 = $_POST[$valor];
		break;
		case 'GoogleMapsID':
		$gmapsid = $_POST[$valor];
		break;
		case 'keyword':
		$keyword = $_POST[$valor];
		break;
		}
	}

	if ($numentradas == 0)
	{
	fwrite($ficherolog, date("d-m-Y H:i:s"). __(' No has introducido ningún campo. ','nichecreator')."\r\n");
	return false;
	}
   	foreach ($theCSV as $fila)
	{
	if (!isset($nombre)) 
 		$filanombre = '';
 	else $filanombre = $fila[$nombre];
	if (!isset($valoracion)) 
 		$filavaloracion = '';
 	else $filavaloracion = $fila[$valoracion];
	if (!isset($reviews)) 
 		$filareviews = 0;
 	else $filareviews = $fila[$reviews];
	if (!is_numeric($filareviews))
		{
		$contadorerr = $contadorerr + 1;
		fwrite($ficherolog, current_datetime()->format('Y-m-d H:i:s'). __(' Error al crear la entrada: ','nichecreator').$fila[$nombre].' El número de reviews debe ser un valor numérico'."\r\n");
		continue;
		}
	if (!isset($direccion)) 
 		$filadireccion = '';
 	else $filadireccion = $fila[$direccion];
 	if (!isset($municipio)) 
 		$filamunicipio = '';
 	else $filamunicipio = $fila[$municipio];
 	if (!isset($provincia)) 
 		$filaprovincia = '';
 	else $filaprovincia = $fila[$provincia];
 	if (!isset($cp)) 
 		$filacp = '';
 	else $filacp = $fila[$cp];
 	if (!isset($pais)) 
 		$filapais = '';
 	else $filapais = $fila[$pais];
	if (!isset($website)) 
 		$filawebsite = '';
 	else $filawebsite = $fila[$website];
	if (!isset($telefono)) 
 		$filatelefono = '';
 	else $filatelefono = $fila[$telefono];
	if (empty($horario)) 
 		$filahorario = '';
 	else $filahorario = $fila[$horario];
	if (!isset($latitud)) 
 		$filalatitud = '';
 	else $filalatitud = $fila[$latitud];
	if (!isset($longitud)) 
 		$filalongitud = '';
 	else $filalongitud = $fila[$longitud];
	if (!isset($foto)) 
 		$filafoto = '';
 	else $filafoto = $fila[$foto];
	if (!isset($fotos)) 
 		$filafotos = 0;
 	else $filafotos = $fila[$fotos];
	if (empty($email)) 
 		$filaemail = '';
 	else $filaemail = $fila[$email];
	if (!isset($categoriapadre)) 
 		$filacategoriapadre = '';
 	else $filacategoriapadre = $fila[$categoriapadre];
	if (!isset($categoria)) 
 		$filacategoria = '';
 	else $filacategoria = $fila[$categoria];
	if (!isset($etiqueta)) 
 		$filaetiqueta = '';
 	else $filaetiqueta = $fila[$etiqueta];
	if (!isset($iframe)) 
 		$filaiframe = '';
 	else $filaiframe = $fila[$iframe];
	if (!isset($link)) 
 		$filalink = '';
 	else $filalink = sanitize_url($fila[$link]);
 	if (!isset($metatitle)) 
 		$filametatitle = '';
 	else $filametatitle = $fila[$metatitle];
 	if (!isset($metadesc)) 
 		$filametadesc = '';
 	else $filametadesc = $fila[$metadesc];
 	if (!isset($h1)) 
 		$filah1 = '';
 	else $filah1 = $fila[$h1];
 	if (!isset($slug)) 
 		$filaslug = '';
 	else $filaslug = $fila[$slug];
	if (!isset($miga)) 
 		$filamiga = '';
 	else $filamiga = $fila[$miga];
 	if (!isset($lunes)) 
 		$filalunes = '';
 	else $filalunes = $fila[$lunes];
 	if (!isset($martes)) 
 		$filamartes = '';
 	else $filamartes = $fila[$martes];
 	if (!isset($miercoles)) 
 		$filamiercoles = '';
 	else $filamiercoles = $fila[$miercoles];
 	if (!isset($jueves)) 
 		$filajueves = '';
 	else $filajueves = $fila[$jueves];
 	if (!isset($viernes)) 
 		$filaviernes = '';
 	else $filaviernes = $fila[$viernes];
 	if (!isset($sabado)) 
 		$filasabado = '';
 	else $filasabado = $fila[$sabado];
 	if (!isset($domingo)) 
 		$filadomingo = '';
 	else $filadomingo = $fila[$domingo];
	if (!isset($var1)) 
 		$filavar1 = '';
 	else $filavar1 = $fila[$var1];
	if (!isset($var2)) 
 		$filavar2 = '';
 	else $filavar2 = $fila[$var2];
 	if (!isset($var3)) 
 		$filavar3 = '';
 	else $filavar3 = $fila[$var3];
	if (!isset($var4)) 
 		$filavar4 = '';
 	else $filavar4 = $fila[$var4];
 	if (!isset($var5)) 
 		$filavar5 = '';
 	else $filavar5 = $fila[$var5];
 	if (!isset($var6)) 
 		$filavar6 = '';
 	else $filavar6 = $fila[$var6];
	if (!isset($var7)) 
 		$filavar7 = '';
 	else $filavar7 = $fila[$var7];
 	if (!isset($var8)) 
 		$filavar8 = '';
 	else $filavar8 = $fila[$var8];
	if (!isset($var9)) 
 		$filavar9 = '';
 	else $filavar9 = $fila[$var9];
 	if (!isset($var10)) 
 		$filavar10 = '';
 	else $filavar10 = $fila[$var10];
 	if (!isset($gmapsid)) 
 		$filagmapsid = '';
 	else $filagmapsid = $fila[$gmapsid];
	if (!isset($keyword)) 
 		$filakeyword = '';
 	else $filakeyword = $fila[$keyword];
        $filalink = esc_url_raw($filalink);
        $filanombre = sanitize_text_field($filanombre);
        $filanombre = limpiar_y_capitalizar($filanombre);
        $filavaloracion = sanitize_text_field($filavaloracion);
        $filareviews = intval($filareviews);
        $filadireccion = sanitize_text_field($filadireccion);
        //$filamunicipio = sanitize_text_field($filamunicipio);
        $filamunicipio = normalizar($filamunicipio);
        $filamunicipio = ucwords($filamunicipio);
        //$filaprovincia = sanitize_text_field($filaprovincia);
        $filaprovincia = normalizar($filaprovincia);
        $filaprovincia = ucwords($filaprovincia);
        $filacp = sanitize_text_field($filacp);
        $filapais = sanitize_text_field($filapais);
        $filawebsite = esc_url_raw($filawebsite);
        $filatelefono = sanitize_text_field($filatelefono);
        $filahorario = sanitize_textarea_field($filahorario);
        $filalatitud = sanitize_text_field($filalatitud);
        $filalongitud = sanitize_text_field($filalongitud);
        $filafoto = esc_url_raw($filafoto);
		/*
		if ($filafoto != '')
		{
		$autor = obtener_id_primer_administrador();
		$imagen = subir_imagen($filafoto,$filanombre,$autor);
		if ($imagen)
			$filafoto = $imagen;
		}
		*/
        $filafotos = sanitize_textarea_field($filafotos);
        $filaemail = sanitize_email($filaemail);
        $filacategoriapadre = sanitize_text_field($filacategoriapadre);
        $filacategoria = sanitize_text_field($filacategoria);
        $filaetiqueta = sanitize_text_field($filaetiqueta);
        $filaiframe = wp_kses_post($filaiframe);
        $filametatitle = sanitize_text_field($filametatitle);
        $filametadesc = sanitize_text_field($filametadesc);
        $filah1 = sanitize_text_field($filah1);
        $filaslug = sanitize_text_field($filaslug);
        $filamiga = sanitize_text_field($filamiga);
        $filalunes = sanitize_text_field($filalunes);
        $filamartes = sanitize_text_field($filamartes);
        $filamiercoles = sanitize_text_field($filamiercoles);
        $filajueves = sanitize_text_field($filajueves);
        $filaviernes = sanitize_text_field($filaviernes);
        $filasabado = sanitize_text_field($filasabado);
        $filadomingo = sanitize_text_field($filadomingo);
        $filagmapsid = sanitize_text_field($filagmapsid);
        $filavar1 = sanitize_text_field($filavar1);
        $filavar2 = sanitize_text_field($filavar2);
        $filavar3 = sanitize_text_field($filavar3);
        $filavar4 = sanitize_text_field($filavar4);
        $filavar5 = sanitize_text_field($filavar5);
        $filavar6 = sanitize_text_field($filavar6);
        $filavar7 = sanitize_text_field($filavar7);
        $filavar8 = sanitize_text_field($filavar8);
        $filavar9 = sanitize_text_field($filavar9);
        $filavar10 = sanitize_text_field($filavar10);
		$filakeyword = sanitize_text_field($filakeyword);
	$resultado = $wpdb->insert($tabla, array(
    'GmapsLink' => $filalink,
    'OrganizationName' => $filanombre,
    'RateStars' => $filavaloracion,
	'ReviewsTotalCount' => $filareviews,
	'OrganizationAddress' => $filadireccion,
	'municipio' => $filamunicipio,
	'provincia' => $filaprovincia,
	'cp' => $filacp,
	'pais'=> $filapais,
	'OrganizationWebsite' => $filawebsite,
	'OrganizationPhoneNr' => $filatelefono,
	'OrganizationWorkTime' => $filahorario,
	'OrganizationLatitude' => $filalatitud,
	'OrganizationLongitude' => $filalongitud,
	'OrganizationHeadPhotoURL' => $filafoto,
	'OrganizationPhotosURLs' => $filafotos,
	'OrganizationEmail' => $filaemail,
	'ShareLink' => $filalink,
	'categoriapadre' => $filacategoriapadre,
	'SearchRequest' => $filacategoria,
	'etiqueta' => $filaetiqueta,
	'EmbedMapCode' => $filaiframe,
	'metatitle' => $filametatitle,
	'metadesc' => $filametadesc,
	'h1' => $filah1,
	'slug' => $filaslug,
	'migapan' => $filamiga,
	'lunes' => $filalunes,
	'martes' => $filamartes,
	'miercoles' => $filamiercoles,
	'jueves' => $filajueves,
	'viernes' => $filaviernes,
	'sabado' => $filasabado,
	'domingo' => $filadomingo,
	'var1' => $filavar1,
	'var2' => $filavar2,
	'var3' => $filavar3,
	'var4' => $filavar4,
	'var5' => $filavar5,
	'var6' => $filavar6,
	'var7' => $filavar7,
	'var8' => $filavar8,
	'var9' => $filavar9,
	'var10' => $filavar10,
	'gmapsid' => $filagmapsid,
	'keyword' => $filakeyword,
	'fecha' => date("Y-m-d"),
	'escrapeo' => $escrapeo,
				));
	if ( $resultado == false)
		{
			$contadorerr = $contadorerr + 1;
			$error = $wpdb->last_error;  
			fwrite($ficherolog, current_datetime()->format('Y-m-d H:i:s'). __(' Error al crear la entrada: ','nichecreator').$filanombre.' '.$error."\r\n");
		}
	} // Fin bucle entradas....
	/// SUBIR IMAGENES ASOCIADAS.................
	if ($imagenes)
	{
	$autor = obtener_id_primer_administrador();
	schedule_cargar_imagenestabla($autor,100,$escrapeo);
	}
	/// SUBIR IMAGENES ASOCIADAS ................
   if ($contadorerr == 0)
			{
			//fwrite($ficherolog, current_datetime()->format('Y-m-d H:i:s'). __(' Archivo cargado correctamente ','nichecreator')."\r\n");
			return true;
			}
	else
			{
			//fwrite($ficherolog, current_datetime()->format('Y-m-d H:i:s'). __(' Se han producido errores, por favor revisa el log. ','nichecreator')."\r\n");
			return false;
			}

fclose($ficherolog);
$final_url = add_query_arg('mensaje','cargaimagenes',add_query_arg('page', $_GET['page'], 'admin.php')	);
		wp_redirect($final_url);
		exit;
}

function obtener_id_primer_administrador() {
    $admins = get_users([
        'role'    => 'administrator',
        'number'  => 1,
        'orderby' => 'ID',
        'order'   => 'ASC',
        'fields'  => ['ID'],
    ]);

    return !empty($admins) ? $admins[0]->ID : null;
}

function schedule_cargar_imagenestabla($autor,$offset,$escrapeo) 
{
	global $wpdb;
	$tabla = $wpdb->prefix.'niche_tabla';
	$contador = intval($wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM {$tabla} WHERE escrapeo = %s", $escrapeo) ));
	for ($i=1;$i<=$contador;$i=$i+$offset)
	{
		$inicio = $i;
		$fin = $inicio + $offset;
		if ($fin > $contador )
			$fin = $contador;
		$ejecucion = as_enqueue_async_action('cargar_imagenescsv', array($contador,$inicio,$offset,$autor,$escrapeo),'',false);
		if ($ejecucion)
			{
			$transient = 'carga_imagenescsv_'.$inicio;
			set_transient( $transient, $ejecucion, 60*60*12 );
			}
	}
}

function fun_cargar_imagenescsv($contador,$inicio,$offset,$autor,$escrapeo)
{
global $wpdb;
$tabla = $wpdb->prefix.'niche_tabla';
$url = site_url();
$parse = parse_url($url);
$mydomain = $parse['host'];
$ini = $inicio - 1;
$fin = $inicio + $offset;
if ($fin > $contador )
	$offset = $contador - $ini;
$offset = intval($offset);
$ini = intval($ini);
usuario_upload_image();
$query = $wpdb->prepare("SELECT * FROM $tabla WHERE escrapeo = %s LIMIT %d OFFSET %d", $escrapeo,$offset, $ini);
$entradas = $wpdb->get_results($query);
foreach ($entradas as $entrada)
	{
	$entrada->OrganizationHeadPhotoURL = sanitize_url($entrada->OrganizationHeadPhotoURL);
	$entrada->OrganizationName = sanitize_text_field($entrada->OrganizationName);
	if ($entrada->OrganizationHeadPhotoURL == '' )
		continue;
	if (is_string($entrada->OrganizationHeadPhotoURL) && trim($entrada->OrganizationHeadPhotoURL) !== '') {
    		$url = parse_url($entrada->OrganizationHeadPhotoURL);
    		$dominio = $url['host'] ?? '';
			}
	if ($entrada->OrganizationHeadPhotoURL != '' && $mydomain != $dominio) // Metemos la foto en el sistema y actualizamos la tabla.
		{
		$fotoid = upload_file_url($entrada->OrganizationHeadPhotoURL,$entrada->OrganizationName,$autor,'noia');
		if ($fotoid > 0) // Hemos subido foto y no hay error o la foto ya estaba...
			{
			update_post_meta( $fotoid, 'nichecreator_imagen', 'X' );
			$fotourl = wp_get_attachment_url($fotoid);
			$entrada->OrganizationHeadPhotoURL = $fotourl;
			// Actualizamos la propia entrada con la URL de la foto en nuestro servidor...
			$id = intval($entrada->id);
			$actualizacion = $wpdb->update($tabla,array("OrganizationHeadPhotoURL"=>$fotourl),array("id"=>$entrada->id));
			}
		/*
		elseif ($fotoid === false)
			{
			$id = intval($entrada->id);
			$actualizacion = $wpdb->update($tabla,array("OrganizationHeadPhotoURL"=>''),array("id"=>$entrada->id));
			}
		*/
		}
	}
}

