jQuery(document).ready(function($) {
    function toggleProvincia() {
        const tipo = $('#tipo').val();
        const pais = $('#pais').val();
        if (tipo === 'mini-geo') {
            $('#provincia-container').show();
            if (!pais) {
                $('#provincia').html('<option value="">Selecciona un país primero</option>');
                return;
            }
	    jQuery.ajax({
                url:obj1.ajaxurl,
                method: 'POST',
                dataType: 'json',
                data: {
					action: 'obtener_provincia',
                    codigo_pais: pais,
					nonce: obj1.nonce
                },
           success: function(response) {
    if (response.success) {
        const options = response.data.options;
        const selectProvincia = $('#provincia');
        selectProvincia.html(options);

        // Marcar la provincia seleccionada:
        if (obj1.provinciaSeleccionada) {
            selectProvincia.val(obj1.provinciaSeleccionada);
        }

        selectProvincia.trigger('change');
    } else {
        console.warn('Error al obtener las provincias', response.data);
    }
},
            error: function(xhr, status, error) {
                     console.log(xhr.responseText);  // Ver la respuesta completa
    		     console.log(error);
                    //logMensaje(`❌ AJAX error: ${error}`, 'error');
                }
            });
        } else {
            $('#provincia-container').hide();
            $('#provincia').html('');
        }
    }
    $('#tipo').on('change', toggleProvincia);
    $('#pais').on('change', function () {
        if ($('#tipo').val() === 'mini-geo') {
            toggleProvincia();
        }
    });

    // Ejecutar al cargar
    toggleProvincia();
});
