<?php

/////////////OBTENER PAIS //////////////////////////////////////////////////////
function render_pais_select_con_datos_db($pais = '') {
    global $wpdb;
    $tabla = $wpdb->prefix . 'countries';
    $paises = $wpdb->get_results("SELECT iso2, emoji, name FROM $tabla WHERE iso2 != '' ORDER BY native ASC");

    ob_start();
    ?>
    <select name="pais" id="pais" class="select2">
        <option value=""><?php _e('Selecciona un país', 'nichecreator'); ?></option>
        <?php foreach ($paises as $pais_obj): ?>
            <?php
                $iso = strtolower(trim($pais_obj->iso2));
                $pais_guardado = strtolower(trim($pais));
            ?>
            <option value="<?php echo esc_attr($pais_obj->iso2); ?>" <?php selected($pais_guardado, $iso); ?>>
                <?php echo esc_html("{$pais_obj->emoji} {$pais_obj->name}"); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <?php
    return ob_get_clean();
}


////////////////////// IDIOMA PRINCIPAL ////////////////////////////////////////////
function convertir_iso_639_3_a_1($codigo3) {
    $map = get_transient('iso639_3_a_1_map');
    if ($map === false) {
        $ruta = plugin_dir_path(__FILE__) . 'iso639_map.php'; // Cambia si el archivo está en otro lugar
        if (!file_exists($ruta)) {
            error_log("Archivo de mapeo ISO no encontrado: " . $ruta);
            return null;
        }
        $map = include $ruta;
        set_transient('iso639_3_a_1_map', $map, WEEK_IN_SECONDS);
    }

    return $map[strtolower($codigo3)] ?? null;
}

function obtener_provincias($codigo_pais) {
    global $wpdb;

    $tabla = $wpdb->prefix . 'states'; // Cambia esto por el nombre real de tu tabla

    $provincias = $wpdb->get_col(
        $wpdb->prepare(
            "SELECT name FROM $tabla WHERE country_code = %s AND type != %s ORDER BY name ASC",
            $codigo_pais,
            'autonomous community'
        )
    );
    return is_array($provincias) ? $provincias : [];
}

/**
 * Devuelve un array con los municipios (ciudades) pertenecientes a una provincia.
 *
 * @param string $provincia Nombre de la provincia/estado.
 * @param string $pais      Código ISO-3166 alfa-2 del país (AR, ES, MX…).
 *
 * @return array Lista de municipios ordenados alfabéticamente.
 */
function obtener_municipios( $provincia, $pais ) {
    global $wpdb;

    // Tablas
    $tabla_estados  = $wpdb->prefix . 'states';  // Debe tener columnas id, name, country_code
    $tabla_ciudades = $wpdb->prefix . 'cities';  // Debe tener columnas name, state_id, country_code

    // Sanitizamos entradas
    $provincia = trim( $provincia );          // Nombre tal cual
    $pais      = strtoupper( trim( $pais ) ); // ISO-2 en mayúsculas

    /*
     * 1. Obtener el ID del estado/provincia por nombre + país.
     *    LIMIT 1 porque debería ser único.
     */
    $state_id = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT id
               FROM $tabla_estados
              WHERE name = %s
                AND country_code = %s
              LIMIT 1",
            $provincia,
            $pais
        )
    );

    // Si no existe, devolvemos array vacío.
    if ( ! $state_id ) {
        return [];
    }

    /*
     * 2. Obtener los municipios que coinciden con ese state_id.
     */
    $municipios = $wpdb->get_col(
        $wpdb->prepare(
            "SELECT name
               FROM $tabla_ciudades
              WHERE state_id    = %d
                AND country_code = %s
              ORDER BY name ASC",
            $state_id,
            $pais
        )
    );

    return is_array( $municipios ) ? $municipios : [];
}



function generar_select_idiomas_por_pais($codigo_pais, $idioma) {
    $codigo_pais = strtoupper(sanitize_text_field($codigo_pais));
    $idioma = strtolower(sanitize_text_field($idioma)); // Aseguramos el formato

    $url = "https://restcountries.com/v3.1/alpha/{$codigo_pais}";
    $response = wp_remote_get($url);

    if (is_wp_error($response)) {
        return '<option value="">No se pudo conectar a la API</option>';
    }

    $data = json_decode(wp_remote_retrieve_body($response), true);
    $languages = (!is_array($data) || empty($data[0]['languages'])) ? [] : $data[0]['languages'];
    $idiomas_renderizados = [];
    ob_start();
    ?>
    <option value="">Selecciona un idioma</option>
    <?php foreach ($languages as $iso3 => $nombre): 
        $iso1 = convertir_iso_639_3_a_1($iso3);
        if (!$iso1) continue;

        $iso1 = strtolower($iso1); // Para comparación con $idioma
        $idiomas_renderizados[] = $iso1;
        $selected = ($iso1 === $idioma) ? 'selected="selected"' : '';
    ?>
        <option value="<?php echo esc_attr($iso1); ?>" <?php echo $selected; ?>>
            <?php echo esc_html($nombre); ?>
        </option>
    <?php endforeach; ?>

    <?php
    // Agregar inglés si no está
    if (!in_array('en', $idiomas_renderizados)) {
        $selected = ($idioma === 'en') ? 'selected="selected"' : '';
        ?>
        <option value="en" <?php echo $selected; ?>>English</option>
        <?php
    }

    // Agregar español si no está
    if (!in_array('es', $idiomas_renderizados)) {
        $selected = ($idioma === 'es') ? 'selected="selected"' : '';
        ?>
        <option value="es" <?php echo $selected; ?>>Spanish</option>
        <?php
    }
    ?>

    <?php
    return ob_get_clean();
}


function generarSelectIdiomas($nombreSelect = 'idioma',$selected = '') {
    $idiomas = [
        'af' => 'Afrikáans',
        'sq' => 'Albanés',
        'am' => 'Amárico',
        'ar' => 'Árabe',
        'hy' => 'Armenio',
        'az' => 'Azerí',
        'eu' => 'Euskera',
        'be' => 'Bielorruso',
        'bn' => 'Bengalí',
        'bs' => 'Bosnio',
        'bg' => 'Búlgaro',
        'ca' => 'Catalán',
        'ceb' => 'Cebuano',
        'zh' => 'Chino',
        'hr' => 'Croata',
        'cs' => 'Checo',
        'da' => 'Danés',
        'nl' => 'Neerlandés',
        'en' => 'Inglés',
        'eo' => 'Esperanto',
        'et' => 'Estonio',
        'fi' => 'Finés',
        'fr' => 'Francés',
        'gl' => 'Gallego',
        'ka' => 'Georgiano',
        'de' => 'Alemán',
        'el' => 'Griego',
        'gu' => 'Gujarati',
        'ht' => 'Criollo haitiano',
        'ha' => 'Hausa',
        'haw' => 'Hawaiano',
        'he' => 'Hebreo',
        'hi' => 'Hindi',
        'hmn' => 'Hmong',
        'hu' => 'Húngaro',
        'is' => 'Islandés',
        'ig' => 'Igbo',
        'id' => 'Indonesio',
        'ga' => 'Irlandés',
        'it' => 'Italiano',
        'ja' => 'Japonés',
        'jw' => 'Javanés',
        'kn' => 'Canarés',
        'kk' => 'Kazajo',
        'km' => 'Jemer',
        'ko' => 'Coreano',
        'ku' => 'Kurdo',
        'ky' => 'Kirguís',
        'lo' => 'Lao',
        'la' => 'Latín',
        'lv' => 'Letón',
        'lt' => 'Lituano',
        'lb' => 'Luxemburgués',
        'mk' => 'Macedonio',
        'mg' => 'Malgache',
        'ms' => 'Malayo',
        'ml' => 'Malayalam',
        'mt' => 'Maltés',
        'mi' => 'Maorí',
        'mr' => 'Maratí',
        'mn' => 'Mongol',
        'my' => 'Birmano',
        'ne' => 'Nepalí',
        'no' => 'Noruego',
        'ny' => 'Chichewa',
        'fa' => 'Persa',
        'pl' => 'Polaco',
        'pt' => 'Portugués',
        'pa' => 'Panyabí',
        'ro' => 'Rumano',
		'rm' => 'Romache',
        'ru' => 'Ruso',
        'sm' => 'Samoano',
        'gd' => 'Gaélico escocés',
        'sr' => 'Serbio',
        'st' => 'Sesotho',
        'sn' => 'Shona',
        'sd' => 'Sindhi',
        'si' => 'Cingalés',
        'sk' => 'Eslovaco',
        'sl' => 'Esloveno',
        'so' => 'Somalí',
        'es' => 'Español',
        'su' => 'Sundanés',
        'sw' => 'Suajili',
        'sv' => 'Sueco',
        'tl' => 'Tagalo',
        'tg' => 'Tayiko',
        'ta' => 'Tamil',
        'te' => 'Telugu',
        'th' => 'Tailandés',
        'tr' => 'Turco',
        'uk' => 'Ucraniano',
        'ur' => 'Urdu',
        'uz' => 'Uzbeko',
        'vi' => 'Vietnamita',
        'cy' => 'Galés',
        'xh' => 'Xhosa',
        'yi' => 'Yidis',
        'yo' => 'Yoruba',
        'zu' => 'Zulú'
    ];

    $html = "<select name=\"$nombreSelect\" id=\"$nombreSelect\">\n";
    foreach ($idiomas as $codigo => $nombre) {
        if ($selected == $codigo)
            $html .= "    <option value=\"$codigo\" selected>$nombre</option>\n";
        else $html .= "    <option value=\"$codigo\">$nombre</option>\n";
    }
    $html .= "</select>";

    return $html;
}

function nombreIdioma($codigo) {
    $idiomas = [
        'af' => 'Afrikáans',
        'sq' => 'Albanés',
        'am' => 'Amárico',
        'ar' => 'Árabe',
        'hy' => 'Armenio',
        'az' => 'Azerí',
        'eu' => 'Euskera',
        'be' => 'Bielorruso',
        'bn' => 'Bengalí',
        'bs' => 'Bosnio',
        'bg' => 'Búlgaro',
        'ca' => 'Catalán',
        'ceb' => 'Cebuano',
        'zh' => 'Chino',
        'hr' => 'Croata',
        'cs' => 'Checo',
        'da' => 'Danés',
        'nl' => 'Neerlandés',
        'en' => 'Inglés',
        'eo' => 'Esperanto',
        'et' => 'Estonio',
        'fi' => 'Finés',
        'fr' => 'Francés',
        'gl' => 'Gallego',
        'ka' => 'Georgiano',
        'de' => 'Alemán',
        'el' => 'Griego',
        'gu' => 'Gujarati',
        'ht' => 'Criollo haitiano',
        'ha' => 'Hausa',
        'haw' => 'Hawaiano',
        'he' => 'Hebreo',
        'hi' => 'Hindi',
        'hmn' => 'Hmong',
        'hu' => 'Húngaro',
        'is' => 'Islandés',
        'ig' => 'Igbo',
        'id' => 'Indonesio',
        'ga' => 'Irlandés',
        'it' => 'Italiano',
        'ja' => 'Japonés',
        'jw' => 'Javanés',
        'kn' => 'Canarés',
        'kk' => 'Kazajo',
        'km' => 'Jemer',
        'ko' => 'Coreano',
        'ku' => 'Kurdo',
        'ky' => 'Kirguís',
        'lo' => 'Lao',
        'la' => 'Latín',
        'lv' => 'Letón',
        'lt' => 'Lituano',
        'lb' => 'Luxemburgués',
        'mk' => 'Macedonio',
        'mg' => 'Malgache',
        'ms' => 'Malayo',
        'ml' => 'Malayalam',
        'mt' => 'Maltés',
        'mi' => 'Maorí',
        'mr' => 'Maratí',
        'mn' => 'Mongol',
        'my' => 'Birmano',
        'ne' => 'Nepalí',
        'no' => 'Noruego',
        'ny' => 'Chichewa',
        'fa' => 'Persa',
        'pl' => 'Polaco',
        'pt' => 'Portugués',
        'pa' => 'Panyabí',
        'ro' => 'Rumano',
        'ru' => 'Ruso',
        'sm' => 'Samoano',
        'gd' => 'Gaélico escocés',
        'sr' => 'Serbio',
        'st' => 'Sesotho',
        'sn' => 'Shona',
        'sd' => 'Sindhi',
        'si' => 'Cingalés',
        'sk' => 'Eslovaco',
        'sl' => 'Esloveno',
        'so' => 'Somalí',
        'es' => 'Español',
        'su' => 'Sundanés',
        'sw' => 'Suajili',
        'sv' => 'Sueco',
        'tl' => 'Tagalo',
        'tg' => 'Tayiko',
        'ta' => 'Tamil',
        'te' => 'Telugu',
        'th' => 'Tailandés',
        'tr' => 'Turco',
        'uk' => 'Ucraniano',
        'ur' => 'Urdu',
        'uz' => 'Uzbeko',
        'vi' => 'Vietnamita',
        'cy' => 'Galés',
        'xh' => 'Xhosa',
        'yi' => 'Yidis',
        'yo' => 'Yoruba',
        'zu' => 'Zulú'
    ];

    $codigo = strtolower(trim($codigo));
    return $idiomas[$codigo] ?? 'Idioma desconocido';
}



