<?php
function nichecreator_verificar_o_crear_tabla() {
    global $wpdb;
    $tablacache = $wpdb->prefix . 'nichecreator_cache';
    $tablacachefichas = $wpdb->prefix . 'nichecreator_cachefichas';
    // Verifica si la tabla ya existe
    $tabla_existe = $wpdb->get_var( $wpdb->prepare(
        "SHOW TABLES LIKE %s", $tablacache
    ));
    
      $tablafichas_existe = $wpdb->get_var( $wpdb->prepare(
        "SHOW TABLES LIKE %s", $tablacachefichas
    ));
    
    if ($tabla_existe !== $tablacache) {
        nichecreator_crear_tabla_cache(); // Solo la crea si no existe
    }
    
     if ($tablafichas_existe !== $tablacachefichas) {
        nichecreator_crear_tabla_cachefichas(); // Solo la crea si no existe
    }
    
}

function nichecreator_crear_tabla_cache() {
    global $wpdb;
    $tablacache = $wpdb->prefix . 'nichecreator_cache';
    $charset_collate = $wpdb->get_charset_collate();

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';

    $sql = "CREATE TABLE $tablacache (
        catpadre VARCHAR(255) NOT NULL DEFAULT '',
        cathija VARCHAR(255) NOT NULL DEFAULT '',
        padre_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
        hija_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
        etiqueta_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
        num_fichas INT NOT NULL DEFAULT 0,
        PRIMARY KEY  (catpadre(100), cathija(100))
    ) $charset_collate;";

    dbDelta($sql);
    if ( ! empty( $wpdb->last_error ) ) {
    error_log( 'Error en creación de tabla cache: ' . $wpdb->last_error );
} 
}

function nichecreator_crear_tabla_cachefichas() {
    global $wpdb;
    $tablacachefichas = $wpdb->prefix . 'nichecreator_cachefichas';
    $charset_collate = $wpdb->get_charset_collate();

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';

    $sql = "CREATE TABLE $tablacachefichas (
        identificador VARCHAR(255) NOT NULL,
        post_id BIGINT NOT NULL,
        PRIMARY KEY (identificador(100))
    ) $charset_collate;";

    dbDelta($sql);
}



//////////////////////////////////////////////////////////////////////////////
/////////////////////PRECARGA EN CACHE TODAS LAS FICHAS ///////////////////
/////////////////////////////////////////////////////////////////////////////

function nichecreator_precargar_cachefichas(): void {
global $wpdb;
$tabla = $wpdb->prefix.'nichecreator_cachefichas';
$rows = $wpdb->get_results("SELECT p.ID, pm.meta_value as identificador FROM {$wpdb->prefix}posts p INNER JOIN {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id WHERE p.post_type = 'page' AND p.post_status != 'trash'
AND pm.meta_key = 'nichecreator_identificador'", ARRAY_A);
// Limpiar tabla antes de insertar
$wpdb->query("TRUNCATE TABLE $tabla");

foreach ($rows as $row) {
    $wpdb->insert($tabla, [
        'identificador' => $row['identificador'],
        'post_id'       => $row['ID'],
    ]);
}
}

//////////////////////////////////////////////////////////////////////////////
/////////////////////PRECARGA EN CACHE DE TODOS LOS DATOS
////////////////////////////////////////////////////////////////

function nichecreator_precargar_cache(): void {
    global $wpdb;
    $tabla = $wpdb->prefix . 'nichecreator_cache';

    // Obtener combinaciones únicas de categorías
    $registros = $wpdb->get_results("
        SELECT DISTINCT SearchRequest, categoriapadre 
        FROM {$wpdb->prefix}niche_tabla");

    // Limpiar tabla antes de recargar
    $wpdb->query("DELETE FROM $tabla");

    // Para evitar insertar duplicados de padres
    $padres_insertados = [];

    foreach ($registros as $registro) {
        //$cathija  = sanitize_text_field($registro->SearchRequest);
        $cathija = normalizar($registro->SearchRequest);
        //$catpadre = sanitize_text_field($registro->categoriapadre);
        $catpadre = normalizar($registro->categoriapadre);

        // Contar fichas asociadas
        $numfichas = (int) $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM {$wpdb->prefix}niche_tabla 
             WHERE SearchRequest = %s AND categoriapadre = %s",
            $cathija, $catpadre
        ));

        $padre_id = 0;
        $hija_id = 0;
        $etiqueta_id = 0;

        // --- INSERTAR FILA ESPECIAL PARA EL PADRE (si tiene nombre) ---
        if (!empty($catpadre) && !isset($padres_insertados[$catpadre])) {
            // Buscar página padre
            $padres = get_posts([
                'post_type'      => 'page',
                'meta_key'       => 'nichecreator_categoria',
                'meta_value'     => $catpadre,
                'post_parent'    => 0,
                'posts_per_page' => 1,
                'post_status'    => 'any',
                'fields'         => 'ids'
            ]);
            if (!empty($padres)) {
                $padre_id = (int) $padres[0];
            }

            // Buscar etiqueta padre
            $tag = term_exists($catpadre, 'post_tag');
            if ($tag) {
                $etiqueta_id = is_array($tag) ? (int) $tag['term_id'] : (int) $tag;
            }

            // Insertar en la tabla con cathija vacío
            $wpdb->replace($tabla, [
                'catpadre'    => $catpadre,
                'cathija'     => '',
                'padre_id'    => $padre_id,
                'hija_id'     => 0,
                'etiqueta_id' => $etiqueta_id,
                'num_fichas'  => 0
            ], ['%s', '%s', '%d', '%d', '%d', '%d']);

            // Marcar como insertado
            //$padres_insertados[$catpadre] = true;
			 $padres_insertados[$catpadre] = [
            'padre_id'    => $padre_id,
            'etiqueta_id' => $etiqueta_id
				];
        }
		else if (!empty($catpadre) && isset($padres_insertados[$catpadre])) 
		{
        $padre_id    = $padres_insertados[$catpadre]['padre_id'] ?? 0;
        $etiqueta_id = $padres_insertados[$catpadre]['etiqueta_id'] ?? 0;
		} 

        // --- PROCESAR COMBINACIÓN NORMAL PADRE-HIJA ---
        // Buscar hija si padre existe
        if (!empty($catpadre)) {
            //$padre_id = $padre_id ?: 0;
            if ($padre_id && !empty($cathija)) {
                $hijas = get_posts([
                    'post_type'      => 'page',
                    'meta_key'       => 'nichecreator_categoria',
                    'meta_value'     => $cathija,
                    'post_parent'    => $padre_id,
                    'posts_per_page' => 1,
                    'post_status'    => 'any',
                    'fields'         => 'ids'
                ]);
                if (!empty($hijas)) {
                    $hija_id = (int) $hijas[0];
                }
            }
        } else {
            // Si no hay padre, buscar hija como página raíz
            $paginas = get_posts([
                'post_type'      => 'page',
                'meta_key'       => 'nichecreator_categoria',
                'meta_value'     => $cathija,
                'post_parent'    => 0,
                'posts_per_page' => 1,
                'post_status'    => 'any',
                'fields'         => 'ids'
            ]);
            if (!empty($paginas)) {
                $hija_id = (int) $paginas[0];
            }
        }

        // Insertar combinación padre-hija normal
        $wpdb->replace($tabla, [
            'catpadre'    => $catpadre,
            'cathija'     => $cathija,
            'padre_id'    => $padre_id,
            'hija_id'     => $hija_id,
            'etiqueta_id' => $etiqueta_id,
            'num_fichas'  => $numfichas
        ], ['%s', '%s', '%d', '%d', '%d', '%d']);
    }
}

/**
 * Carga la caché de identificadores desde la tabla wp_cache_paginas.
 *
 * @return array Array asociativo [identificador => post_id].
 */
 
 ///////////////////////////////////////////////////
///////// CARGAR CACHE EN CADA TAREA  (FICHAS) ////////////
//////////////////////////////////////////////////

function nichecreator_cargar_cachefichas() {
    global $wpdb;
    $tabla = $wpdb->prefix.'nichecreator_cachefichas';
    $resultados = $wpdb->get_results("SELECT identificador, post_id FROM $tabla", ARRAY_A);
    $cache = [];
    foreach ($resultados as $fila) {
        $cache[$fila['identificador']] = (int) $fila['post_id'];
    }
    return $cache;
}


///////////////////////////////////////////////////
///////// CARGAR CACHE EN CADA TAREA ////////////
//////////////////////////////////////////////
function nichecreator_cargar_cache(): array {
    global $wpdb;
    $tabla = $wpdb->prefix . 'nichecreator_cache';

    $cache = [];
    $registros = $wpdb->get_results("SELECT * FROM $tabla", ARRAY_A);

    foreach ($registros as $fila) {
        $catpadre    = $fila['catpadre'];
        $cathija     = $fila['cathija'];
        $key         = $catpadre . '|' . $cathija;

        $cache[$key] = [
            'padre_id'    => (int) $fila['padre_id'],
            'hija_id'     => (int) $fila['hija_id'],
            'etiqueta_id' => (int) $fila['etiqueta_id'],
            'num_fichas'  => (int) $fila['num_fichas'],
        ];
    }

    return $cache;
}


function nichecreator_borrar_cache() {
    global $wpdb;
    $tabla = $wpdb->prefix . 'nichecreator_cache';
    $wpdb->query("TRUNCATE TABLE $tabla");
}

function nichecreator_borrar_cachefichas() {
    global $wpdb;
    $tabla = $wpdb->prefix . 'nichecreator_cachefichas';
    $wpdb->query("TRUNCATE TABLE $tabla");
}

function nichecreator_guardar_cachefichas($cache) {
    global $wpdb;
    $tabla = $wpdb->prefix.'nichecreator_cachefichas';

    // Usar un transient como flag de bloqueo
    if (get_transient('nichecreator_guardando_cachefichas')) {
        return; // Ya se está guardando, salimos
    }

    // Activar flag durante 1 minuto
    set_transient('nichecreator_guardando_cachefichas', true, 60);

    // Eliminar todo el contenido actual
    $wpdb->query("DELETE FROM $tabla");

    // Insertar los datos nuevos
    foreach ($cache as $identificador => $post_id) {
        $wpdb->insert(
            $tabla,
            [
                'identificador' => $identificador,
                'post_id' => (int) $post_id,
            ],
            ['%s', '%d']
        );
    }

    // Eliminar el flag
    delete_transient('nichecreator_guardando_cachefichas');
}



function nichecreator_guardar_cache_completa(array $cache): void {
    global $wpdb;
    $tabla = $wpdb->prefix . 'nichecreator_cache';

    // Candado para evitar concurrencia
    if (get_transient('nichecreator_cache_updating')) {
        return;
    }
    set_transient('nichecreator_cache_updating', true, 60);

    try {
        $wpdb->query('START TRANSACTION');
        // Limpiar toda la tabla antes de recargar
        $wpdb->query("DELETE FROM $tabla");

        foreach ($cache as $clave => $datos) {
            if (!is_array($datos)) {
                continue;
            }

            // Separar clave compuesta
            $partes = explode('|', $clave, 2);
            $catpadre = sanitize_text_field($partes[0] ?? '');
            $cathija  = sanitize_text_field($partes[1] ?? '');

            $padre_id    = intval($datos['padre_id'] ?? 0);
            $hija_id     = intval($datos['hija_id'] ?? 0);
            $etiqueta_id = intval($datos['etiqueta_id'] ?? 0);
            $num_fichas  = intval($datos['num_fichas'] ?? 0);

            $wpdb->insert($tabla, [
                'catpadre'    => $catpadre,
                'cathija'     => $cathija,
                'padre_id'    => $padre_id,
                'hija_id'     => $hija_id,
                'etiqueta_id' => $etiqueta_id,
                'num_fichas'  => $num_fichas,
            ], [
                '%s', '%s', '%d', '%d', '%d', '%d'
            ]);
        }

        $wpdb->query('COMMIT');
    } catch (Exception $e) {
        $wpdb->query('ROLLBACK');
        log_categoria_error("Error guardando caché: " . $e->getMessage());
    } finally {
        delete_transient('nichecreator_cache_updating');
    }
}

///////////////////////////////////////////////////
/////////////// ETIQUETAS //////////////////////////
////////////////////////////////////////////////////

function obtener_cache_etiquetas() {
    $cache = get_transient('cache_etiquetas_ids');
    if ($cache === false) {
        // Si no existe, cargar todas las etiquetas (term_name → term_id)
        $terms = get_terms(['taxonomy' => 'post_tag', 'hide_empty' => false]);
        $cache = [];
        foreach ($terms as $term) {
            $cache[$term->name] = $term->term_id;
        }
        set_transient('cache_etiquetas_ids', $cache, 12 * HOUR_IN_SECONDS);
    }
    return $cache;
}

function guardar_cache_etiquetas($cache) {
    set_transient('cache_etiquetas_ids', $cache, 12 * HOUR_IN_SECONDS);
}

function obtener_o_crear_etiqueta($nombre_etiqueta) {
    $nombre_etiqueta = sanitize_text_field($nombre_etiqueta);
    $cache = obtener_cache_etiquetas();

    if (isset($cache[$nombre_etiqueta])) {
        return $cache[$nombre_etiqueta];
    }

    $tag = tag_exists($nombre_etiqueta);
    if ($tag !== null) {
        $cache[$nombre_etiqueta] = $tag['term_id'];
        guardar_cache_etiquetas($cache);
        return $tag['term_id'];
    }

    $nuevo_tag = wp_insert_term($nombre_etiqueta, 'post_tag', ['description' => $nombre_etiqueta]);
    if (!is_wp_error($nuevo_tag)) {
        $cache[$nombre_etiqueta] = $nuevo_tag['term_id'];
        guardar_cache_etiquetas($cache);
        return $nuevo_tag['term_id'];
    }

    return null;
}

////////////////////////////////////////////////////////////////
///////// CAMPO MULTIESCRAPEO /////////////////////////////////
///////////////////////////////////////////////////////////////
function nichecreator_verificar_escrapeos() {
    global $wpdb;
    $tabla = $wpdb->prefix . 'niche_tabla';
    $columna = 'escrapeo';

    // ¿Existe la columna?
    $columna_existe = $wpdb->get_results(
        $wpdb->prepare(
            "SHOW COLUMNS FROM `$tabla` LIKE %s",
            $columna
        )
    );

    if (empty($columna_existe)) {
        // Agregar la columna al final
        $wpdb->query("ALTER TABLE `$tabla` ADD `$columna` VARCHAR(255) DEFAULT NULL");
    }
	$wpdb->query("ALTER TABLE $tabla MODIFY COLUMN GMapsLink VARCHAR(400)");
	$wpdb->query("ALTER TABLE $tabla MODIFY COLUMN ShareLink VARCHAR(400)");
}

