<?php



add_action( 'init', 'configurar_noindex_para_post_types_personalizados' );

function configurar_noindex_para_post_types_personalizados() {
    $post_types_a_desindexar = ['nicho', 'nichocat'];

    // Si Rank Math está activo
    if ( defined('RANK_MATH_VERSION') ) {
        add_filter( 'rank_math/frontend/robots', function( $robots ) use ( $post_types_a_desindexar ) {
            if ( is_singular( $post_types_a_desindexar ) ) {
                $robots['index'] = 'noindex';
                $robots['follow'] = 'nofollow';
            }
            return $robots;
        });
    }

    // Si Yoast SEO está activo
    elseif ( defined('WPSEO_VERSION') ) {
        add_filter( 'wpseo_robots', function( $robots ) use ( $post_types_a_desindexar ) {
            if ( is_singular( $post_types_a_desindexar ) ) {
                return 'noindex, nofollow';
            }
            return $robots;
        });
    }

    // Si no hay plugin SEO activo, añadir manualmente en wp_head
    else {
        add_action( 'wp_head', function() use ( $post_types_a_desindexar ) {
            if ( is_singular( $post_types_a_desindexar ) ) {
                echo '<meta name="robots" content="noindex, nofollow">' . "\n";
            }
        });
    }
}


/**
* Filter the upload size limit for non-administrators.
*
* @param string $size Upload size limit (in bytes).
* @return int (maybe) Filtered size limit.
*/
function filter_site_upload_size_limit( $size ) {
// 5 MB.
$size = 1024 * 5000;
return $size;
}
//add_filter( 'upload_size_limit', 'filter_site_upload_size_limit', 20 );


//add_filter('wp_handle_upload_prefilter', 'custom_upload_filter' );

function custom_upload_filter( $file ) {
//$file['name'] = 'wordpress-is-awesome-' . $file['name'];
return $file;
}


function wpse_6533_map_unrestricted_upload_filter($caps, $cap) {
  if ($cap == 'unfiltered_upload') {
    $caps = array();
    $caps[] = $cap;
  }
  
  return $caps;
}

//add_filter('map_meta_cap', 'wpse_6533_map_unrestricted_upload_filter',99,2);


 
function wp_actualizar_tabla( $upgrader_object, $options ) {
 $ncplugin = plugin_basename( __FILE__ );
 if( $options['action'] == 'update' && $options['type'] == 'plugin' && isset( $options['plugins'] ) ) {
   foreach( $options['plugins'] as $plugin ) {
   if( $plugin == $ncplugin ) 
		{
		global $wpdb;
		$tabla = $wpdb->prefix."niche_tabla";
		$query = "SHOW COLUMNS FROM $tabla LIKE 'gmapsid'";
		$results = $wpdb->get_results($query);
		if (empty($results))
			{
			$queryID = "ALTER TABLE $tabla ADD gmapsid VARCHAR(255)";
			$resultado = $wpdb->query($queryID);
			$queryKW = "ALTER TABLE $tabla ADD keyword VARCHAR(255)";
			$resultado = $wpdb->query($queryKW);
			}
		}
  }
 }
}
//add_action( 'upgrader_process_complete', 'wp_actualizar_tabla', 10, 2 );
