<?php
add_action('wp_head', 'insertar_schema_negocio');

function insertar_schema_negocio() {
    if ( is_singular() && in_array( get_post_type(), ['page'] )) {
        $post_id = get_the_ID();
        if (get_post_meta($post_id,'nichecreator_categoria',true))
           return;
        // Ejemplo de obtención de campos personalizados (pueden venir del plugin o ACF, etc.)
        $nombre     = get_the_title($post_id);
        $telefono   = get_post_meta($post_id, 'nichecreator_telefono', true);
        $direccion  = get_post_meta($post_id, 'nichecreator_direccion', true);
        $municipio     = get_post_meta($post_id, 'nichecreator_municipio', true);
        $provincia  = get_post_meta($post_id, 'nichecreator_provincia', true);
        $opening_hours   = get_post_meta($post_id, 'nichecreator_horarios', true);
        $country    = get_post_meta($post_id,'nichecreator_country',true);
		
		
$schema_data = [
    "@context" => "https://schema.org",
    "@type" => "LocalBusiness",
    "name" => $nombre,
    "address" => [
        "@type" => "PostalAddress",
        "streetAddress" => $direccion,
        "addressLocality" => $municipio,
        "addressRegion" => $provincia,
        "addressCountry" => $country
    ],
    "telephone" => $telefono,
    "openingHours" => $opening_hours
];

$schema_json = wp_json_encode($schema_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
echo '<script type="application/ld+json">' . $schema_json . '</script>';
	}
}
