<?php
// CREACION DE CATEGORIA.....
add_action( 'category_add_form_fields', 'add_term_fields' );

function add_term_fields( $taxonomy ) {
	?>
		<div class="form-field">
			<label for="textoh1"><?php _e('Texto H1','nichecreator'); ?></label>
			<input type="text" name="textoh1" id="textoh1" />
			<p><?php _e('Texto H1 para el título de la categoría','nichecreator'); ?></p>
		</div>
		<div class="form-field">
			<label for="contenido"><?php _e('Contenido','nichecreator'); ?></label>
			<?php wp_editor('','contenido', array("media_buttons" => true)); ?>
			<p><?php _e('Contenido de la categoría (importado desde plantilla)','nichecreator'); ?></p>
		</div>
		<div class="form-field">
			<label for="parrafoconcconclusion"><?php _e('Conclusión','nichecreator'); ?></label>
			<?php wp_editor('','parrafoconc', array("media_buttons" => true)); ?>
			<p><?php _e('Contenido conclusión de la categoría, parte final','nichecreator'); ?></p>
		</div>
		<div class="form-field">
		<label for="category-image-id"><?php _e('Imagen', 'nichecreator'); ?></label>
     		<input type="hidden" id="category-image-id" name="category-image-id" class="custom_media_url" value="">
     		<div id="category-image-wrapper"></div>
     		 <p>
       		 <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e( 'Añadir Imagen', 'nichecreator' ); ?>" />
       		 <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e( 'Quitar Imagen', 'nichecreator' ); ?>" />
    		</p>
		</div>
	<?php
}

// EDICION DE CATEGORIA....
add_action( 'category_edit_form_fields', 'edit_term_fields', 10, 2 );
function edit_term_fields( $term, $taxonomy ) {

	// get meta data value
	$textoh1 = get_term_meta( $term->term_id, 'textoh1', true );
	$contenido = get_term_meta( $term->term_id, 'contenido', true );
	$conclusion = get_term_meta( $term->term_id, 'conclusion', true );
        $image_id = get_term_meta( $term->term_id, 'imagen', true );
	?><tr class="form-field">
		<th><label for="textoh1"><?php _e('Texto H1','nichecreator'); ?></label></th>
		<td>
			<input name="textoh1" id="textoh1" type="text" value="<?php echo esc_attr( $textoh1 ) ?>" />
			<p class="description"><?php _e('Texto H1 para el título de la categoría','nichecreator'); ?></p>
		</td>
	</tr>
	<tr class="form-field">
		<th>
			<label for="contenido"><?php _e('Contenido','nichecreator'); ?></label>
		</th>
		<td>
			<?php wp_editor($contenido,'contenido', array("media_buttons" => true)); ?>
			<p class="description"><?php _e('Contenido de la categoría (importado desde plantilla)','nichecreator'); ?></p>
		</td>
	</tr>
	<tr class="form-field">
		<th>
			<label for="parrafoconc"><?php _e('Conclusion','nichecreator'); ?></label>
		</th>
		<td>
			<?php wp_editor($conclusion,'parrafoconc', array("media_buttons" => true)); ?>
			<p class="description"><?php _e('Contenido conclusión de la categoría, parte final','nichecreator'); ?></p>
		</td>
	</tr>
	<tr class="form-field">
		<th>
			<label for="category-image-id"><?php _e('Imagen','nichecreator'); ?></label>
		</th>
		<td>
			<input type="hidden" id="category-image-id" name="category-image-id" value="<?php echo $image_id; ?>">
       			<div id="category-image-wrapper">
         		<?php if ( $image_id ) { 
           				echo wp_get_attachment_image ( $image_id, 'thumbnail' ); 
        				    } ?>
       			</div>
       		 <p>
         	<input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e( 'Añadir imagen', 'nichecreator' ); ?>" />
         	<input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e( 'Quitar Imagen', 'nichecreator' ); ?>" />
       		</p>
		</td>
	</tr>
	<?php
}

// GRABACION DE DATOS....
add_action( 'created_category', 'save_term_fields' );
add_action( 'edited_category', 'save_term_fields' );
function save_term_fields( $term_id ) {
	
	update_term_meta(
		$term_id,
		'textoh1',
		sanitize_text_field( $_POST[ 'textoh1' ] )
	);
	update_term_meta(
		$term_id,
		'contenido',
		$_POST[ 'contenido' ]
	);
	update_term_meta(
		$term_id,
		'conclusion',
		$_POST[ 'parrafoconc' ]
	);
	update_term_meta(
		$term_id,
		'imagen',
		$_POST[ 'category-image-id' ]
	);
}


add_action( 'admin_footer', 'add_script');


/* * Add script * @since 1.0.0  */

 function add_script() { ?>
   <script>
     jQuery(document).ready( function($) {
       function ct_media_upload(button_class) {
         var _custom_media = true,
         _orig_send_attachment = wp.media.editor.send.attachment;
         $('body').on('click', button_class, function(e) {
           var button_id = '#'+$(this).attr('id');
           var send_attachment_bkp = wp.media.editor.send.attachment;
           var button = $(button_id);
           _custom_media = true;
           wp.media.editor.send.attachment = function(props, attachment){
             if ( _custom_media ) {
               $('#category-image-id').val(attachment.id);
               $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
               $('#category-image-wrapper .custom_media_image').attr('src',attachment.url).css('display','block');
             } else {
               return _orig_send_attachment.apply( button_id, [props, attachment] );
             }
            }
         wp.media.editor.open(button);
         return false;
       });
     }
     ct_media_upload('.ct_tax_media_button.button'); 
     $('body').on('click','.ct_tax_media_remove',function(){
       $('#category-image-id').val('');
       $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
     });
     // Thanks: https://stackoverflow.com/questions/15281995/wordpress-create-category-ajax-response
     $(document).ajaxComplete(function(event, xhr, settings) {
       var queryStringArr = settings.data.split('&');
       if( $.inArray('action=add-tag', queryStringArr) !== -1 ){
         var xml = xhr.responseXML;
         $response = $(xml).find('term_id').text();
         if($response!=""){
           // Clear the thumb image
           $('#category-image-wrapper').html('');
         }
       }
     });
   });
 </script>
 <?php }

