<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Toolteam extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_toolteam';
    public $icon         = 'ion-md-people';
    public $scripts      = ['next_toolteam'];

    public function get_label() {
        return esc_html__( 'Toolteam', 'bricks' );
    }

    public function set_controls() {
        $this->controls['members'] = [
            'tab' => 'content',
            'label' => esc_html__('Team Members', 'bricks'),
            'type' => 'repeater',
            'titleProperty' => 'name',
            'fields' => [
                'name' => [
                    'label' => esc_html__('Name', 'bricks'),
                    'type' => 'text',
                ],
                'role' => [
                    'label' => esc_html__('Role', 'bricks'), 
                    'type' => 'text',
                ],
                'avatar' => [
                    'label' => esc_html__('Avatar', 'bricks'),
                    'type' => 'image',
                ],
                'alt' => [
                    'label' => esc_html__('Image Alt Text', 'bricks'),
                    'type' => 'text',
                ]
            ],
            'default' => [
                [
                    'name' => 'Alex Chen',
                    'role' => 'Software Engineer',
                    'avatar' => [
                        'url' => 'https://i.pravatar.cc/150?img=13',
                    ],
                    'alt' => 'Alex Chen'
                ]
            ]
        ];

        // Toolteam Settings
        $this->controls['toolteamSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Toolteam', 'bricks'),
            'type' => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'default' => 'fit-content',
        ];
        $this->controls['negativeGap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Horizontal Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--negative-horizontal-gap',
                'selector' => '',
              ]
            ],
            'default' => '-12px',
        ];
        $this->controls['negativeVerticalGap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Vertical Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--negative-vertical-gap',
                'selector' => '',
              ]
            ],
        ];

        // Avatar Settings
        $this->controls['avatarSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Avatar', 'bricks'),
            'type' => 'separator',
        ];
        $this->controls['avatarDimensions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--avatar-dimensions',
                'selector' => '',
              ]
            ],
            'default' => '56px',
        ];
        $this->controls['avatarBorder'] = [
            'tab' => 'content',
            'label' => esc_html__('Border', 'bricks'),
            'type' => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.next-toolteam__avatar',
                ],
            ],
            'default' => [
                'width' => [
                    'top' => 2,
                    'right' => 2,
                    'bottom' => 2,
                    'left' => 2,
                ],
                'color' => [
                    'hex' => '#333333',
                ],
                'style' => 'solid',
                'radius' => [
                  'top' => '50%',
                  'right' => '50%',
                  'bottom' => '50%',
                  'left' => '50%',
                ],
            ],
        ];

        // Tooltip Settings
        $this->controls['tooltipSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Tooltip', 'bricks'),
            'type' => 'separator',
        ];

        $this->controls['tooltipPadding'] = [
            'tab' => 'content',
            'label' => esc_html__('Padding', 'bricks'),
            'type' => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.next-toolteam__tooltip',
                ],
            ],
            'default' => [
                'top' => 8,
                'right' => 16,
                'bottom' => 8,
                'left' => 16,
            ],
        ];

        $this->controls['tooltipTop'] = [
            'tab' => 'content',
            'label' => esc_html__('Top Position', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'top',
                    'selector' => '.next-toolteam__tooltip',
                ],
            ],
            'default' => '-64px',
        ];

        $this->controls['tooltipGap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '.next-toolteam__tooltip',
              ]
            ],
            'default' => '4px',
        ];

        $this->controls['tooltipTypography'] = [
            'tab' => 'content',
            'label' => esc_html__('Typography', 'bricks'),
            'type' => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.next-toolteam__tooltip',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ],
                'font-size' => '14px',
            ],
        ];

        $this->controls['tooltipBackground'] = [
            'tab' => 'content',
            'label' => esc_html__('Background', 'bricks'),
            'type' => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.next-toolteam__tooltip',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#333333',
                ],
            ],
        ];

        $this->controls['tooltipBorder'] = [
            'tab' => 'content',
            'label' => esc_html__('Border', 'bricks'),
            'type' => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.next-toolteam__tooltip',
                ],
            ],
            'default' => [
                'radius' => [
                  'top' => 6,
                  'right' => 6,
                  'bottom' => 6,
                  'left' => 6,
                ],
            ],
        ];

        // Arrow Settings
        $this->controls['arrowSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Arrow', 'bricks'),
            'type' => 'separator',
        ];

        $this->controls['arrowColor'] = [
            'tab' => 'content', 
            'label' => esc_html__('Color', 'bricks'),
            'type' => 'color',
            'css' => [
                [
                    'property' => '--tooltip-arrow-color',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#333333',
            ],
        ];

        $this->controls['arrowDimensions'] = [
            'tab' => 'content',
            'label' => esc_html__('Dimensions', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => '--tooltip-arrow-dimensions',
                    'selector' => '',
                ],
            ],
            'default' => '5px',
        ];

        $this->controls['arrowBottom'] = [
            'tab' => 'content',
            'label' => esc_html__('Bottom Offset', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => '--tooltip-arrow-bottom',
                    'selector' => '',
                ],
            ],
            'default' => '-4px',
        ];

        // Name & Role Settings
        $this->controls['nameandroleSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Name & Role', 'bricks'),
            'type' => 'separator',
        ];
        $this->controls['nameTypography'] = [
            'tab' => 'content',
            'label' => esc_html__('Name Typography', 'bricks'),
            'type' => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.next-toolteam__name',
                ],
            ],
            'default' => [
                'font-size' => '16px',
                'font-weight' => '700',
            ],
        ];
        $this->controls['roleTypography'] = [
            'tab' => 'content',
            'label' => esc_html__('Role Typography', 'bricks'),
            'type' => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.next-toolteam__role',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#999',
                ],
                'font-size' => '12px',
            ],
        ];

        // Animation Settings
        $this->controls['animationSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Tooltip Animation', 'bricks'),
            'type' => 'separator',
        ];
        $this->controls['tooltipFadeDuration'] = [
            'tab' => 'content',
            'label' => esc_html__('Fade Duration', 'bricks'),
            'type' => 'number',
            'units' => 's',
            'css' => [
                [
                    'property' => '--tooltip-fade-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.2s',
        ];

        $this->controls['tooltipFadeEasing'] = [
            'tab' => 'content',
            'label' => esc_html__('Fade CSS Easing', 'bricks'),
            'type' => 'text',
            'css' => [
                [
                    'property' => '--tooltip-fade-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'ease-in-out',
        ];

        $this->controls['tooltipScaleFrom'] = [
            'tab' => 'content',
            'label' => esc_html__('Scale From', 'bricks'),
            'type' => 'number',
            'css' => [
                [
                    'property' => '--tooltip-scale-from',
                    'selector' => '',
                ],
            ],
            'default' => '0.7',
        ];

        $this->controls['tooltipScaleDuration'] = [
            'tab' => 'content',
            'label' => esc_html__('Scale Duration', 'bricks'),
            'type' => 'number',
            'units' => 's',
            'css' => [
                [
                    'property' => '--tooltip-scale-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.1s',
        ];

        $this->controls['tooltipScaleEasing'] = [
            'tab' => 'content',
            'label' => esc_html__('Scale CSS Easing', 'bricks'),
            'type' => 'text',
            'css' => [
                [
                    'property' => '--tooltip-scale-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_toolteam', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_toolteam.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;

        $this->set_attribute('_root', 'class', "next-toolteam");

        $output = "<div {$this->render_attributes('_root')}>";

        // Render team members if they exist
        if (!empty($settings['members'])) {
            foreach ($settings['members'] as $member) {
                $output .= '<div class="next-toolteam__member">';
                $output .= '<div class="next-toolteam__tooltip">';
                $output .= '<div class="next-toolteam__name">' . esc_html($member['name']) . '</div>';
                $output .= '<div class="next-toolteam__role">' . esc_html($member['role']) . '</div>';
                $output .= '</div>';
                
                // Get image URL from avatar array or use directly if string
                $image_url = is_array($member['avatar']) ? $member['avatar']['url'] : $member['avatar'];
                $alt_text = !empty($member['alt']) ? esc_attr($member['alt']) : esc_attr($member['name']);
                
                $output .= '<img src="' . esc_url($image_url) . '" alt="' . $alt_text . '" class="next-toolteam__avatar">';
                $output .= '</div>';
            }
        }

        $output .= "</div>";

        echo $output;
    }
}