<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Ripple_Button_V5 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-ripple-button-v5';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Ripple Button v5', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Ripple Button v5', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-ripple-button-v5__inner',
            ],
        ],
        'default' => [
            'top'    => 12,
            'right'  => 16, 
            'bottom' => 12,
            'left'   => 16,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['swapTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Swap Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-ripple-button-v5__inner::after',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-ripple-button-v5__bg',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-ripple-button-v5__bg',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['rippleAnimationSeparator'] = [
        'label'      => esc_html__( 'Ripple Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['layer1Color'] = [
        'tab'     => 'content',
        'label'   => esc_html__('First Color', 'bricks'),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--first-ripple--color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#2d8af4',
        ],
    ];
    $this->controls['layer2Color'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Second Color', 'bricks'),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--second-ripple--color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#000',
        ],
    ];
    $this->controls['rippleDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Duration', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--ripple-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.45s',
    ];
    $this->controls['ripplesStagger'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Stagger', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--ripples-stagger',
                'selector' => '',
            ],
        ],
        'default' => '0.064s',
    ];

    $this->controls['swapAnimationSeparator'] = [
        'label'      => esc_html__( 'Swap Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['lineTransformDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Duration', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--text-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.75s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Ripple Button v5';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-ripple-button-v5' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-ripple-button-v5__bg'>
            <span style='--index: 0' class='nb-ripple-button-v5__bg-inner nb-ripple-button-v5__bg-inner--first'></span>
            <span style='--index: 1' class='nb-ripple-button-v5__bg-inner nb-ripple-button-v5__bg-inner--second'></span>
        </span>
        <span data-text='$inner_title' class='nb-ripple-button-v5__inner'>
            <span class='nb-ripple-button-v5__text'>$inner_title</span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}