<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Reel_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-reel-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Reel Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Reel Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-reel-button__inner',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-reel-button__bg',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-reel-button__bg',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['reelSeparator'] = [
        'label'      => esc_html__( 'Reel', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['reelTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-reel-button__inner-hover::after',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['reelTranslate'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Translate', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--reel-translate',
                'selector' => '',
            ],
        ],
        'default' => '10px',
    ];
    $this->controls['reelDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--reel-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.45s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Reel Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-reel-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-reel-button__bg'></span>
        <span class='nb-reel-button__container'>
            <span class='nb-reel-button__inner'>
                <span class='nb-reel-button__text'>$inner_title</span>
            </span>
            <div data-text='$inner_title' class='nb-reel-button__inner-hover'></div>
            <div data-text='$inner_title' class='nb-reel-button__inner-hover nb-reel-button__inner-hover--is-second'></div>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}