<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Physics_Element extends \Bricks\Element {
  public $name         = 'next_physics_element';
  public $icon         = 'fas fa-cube';
  public $tag          = 'div';
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Physics Element', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'section' => 'section',
            'article' => 'article',
            'aside' => 'aside',
            'header' => 'header',
            'footer' => 'footer',
            'main' => 'main',
            'nav' => 'nav',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    // Physics Settings
    $this->controls['physicsSeparator'] = [
        'label'      => esc_html__( 'Physics Settings', 'bricks' ),
        'type'       => 'separator',
        'tab'        => 'content',
    ];

    $this->controls['linkURL'] = [
        'type'       => 'text',
        'label'      => esc_html__( 'Link URL', 'bricks' ),
        'tab'        => 'content',
        'placeholder' => 'https://www.nextbricks.io',
    ];
    $this->controls['openNewTab'] = [
        'type'       => 'checkbox',
        'label'      => esc_html__( 'Open in new tab', 'bricks' ),
        'tab'        => 'content',
        'default'    => false,
    ];

    $this->controls['static'] = [
        'type'       => 'checkbox',
        'label'      => esc_html__( 'Static', 'bricks' ),
        'tab'        => 'content',
        'default'    => false,
    ];

    $this->controls['restitution'] = [
        'type'       => 'number',
        'label'      => esc_html__( 'Restitution', 'bricks' ),
        'tab'        => 'content',
        'step'       => 0.01,
        'min'        => 0,
        'max'        => 1,
        'placeholder' => '0.3',
    ];

    $this->controls['friction'] = [
        'type'       => 'number',
        'label'      => esc_html__( 'Friction', 'bricks' ),
        'tab'        => 'content',
        'step'       => 0.01,
        'min'        => 0,
        'max'        => 1,
        'placeholder' => '0.1',
    ];

    $this->controls['frictionAir'] = [
        'type'       => 'number',
        'label'      => esc_html__( 'Air Friction', 'bricks' ),
        'tab'        => 'content',
        'step'       => 0.001,
        'min'        => 0,
        'max'        => 0.1,
        'placeholder' => '0.01',
    ];

    $this->controls['density'] = [
        'type'       => 'number',
        'label'      => esc_html__( 'Density', 'bricks' ),
        'tab'        => 'content',
        'step'       => 0.0001,
        'min'        => 0.0001,
        'max'        => 1,
        'placeholder' => '0.001',
    ];
  }

  public function render() {
    $settings = $this->settings;

    // Get physics settings
    $linkURL = isset( $settings['linkURL'] ) ? $settings['linkURL'] : '';
    $openNewTab = isset( $settings['openNewTab'] ) && $settings['openNewTab'] ? '1' : '0';
    $static = isset( $settings['static'] ) && $settings['static'] ? '1' : '0';
    $restitution = isset( $settings['restitution'] ) ? $settings['restitution'] : '0.3';
    $friction = isset( $settings['friction'] ) ? $settings['friction'] : '0.1';
    $frictionAir = isset( $settings['frictionAir'] ) ? $settings['frictionAir'] : '0.01';
    $density = isset( $settings['density'] ) ? $settings['density'] : '0.001';

    // Add the physics element class
    $this->set_attribute( '_root', 'class', 'next-physics__physics-element' );
    
    // Add physics data attributes
    $this->set_attribute( '_root', 'data-physics-static', $static );
    $this->set_attribute( '_root', 'data-physics-restitution', $restitution );
    $this->set_attribute( '_root', 'data-physics-friction', $friction );
    $this->set_attribute( '_root', 'data-physics-friction-air', $frictionAir );
    $this->set_attribute( '_root', 'data-physics-density', $density );

    // Handle link
    if ( ! empty( $linkURL ) ) {
        // Store link data for physics engine
        if ( isset( $linkURL ) ) {
            $this->set_attribute( '_root', 'data-physics-link', $linkURL );
        }
        if ( isset( $openNewTab ) && $openNewTab ) {
            $this->set_attribute( '_root', 'data-physics-link-target', '_blank' );
        }
    }
    
    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

    echo $output;
  }
}